/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

public class CircularStatistics {
    public final double CSTE = Math.PI / 180;
    private double Epsilon = 1.0E-6;
    protected double Average = 0.0;
    protected double Length = 0.0;
    protected double Variance = 0.0;
    protected double StandardDeviation = 0.0;
    protected double Kurtosis = 0.0;
    protected double Skewness = 0.0;
    protected double Dispersion = 0.0;

    public void ComputeDegres(double[] Tab) {
        int size = Tab.length;
        int i2 = 0;
        while (i2 < size) {
            int n = i2++;
            Tab[n] = Tab[n] * (Math.PI / 180);
        }
        this.ComputeRadians(Tab);
        i2 = 0;
        while (i2 < size) {
            int n = i2++;
            Tab[n] = Tab[n] / (Math.PI / 180);
        }
    }

    public void ComputeRadians(double[] Tab) {
        int i2;
        int size = Tab.length;
        this.Skewness = 0.0;
        this.Kurtosis = 0.0;
        this.Variance = 0.0;
        double sumy = 0.0;
        double sumx = 0.0;
        for (i2 = 0; i2 < size; ++i2) {
            sumx += Math.cos(Tab[i2]);
            sumy += Math.sin(Tab[i2]);
        }
        this.Length = Math.sqrt((sumx /= (double)size) * sumx + (sumy /= (double)size) * sumy);
        this.Average = Math.abs(sumx) < this.Epsilon && sumy > 0.0 ? 1.5707963267948966 : (Math.abs(sumx) < this.Epsilon && sumy < 0.0 ? 4.71238898038469 : (sumx > 0.0 && Math.abs(sumy) < this.Epsilon ? 0.0 : (sumx < 0.0 && Math.abs(sumy) < this.Epsilon ? Math.PI : (Math.abs(sumx) < this.Epsilon && Math.abs(sumy) < this.Epsilon ? Double.NaN : (sumx < 0.0 && sumy > 0.0 ? Math.atan(sumy / sumx) + Math.PI : (sumx > 0.0 && sumy < 0.0 ? Math.atan(sumy / sumx) + Math.PI * 2 : (sumx < 0.0 && sumy < 0.0 ? Math.atan(sumy / sumx) + Math.PI : Math.atan(sumy / sumx))))))));
        if (this.Average < 0.0) {
            this.Average += Math.PI * 2;
        }
        for (i2 = 0; i2 < size; ++i2) {
            double v1 = this.Average - Tab[i2];
            double v2 = Tab[i2] - this.Average;
            double v3 = Math.PI * 2 - this.Average + Tab[i2];
            double v4 = Math.PI * 2 - Tab[i2] + this.Average;
            double val = Math.PI * 2;
            if (v1 >= 0.0) {
                val = Math.min(val, v1);
            }
            if (v2 >= 0.0) {
                val = Math.min(val, v2);
            }
            if (v3 >= 0.0) {
                val = Math.min(val, v3);
            }
            if (v4 >= 0.0) {
                val = Math.min(val, v4);
            }
            this.Variance += Math.pow(val, 2.0);
            this.Skewness += Math.pow(val, 3.0);
            this.Kurtosis += Math.pow(val, 4.0);
        }
        this.Variance /= (double)size;
        this.StandardDeviation = Math.sqrt(this.Variance);
        this.Skewness /= (double)size * Math.pow(this.StandardDeviation, 3.0);
        this.Kurtosis /= (double)size * Math.pow(this.Variance, 2.0);
        double cosave = Math.cos(this.Average);
        double sinave = Math.sin(this.Average);
        sumy = 0.0;
        sumx = 0.0;
        for (i2 = 0; i2 < size; ++i2) {
            sumx += Math.pow(Math.cos(Tab[i2]) - cosave, 2.0);
            sumy += Math.pow(Math.sin(Tab[i2]) - sinave, 2.0);
        }
        this.Dispersion = Math.sqrt((sumx + sumy) / (double)size);
    }

    public double getAverage() {
        return this.Average;
    }

    public double getLength() {
        return this.Length;
    }

    public double getVariance() {
        return this.Variance;
    }

    public double getStandardDeviation() {
        return this.StandardDeviation;
    }

    public double getKurtosis() {
        return this.Kurtosis;
    }

    public double getSkewness() {
        return this.Skewness;
    }

    public double getDispersion() {
        return this.Dispersion;
    }

    public void Precision(double Precision) {
        if (Precision <= 0.0) {
            throw new IllegalArgumentException("Precision must be positive.");
        }
        this.Epsilon = Precision;
    }
}

