/*
 * Decompiled with CFR 0.152.
 */
package mathematics.statistics;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;

public final class CenterReduce {
    public static void Compute(int[] Data, double[] Result) {
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(Data);
        CenterReduce.Compute(Data, AF.Average(), AF.StandardDeviation(), Result);
    }

    public static void Compute(int[] Data, double average, double sd, double[] Result) {
        for (int j = 0; j < Data.length; ++j) {
            Result[j] = ((double)Data[j] - average) / sd;
        }
    }

    public static void Compute(double[] Data) {
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(Data);
        CenterReduce.Compute(Data, AF.Average(), AF.SampleStandardDeviation(), Data);
    }

    public static void Compute(double[] Data, double[] Result) {
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(Data);
        CenterReduce.Compute(Data, AF.Average(), AF.SampleStandardDeviation(), Result);
    }

    public static void Compute(double[] Data, double average, double sd, double[] Result) {
        for (int j = 0; j < Data.length; ++j) {
            Result[j] = (Data[j] - average) / sd;
        }
    }

    public static void Compute(float[] Data) {
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(Data);
        double ave = AF.Average();
        double sd = AF.SampleStandardDeviation();
        for (int j = 0; j < Data.length; ++j) {
            Data[j] = (float)(((double)Data[j] - ave) / sd);
        }
    }

    public static void Compute(float[] Data, float[] Result) {
        ArrayFeatures AF = new ArrayFeatures();
        AF.Moments(Data);
        CenterReduce.Compute(Data, (float)AF.Average(), (float)AF.SampleStandardDeviation(), Result);
    }

    public static void Compute(float[] Data, float average, float sd, float[] Result) {
        for (int j = 0; j < Data.length; ++j) {
            Result[j] = (float)(((double)Data[j] - (double)average) / (double)sd);
        }
    }

    public static void Compute(double[][] Data) {
        int Largeur = Data[0].length;
        int Hauteur = Data.length;
        double[] buffer = new double[Hauteur];
        for (int i2 = 0; i2 < Largeur; ++i2) {
            int j;
            for (j = 0; j < Hauteur; ++j) {
                buffer[j] = Data[j][i2];
            }
            CenterReduce.Compute(buffer);
            for (j = 0; j < Hauteur; ++j) {
                Data[j][i2] = buffer[j];
            }
        }
    }

    public void Compute(float[][] Data) {
        int Largeur = Data[0].length;
        int Hauteur = Data.length;
        float[] buffer = new float[Hauteur];
        for (int i2 = 0; i2 < Largeur; ++i2) {
            int j;
            for (j = 0; j < Hauteur; ++j) {
                buffer[j] = Data[j][i2];
            }
            CenterReduce.Compute(buffer);
            for (j = 0; j < Hauteur; ++j) {
                Data[j][i2] = buffer[j];
            }
        }
    }

    public static void ComputeDouble(FichierTabule fichier) {
        int Largeur = fichier.Width();
        for (int i2 = 0; i2 < Largeur; ++i2) {
            if (fichier.isExcludedColumn(i2) || fichier.ColumnType(i2) != 1) continue;
            double[] Tab = fichier.getColumnDouble(i2);
            CenterReduce.Compute(Tab);
            Object var3_3 = null;
        }
    }

    public static void ComputeDouble(FichierTabule fichier, double[] averages, double[] sd) {
        int i2;
        int Largeur = fichier.Width();
        int nb = 0;
        for (i2 = 0; i2 < Largeur; ++i2) {
            if (fichier.ColumnType(i2) != 1) continue;
            ++nb;
        }
        if (averages.length != sd.length) {
            throw new IllegalArgumentException("averages.length != sd.length");
        }
        if (nb != averages.length) {
            throw new IllegalArgumentException("The number of Double columns into the file is different from the arrays length.");
        }
        nb = 0;
        for (i2 = 0; i2 < Largeur; ++i2) {
            if (fichier.isExcludedColumn(i2) || fichier.ColumnType(i2) != 1) continue;
            double[] Tab = fichier.getColumnDouble(i2);
            CenterReduce.Compute(Tab, averages[nb], sd[nb], Tab);
            ++nb;
            Tab = null;
        }
    }

    public static FichierTabule Compute(FichierTabule file) {
        int Largeur = file.Width();
        int Hauteur = file.Height();
        FichierTabule res = null;
        int[] TypeColonnes = (int[])file.ColumnType().clone();
        ArrayComparator.Compare((int[])TypeColonnes, (String)"!=", (int)0, (int[])TypeColonnes, (int)1, (int[])TypeColonnes);
        res = new FichierTabule(Hauteur, TypeColonnes, file.Name() + "_CenteredReduced");
        block5: for (int x = 0; x < Largeur; ++x) {
            switch (file.ColumnType(x)) {
                case 1: {
                    System.arraycopy(file.getColumnDouble(x), 0, res.getColumnDouble(x), 0, Hauteur);
                    continue block5;
                }
                case 0: {
                    ArrayConverter.IntToDouble((int[])file.getColumnInt(x), (double[])res.getColumnDouble(x));
                    continue block5;
                }
                case 2: {
                    System.arraycopy(file.getColumnString(x), 0, res.getColumnString(x), 0, Hauteur);
                    continue block5;
                }
            }
        }
        TypeColonnes = null;
        res.setExcluded(file.getExcluded());
        res.setExcludedColumn(file.getExcludedColumn());
        res.setNominal(file.getNominal());
        res.setColumnsNames(file.getColumnsNames());
        CenterReduce.ComputeDouble(res);
        return res;
    }

    public static FichierTabule Compute(FichierTabule file, double[] averages, double[] sd) {
        int Largeur = file.Width();
        int Hauteur = file.Height();
        FichierTabule res = null;
        int[] TypeColonnes = (int[])file.ColumnType().clone();
        ArrayComparator.Compare((int[])TypeColonnes, (String)"!=", (int)0, (int[])TypeColonnes, (int)1, (int[])TypeColonnes);
        res = new FichierTabule(Hauteur, TypeColonnes, file.Name() + "_CenteredReduced");
        block5: for (int x = 0; x < Largeur; ++x) {
            switch (file.ColumnType(x)) {
                case 1: {
                    System.arraycopy(file.getColumnDouble(x), 0, res.getColumnDouble(x), 0, Hauteur);
                    continue block5;
                }
                case 0: {
                    ArrayConverter.IntToDouble((int[])file.getColumnInt(x), (double[])res.getColumnDouble(x));
                    continue block5;
                }
                case 2: {
                    System.arraycopy(file.getColumnString(x), 0, res.getColumnString(x), 0, Hauteur);
                    continue block5;
                }
            }
        }
        TypeColonnes = null;
        res.setExcluded(file.getExcluded());
        res.setExcludedColumn(file.getExcludedColumn());
        res.setNominal(file.getNominal());
        CenterReduce.ComputeDouble(res, averages, sd);
        return res;
    }
}

