/*
 * Decompiled with CFR 0.152.
 */
package mathematics.primitives.pointsTiTi;

import displays.Color;
import imageTiTi.ImageDrawer;
import java.awt.image.BufferedImage;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointI;

public class PointND
implements Point {
    protected double[] Coordonnees = null;
    protected int Dimension = 0;
    protected int HauteurCadre;
    protected int Type;
    protected int ListeGL = -1;
    protected float Transparence;
    protected float Taille;
    protected boolean Visible = true;
    protected boolean affichable = true;
    protected Color couleur = null;
    protected String Nom = null;

    public PointND() {
    }

    public PointND(int Dimension2) {
        this.setDimension(Dimension2);
    }

    public PointND(double x, double y) {
        this.setDimension(2);
        this.Coordonnees[0] = x;
        this.Coordonnees[1] = y;
    }

    public PointND(double x, double y, double z) {
        this.setDimension(3);
        this.Coordonnees[0] = x;
        this.Coordonnees[1] = y;
        this.Coordonnees[2] = z;
    }

    public PointND(float[] Coordonnees) {
        this.Dimension = Coordonnees.length;
        this.Coordonnees = new double[this.Dimension];
        for (int i2 = 0; i2 < this.Dimension; ++i2) {
            this.Coordonnees[i2] = Coordonnees[i2];
        }
    }

    public PointND(double[] Coordonnees) {
        this.Dimension = Coordonnees.length;
        this.Coordonnees = new double[this.Dimension];
        System.arraycopy(Coordonnees, 0, this.Coordonnees, 0, this.Dimension);
    }

    public PointND(Point p) {
        this.Dimension = p.Size();
        this.Coordonnees = (double[])p.get().clone();
    }

    public PointND(PointI p) {
        this.setDimension(p.Size());
        for (int i2 = 0; i2 < this.Dimension; ++i2) {
            this.Coordonnees[i2] = p.get(i2);
        }
    }

    public void setDimension(int Dimension2) {
        if (Dimension2 < 1) {
            throw new IllegalArgumentException("Bad value of dimension: " + Dimension2 + " (wished > 0).");
        }
        this.Dimension = Dimension2;
        this.Coordonnees = null;
        this.Coordonnees = new double[Dimension2];
    }

    public void Draw(BufferedImage image, float[] color, int order) {
        if (this.Dimension != 2) {
            throw new Error("Point dimension different of 2.");
        }
        ImageDrawer imdraw = new ImageDrawer();
        ImageDrawer.Point(image, (int)this.Coordonnees[0], (int)this.Coordonnees[1], order, color);
        imdraw = null;
    }

    public double getX() {
        return this.Coordonnees[0];
    }

    public double getY() {
        return this.Coordonnees[1];
    }

    public double getZ() {
        return this.Coordonnees[2];
    }

    public double[] get() {
        return this.Coordonnees;
    }

    public double get(int x) {
        return this.Coordonnees[x];
    }

    public void set(int index, double value) {
        this.Coordonnees[index] = value;
    }

    public void set(double[] values) {
        if (values.length != this.Dimension) {
            throw new IllegalArgumentException("Array length and dimension of this point are different.");
        }
        this.Coordonnees = (double[])values.clone();
    }

    public void setX(double X) {
        this.Coordonnees[0] = X;
    }

    public void setY(double Y) {
        this.Coordonnees[1] = Y;
    }

    public void setZ(double Z) {
        this.Coordonnees[2] = Z;
    }

    public void setXY(double X, double Y) {
        this.Coordonnees[0] = X;
        this.Coordonnees[1] = Y;
    }

    public void setXYZ(double X, double Y, double Z) {
        this.Coordonnees[0] = X;
        this.Coordonnees[1] = Y;
        this.Coordonnees[2] = Z;
    }

    public int Dimension() {
        return this.Dimension;
    }

    public int Size() {
        return this.Dimension;
    }

    public void Add(double x) {
        int i2 = 0;
        while (i2 < this.Dimension) {
            int n = i2++;
            this.Coordonnees[n] = this.Coordonnees[n] + x;
        }
    }

    public void Add(double[] x) {
        if (x.length != this.Dimension) {
            throw new IllegalArgumentException("Array length and dimension of this point are different.");
        }
        for (int i2 = 0; i2 < this.Dimension; ++i2) {
            int n = i2;
            this.Coordonnees[n] = this.Coordonnees[n] + x[i2];
        }
    }

    public void Times(double x) {
        int i2 = 0;
        while (i2 < this.Dimension) {
            int n = i2++;
            this.Coordonnees[n] = this.Coordonnees[n] * x;
        }
    }

    public boolean Equal(Point p, double Epsilon) {
        if (p.Size() != this.Dimension) {
            return false;
        }
        for (int i2 = 0; i2 < this.Dimension; ++i2) {
            if (!(Math.abs(p.get(i2) - this.Coordonnees[i2]) > Epsilon)) continue;
            return false;
        }
        return true;
    }

    public Point Clone() {
        return new PointND(this.Coordonnees);
    }
}

