/*
 * Decompiled with CFR 0.152.
 */
package mathematics.primitives.pointsTiTi;

import imageTiTi.ImageDrawer;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mathematics.primitives.pointsTiTi.PointI;
import mathematics.primitives.pointsTiTi.PointIntND;

public class PointIManager {
    public static final int SUCCESS = 1;
    public static final int FAILURE = -1;
    protected int TakenPoint = -1;
    protected int CaptureZone = 0;
    protected List<PointI> Liste = new Vector<PointI>(113);
    private String Nom = null;

    public PointIManager(String Nom) {
        this.Nom = Nom.substring(0);
    }

    public PointIManager(int Taille, int Dimension2, String Nom) {
        for (int i2 = 0; i2 < Taille; ++i2) {
            this.Liste.add((PointI)new PointIntND(Dimension2));
        }
        this.Nom = Nom.substring(0);
    }

    public int Find(PointI point) {
        return this.Find(point.getX(), point.getY(), point.getZ());
    }

    public int Find(int x, int y) {
        return this.Find(x, y, 0);
    }

    public int Find(int x, int y, int z) {
        PointI point = null;
        for (int i2 = this.Liste.size() - 1; i2 >= 0; --i2) {
            point = this.Liste.get(i2);
            if (point.getX() >= x - this.CaptureZone && point.getX() <= x + this.CaptureZone && point.getY() >= y - this.CaptureZone && point.getY() <= y + this.CaptureZone && point.getZ() >= z - this.CaptureZone && point.getZ() <= z + this.CaptureZone) {
                return i2;
            }
            point = null;
        }
        return -1;
    }

    public int NewPoint(PointI point) {
        if (this.Find(point.getX(), point.getY(), point.getZ()) != -1) {
            return -1;
        }
        return this.InsertPointAt(this.Liste.size(), point.getX(), point.getY(), point.getZ());
    }

    public int NewPoint(int x, int y) {
        return this.NewPoint(x, y, 0);
    }

    public int NewPoint(int x, int y, int z) {
        if (this.Find(x, y, z) != -1) {
            return -1;
        }
        return this.InsertPointAt(this.Liste.size(), x, y, z);
    }

    public int InsertPointAt(int index, PointI point) {
        if (index > this.Liste.size() || index < 0) {
            return -1;
        }
        this.Liste.add(index, point);
        return 1;
    }

    public int InsertPointAt(int index, int x, int y) {
        return this.InsertPointAt(index, x, y, 0);
    }

    public int InsertPointAt(int index, int x, int y, int z) {
        if (index > this.Liste.size() || index < 0) {
            return -1;
        }
        this.Liste.add(index, (PointI)new PointIntND(x, y, z));
        return 1;
    }

    public int Add(int x, int y) {
        this.Liste.add((PointI)new PointIntND(x, y));
        return 1;
    }

    public int Add(int x, int y, int z) {
        this.Liste.add((PointI)new PointIntND(x, y, z));
        return 1;
    }

    public int Add(PointI point) throws CloneNotSupportedException {
        this.Liste.add(point.Clone());
        return 1;
    }

    public int setPoint(int index, int x, int y) {
        return this.setPoint(index, x, y, 0);
    }

    public int setPoint(int index, int x, int y, int z) {
        if (index > this.Liste.size() || index < 0) {
            return -1;
        }
        PointI p = this.Liste.get(index);
        p.setXYZ(x, y, z);
        return 1;
    }

    public int Remove(int index) {
        if (index >= this.Liste.size() || index < 0) {
            return -1;
        }
        this.Liste.remove(index);
        return 1;
    }

    public void RemoveAll() {
        this.Liste.clear();
    }

    public void Draw(BufferedImage image, float[] color, int order) {
        ImageDrawer imdraw = new ImageDrawer();
        for (int i2 = 0; i2 < this.Liste.size(); ++i2) {
            ImageDrawer.Point(image, this.Liste.get(i2).getX(), this.Liste.get(i2).getY(), order, color);
        }
        imdraw = null;
    }

    public void Display() {
        System.out.print("Liste des points : ");
        for (int i2 = 0; i2 < this.Liste.size(); ++i2) {
            System.out.print("(" + this.Liste.get(i2).getX() + "," + this.Liste.get(i2).getY() + "," + this.Liste.get(i2).getZ() + ") ");
        }
        System.out.println();
    }

    public Iterator<PointI> Iterator() {
        return this.Liste.iterator();
    }

    public int NbPoints() {
        return this.Liste.size();
    }

    public int Size() {
        return this.Liste.size();
    }

    public int CaptureZone() {
        return this.CaptureZone;
    }

    public void CaptureZone(int CaptureZone) {
        if (CaptureZone >= 0) {
            this.CaptureZone = CaptureZone;
        }
    }

    public PointI Point(int index) {
        return this.Liste.get(index);
    }

    public int getX(int index) {
        return this.Liste.get(index).getX();
    }

    public void setX(int index, int x) {
        this.Liste.get(index).setX(x);
    }

    public int getY(int index) {
        return this.Liste.get(index).getY();
    }

    public void setY(int index, int y) {
        this.Liste.get(index).setY(y);
    }

    public int getZ(int index) {
        return this.Liste.get(index).getZ();
    }

    public void setZ(int index, int z) {
        this.Liste.get(index).setZ(z);
    }

    public int TakenPoint() {
        return this.TakenPoint;
    }

    public void TakenPoint(int TakenPoint) {
        this.TakenPoint = TakenPoint;
    }

    public List<PointI> Points() {
        return this.Liste;
    }

    public String getName() {
        return this.Nom;
    }

    public void setName(String Nom) {
        this.Nom = Nom;
    }

    public String toString() {
        return this.Nom;
    }
}

