/*
 * Decompiled with CFR 0.152.
 */
package mathematics.primitives.pointsTiTi;

import displays.Color;
import imageTiTi.ImageDrawer;
import java.awt.image.BufferedImage;
import mathematics.primitives.pointsTiTi.PointI;

public class Point3DI
implements PointI {
    private int x;
    private int y;
    private int z;
    protected int HauteurCadre;
    protected int Type;
    protected int ListeGL = -1;
    protected float Transparence;
    protected float Taille;
    protected boolean Visible = true;
    protected boolean affichable = true;
    protected Color couleur = null;
    protected String Nom = null;

    public Point3DI() {
    }

    public Point3DI(PointI p) {
        if (p.Dimension() != 3) {
            throw new Error("Le point passe en argument est de dimension differente.");
        }
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    public Point3DI(int x, int y) {
        this.x = x;
        this.y = y;
        this.z = 0;
    }

    public Point3DI(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void Draw(BufferedImage image, float[] color, int order) {
        ImageDrawer imdraw = new ImageDrawer();
        ImageDrawer.Point(image, this.x, this.y, order, color);
        imdraw = null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int[] get() {
        return new int[]{this.x, this.y, this.z};
    }

    public int get(int i2) {
        switch (i2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new Error("Coordonnee incorrecte. Point de dimension 3, (0, 1, 2) attendu.");
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setXYZ(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(int[] composantes) {
        if (composantes.length != 3) {
            throw new Error("Dimension du tableau incorrecte, 3 attendue.");
        }
        this.x = composantes[0];
        this.y = composantes[1];
        this.z = composantes[2];
    }

    public void set(int x, int composantes) {
        switch (x) {
            case 0: {
                this.x = composantes;
                break;
            }
            case 1: {
                this.y = composantes;
                break;
            }
            case 2: {
                this.z = composantes;
                break;
            }
            default: {
                throw new Error("Numero de coordonnee incorrecte.");
            }
        }
    }

    public int Dimension() {
        return 3;
    }

    public int Size() {
        return 3;
    }

    public void Add(int x) {
        this.x += x;
        this.y += x;
        this.z += x;
    }

    public void Add(int[] x) {
        if (x.length != 3) {
            throw new IllegalArgumentException("Length of X must be 3.");
        }
        this.x += x[0];
        this.y += x[1];
        this.z += x[2];
    }

    public void Times(int x) {
        this.x *= x;
        this.y *= x;
        this.z *= x;
    }

    public boolean Equal(PointI p) {
        if (p.Size() != 3) {
            return false;
        }
        if (p.getX() != this.x) {
            return false;
        }
        if (p.getY() != this.y) {
            return false;
        }
        return p.getZ() == this.z;
    }

    public PointI Clone() {
        return new Point3DI(this.x, this.y, this.z);
    }

    public int getListeGL() {
        return this.ListeGL;
    }

    public int getListeGLMouvement() {
        return this.ListeGL;
    }

    public void ForceReDisplay() {
        this.ListeGL = -1;
    }

    public Color getColor() {
        return this.couleur;
    }

    public boolean isDisplayable() {
        return this.affichable;
    }

    public void setDisplayable(boolean Affichable) {
        this.affichable = Affichable;
        if (Affichable) {
            this.ForceReDisplay();
        }
    }

    public String getName() {
        return this.Nom;
    }

    public float getDisplaySize() {
        return this.Taille;
    }

    public float getTransparence() {
        return this.Transparence;
    }

    public int getDisplayType() {
        return this.Type;
    }

    public boolean isListeCreee() {
        return this.ListeGL != -1;
    }

    public boolean isVisible() {
        return this.Visible;
    }

    public void setColor(Color couleur) {
        this.couleur = couleur;
    }

    public int getHeightFramework() {
        return this.HauteurCadre;
    }

    public void setHeightFramework(int HeightFramework) {
        this.HauteurCadre = HeightFramework;
    }

    public void setName(String Nom) {
        this.Nom = Nom;
    }

    public void setDisplaySize(float Taille) {
        this.Taille = Taille;
    }

    public void setTransparence(float Transparence) {
        this.Transparence = Transparence;
        this.couleur = new Color(this.couleur.getRedF(), this.couleur.getGreenF(), this.couleur.getBlueF(), Transparence);
    }

    public void setDisplayType(int Type2) {
        this.Type = Type2;
    }

    public void setVisible(boolean Visible) {
        this.Visible = Visible;
    }
}

