/*
 * Decompiled with CFR 0.152.
 */
package mathematics.primitives.pointsTiTi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;

public class CoordinatesManager {
    public static final int SUCCESS = -2;
    public static final int FAILURE = -1;
    private int TakenPoint = -1;
    private int CatchingArea = 0;
    private List<Coordinates> list = null;
    private String Nom = null;

    public CoordinatesManager(ArrayList<?> l) {
        this.list = new ArrayList<Coordinates>(1111);
    }

    public CoordinatesManager(LinkedList<?> l) {
        this.list = new LinkedList<Coordinates>();
    }

    public void Kill() {
        this.list.clear();
        this.list = null;
    }

    public int Find(Coordinates point) {
        return this.Find(point.X, point.Y, point.Z);
    }

    public int Find(int x, int y, int z) {
        Coordinates point2 = null;
        int xmin = x - this.CatchingArea;
        int xmax = x + this.CatchingArea;
        int ymin = y - this.CatchingArea;
        int ymax = y + this.CatchingArea;
        int zmin = z - this.CatchingArea;
        int zmax = z + this.CatchingArea;
        int pos = 0;
        for (Coordinates point2 : this.list) {
            if (point2.X >= xmin && point2.X <= xmax && point2.Y >= ymin && point2.Y <= ymax && point2.Z >= zmin && point2.Z <= zmax) {
                return pos;
            }
            ++pos;
            point2 = null;
        }
        Iterator<Coordinates> iter = null;
        return -1;
    }

    public int NewPoint(Coordinates point) {
        if (this.Find(point.X, point.Y, point.Y) != -1) {
            return -1;
        }
        return this.Add(point);
    }

    public int NewPoint(int x, int y, int z) {
        if (this.Find(x, y, z) != -1) {
            return -1;
        }
        return this.Add(x, y, z);
    }

    public int InsertPointAt(int index, Coordinates point) {
        if (index > this.list.size() || index < 0) {
            return -1;
        }
        this.list.add(index, new Coordinates(point));
        return -2;
    }

    public int InsertPointAt(int index, int x, int y, int z) {
        return this.InsertPointAt(index, x, y, z, -1);
    }

    public int InsertPointAt(int index, int x, int y, int z, int pos) {
        if (index > this.list.size() || index < 0) {
            return -1;
        }
        this.list.add(index, new Coordinates(x, y, z, pos));
        return -2;
    }

    public int Add(int x, int y, int z) {
        return this.list.add(new Coordinates(x, y, z, -1)) ? -2 : -1;
    }

    public int Add(int x, int y, int z, int pos) {
        return this.list.add(new Coordinates(x, y, z, pos)) ? -2 : -1;
    }

    public int Add(Coordinates point) {
        return this.list.add(new Coordinates(point)) ? -2 : -1;
    }

    public int setPoint(int index, int x, int y, int z) {
        if (index > this.list.size() || index < 0) {
            return -1;
        }
        Coordinates p = this.list.get(index);
        p.X = x;
        p.Y = y;
        p.Z = z;
        return -2;
    }

    public int setPoint(int index, int x, int y, int z, int pos) {
        if (index > this.list.size() || index < 0) {
            return -1;
        }
        Coordinates p = this.list.get(index);
        p.X = x;
        p.Y = y;
        p.Z = z;
        p.Pos = pos;
        return -2;
    }

    public int Remove(int index) {
        if (index >= this.list.size() || index < 0) {
            return -1;
        }
        return this.list.remove(index) != null ? -2 : -1;
    }

    public void RemoveAll() {
        this.list.clear();
    }

    public void Display(String separator) {
        System.out.print("list des points : ");
        for (Coordinates c : this.list) {
            System.out.print("(" + c.X + "," + c.Y + "," + c.Z + ")" + separator);
            Object var3_3 = null;
        }
        System.out.println();
    }

    public Iterator<Coordinates> Iterator() {
        return this.list.iterator();
    }

    public int NbPoints() {
        return this.list.size();
    }

    public int Size() {
        return this.list.size();
    }

    public int CatchingArea() {
        return this.CatchingArea;
    }

    public void CatchingArea(int CatchingArea) {
        if (CatchingArea < 0) {
            throw new IllegalArgumentException("CatchingArea < 0");
        }
        this.CatchingArea = CatchingArea;
    }

    public Coordinates Point(int index) {
        return this.list.get(index);
    }

    public int TakenPoint() {
        return this.TakenPoint;
    }

    public void TakenPoint(int TakenPoint) {
        this.TakenPoint = TakenPoint;
    }

    public List<Coordinates> Points() {
        return this.list;
    }

    public String getName() {
        return this.Nom;
    }

    public String toString() {
        return this.Nom;
    }
}

