/*
 * Decompiled with CFR 0.152.
 */
package mathematics.primitives;

import mathematics.Geometry3D;
import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorDouble;
import mathematics.matriciel.VectorTools;
import mathematics.primitives.Box3D;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;

public class Plan {
    private int nbPoints;
    private double CoefA;
    private double CoefB;
    private double CoefC;
    private double CoefD;
    private double Surface;
    private double Epsilon;
    private Point[] Polygone = new Point3DF[12];
    public Point Point = new Point3DF();
    public Vector V1 = null;
    public Vector V2 = null;
    public Vector N = null;

    public Plan() {
        this.V1 = new VectorDouble(new double[]{0.0, 0.0, 0.0});
        this.V2 = new VectorDouble(new double[]{0.0, 0.0, 0.0});
        this.N = new VectorDouble(new double[]{0.0, 0.0, 0.0});
        this.CoefD = 0.0;
        this.CoefC = 0.0;
        this.CoefB = 0.0;
        this.CoefA = 0.0;
        this.nbPoints = 0;
        this.Epsilon = 1.0E-4;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.Polygone[i2] = new Point3DF();
        }
    }

    public Plan(Plan p) {
        this.V1 = p.V1.Clone();
        this.V2 = p.V2.Clone();
        this.N = p.N.Clone();
        this.CoefA = p.CoefA;
        this.CoefB = p.CoefB;
        this.CoefC = p.CoefC;
        this.CoefD = p.CoefD;
        this.nbPoints = p.nbPoints;
        this.Epsilon = p.Epsilon;
        this.Surface = p.Surface;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.Polygone[i2] = new Point3DF(p.Polygone[i2]);
        }
    }

    public void ComputeEquation() {
        if (Math.abs(this.N.get(0)) + Math.abs(this.N.get(1)) + Math.abs(this.N.get(2)) < this.Epsilon) {
            this.N = VectorTools.CrossProduct(this.V1, this.V2);
        }
        this.CoefA = this.N.get(0);
        this.CoefB = this.N.get(1);
        this.CoefC = this.N.get(2);
        this.CoefD = -(this.N.get(0) * this.Point.get(0) + this.N.get(1) * this.Point.get(1) + this.N.get(2) * this.Point.get(2));
    }

    public void ComputeNormalVector() {
        this.N.set(0, this.CoefA);
        this.N.set(1, this.CoefB);
        this.N.set(2, this.CoefC);
    }

    private boolean CheckPoint(int marge, Point point, Box3D Boite) {
        double margep = (double)marge + 0.01;
        if (!(Boite.getMin().get(0) - margep < point.get(0)) || !(point.get(0) < Boite.getMax().get(0) + margep)) {
            return false;
        }
        if (!(Boite.getMin().get(1) - margep < point.get(1)) || !(point.get(1) < Boite.getMax().get(1) + margep)) {
            return false;
        }
        return Boite.getMin().get(2) - margep < point.get(2) && point.get(2) < Boite.getMax().get(2) + margep;
    }

    public void FindParallelogram(Box3D boite) {
        Plan plan = new Plan();
        Point3DF p = new Point3DF();
        Point3DF res = new Point3DF();
        VectorDouble v = new VectorDouble(3);
        plan.setCoefs(this.CoefA, this.CoefB, this.CoefC, this.CoefD);
        plan.N.set(this.N.get());
        plan.V1.set(this.V1.get());
        plan.V2.set(this.V2.get());
        plan.Point.setXYZ(this.Point.get(0), this.Point.get(1), this.Point.get(2));
        double epsilon = Math.pow(10.0, -3.0);
        int max = (int)Math.max(boite.getMax().get(0) - boite.getMin().get(0), Math.max(boite.getMax().get(1) - boite.getMin().get(1), boite.getMax().get(2) - boite.getMin().get(2)));
        int marge = max / 10;
        int minx = (int)(boite.getMin().get(0) + 0.5) - marge;
        int miny = (int)(boite.getMin().get(1) + 0.5) - marge;
        int minz = (int)(boite.getMin().get(2) + 0.5) - marge;
        int maxx = (int)(boite.getMax().get(0) + 0.5) + marge;
        int maxy = (int)(boite.getMax().get(1) + 0.5) + marge;
        int maxz = (int)(boite.getMax().get(2) + 0.5) + marge;
        v.set(0, 0.0);
        v.set(1, 1.0);
        v.set(2, 0.0);
        p.setXYZ(minx, miny, minz);
        double calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        double calcul2 = this.CoefA * p.get(0) + this.CoefB * (double)maxy + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), (double)maxy, p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 1.0);
        v.set(1, 0.0);
        v.set(2, 0.0);
        p.setXYZ(minx, maxy, minz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * (double)maxx + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ((double)maxx, p.get(1), p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 0.0);
        v.set(1, 1.0);
        v.set(2, 0.0);
        p.setXYZ(maxx, miny, minz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * p.get(0) + this.CoefB * (double)maxy + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), (double)maxy, p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 1.0);
        v.set(1, 0.0);
        v.set(2, 0.0);
        p.setXYZ(minx, miny, minz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * (double)maxx + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ((double)maxx, p.get(1), p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 0.0);
        v.set(1, 0.0);
        v.set(2, 1.0);
        p.setXYZ(minx, maxy, minz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * (double)maxz + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), (double)maxz);
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 0.0);
        v.set(1, 0.0);
        v.set(2, 1.0);
        p.setXYZ(maxx, maxy, minz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * (double)maxz + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), (double)maxz);
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 0.0);
        v.set(1, 0.0);
        v.set(2, 1.0);
        p.setXYZ(maxx, miny, minz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * (double)maxz + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), (double)maxz);
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 0.0);
        v.set(1, 0.0);
        v.set(2, 1.0);
        p.setXYZ(minx, miny, minz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * (double)maxz + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), (double)maxz);
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 0.0);
        v.set(1, 1.0);
        v.set(2, 0.0);
        p.setXYZ(minx, miny, maxz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * p.get(0) + this.CoefB * (double)maxy + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), (double)maxy, p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 1.0);
        v.set(1, 0.0);
        v.set(2, 0.0);
        p.setXYZ(minx, maxy, maxz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * (double)maxx + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ((double)maxx, p.get(1), p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 0.0);
        v.set(1, 1.0);
        v.set(2, 0.0);
        p.setXYZ(maxx, miny, maxz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * p.get(0) + this.CoefB * (double)maxy + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), (double)maxy, p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        v.set(0, 1.0);
        v.set(1, 0.0);
        v.set(2, 0.0);
        p.setXYZ(minx, miny, maxz);
        calcul1 = this.CoefA * p.get(0) + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        calcul2 = this.CoefA * (double)maxx + this.CoefB * p.get(1) + this.CoefC * p.get(2) + this.CoefD;
        if (Math.abs(calcul1) + Math.abs(calcul2) < epsilon) {
            this.Polygone[this.nbPoints++].setXYZ(p.get(0), p.get(1), p.get(2));
            this.Polygone[this.nbPoints++].setXYZ((double)maxx, p.get(1), p.get(2));
        } else {
            res = Geometry3D.IntersectionDroitePlan(plan, p, v);
            if (res.get(0) > -1000000.0 && res.get(1) > -1000000.0 && res.get(2) > -1000000.0 && this.CheckPoint(marge, res, boite)) {
                this.Polygone[this.nbPoints++].setXYZ(res.get(0), res.get(1), res.get(2));
            }
        }
        for (int i2 = 0; i2 < this.nbPoints - 1; ++i2) {
            for (int j = i2 + 1; j < this.nbPoints; ++j) {
                if (!(Math.abs(this.Polygone[i2].get(0) - this.Polygone[j].get(0)) < 40.0 * epsilon) || !(Math.abs(this.Polygone[i2].get(1) - this.Polygone[j].get(1)) < 40.0 * epsilon) || !(Math.abs(this.Polygone[i2].get(2) - this.Polygone[j].get(2)) < 40.0 * epsilon)) continue;
                for (int k = j + 1; k < this.nbPoints; ++k) {
                    this.Polygone[k - 1] = this.Polygone[k];
                }
                --this.nbPoints;
                --j;
            }
        }
    }

    public double getCoefA() {
        return this.CoefA;
    }

    public double getCoefB() {
        return this.CoefB;
    }

    public double getCoefC() {
        return this.CoefC;
    }

    public double getCoefD() {
        return this.CoefD;
    }

    public void setCoefs(double CoefA, double CoefB, double CoefC, double CoefD) {
        this.CoefA = CoefA;
        this.CoefB = CoefB;
        this.CoefC = CoefC;
        this.CoefD = CoefD;
    }

    public double getSurface() {
        return this.Surface;
    }

    public Plan Clone() {
        return new Plan(this);
    }
}

