/*
 * Decompiled with CFR 0.152.
 */
package mathematics.primitives;

import arrayTiTi.ArrayArithmetic;
import dv.DV;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.List;
import mathematics.Bresenham;
import mathematics.Bresenham3D;
import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorDouble;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import mathematics.primitives.pointsTiTi.PointI;
import mathematics.primitives.pointsTiTi.PointND;

public class LineSegment {
    private final double Epsilon = 0.001;
    public Point point = null;
    public Vector vector = null;
    private Point Start = null;
    private Point End = null;
    public final int Dimension;
    private double Length = -1.0;

    public LineSegment(Point point, Vector vector, int dimension) {
        if (point.Dimension() != vector.Dimension()) {
            throw new IllegalArgumentException("Point and vector have different dimensions.");
        }
        this.point = point.Clone();
        this.vector = vector.Clone();
        this.Dimension = dimension;
    }

    public LineSegment(Coordinate point, Vector vector, int dimension) {
        this.point = vector.Dimension() == 2 ? new PointND(point.X, point.Y) : new PointND(point.X, point.Y, point.Z);
        this.vector = vector.Clone();
        this.Dimension = dimension;
    }

    public LineSegment(PointI Start, PointI End, int dimension) {
        if (Start.Dimension() != End.Dimension()) {
            throw new IllegalArgumentException("Start and End points have different dimensions.");
        }
        this.Start = new PointND(Start);
        this.End = new PointND(End);
        this.Dimension = dimension;
        this.ComputeLength();
        this.ComputePointAndVectorFromSegment();
    }

    public LineSegment(Point Start, Point End, int dimension) {
        if (Start.Dimension() != End.Dimension()) {
            throw new IllegalArgumentException("Start and End points have different dimensions.");
        }
        this.Start = new PointND(Start);
        this.End = new PointND(End);
        this.Dimension = dimension;
        this.ComputeLength();
        this.ComputePointAndVectorFromSegment();
    }

    public LineSegment(Coordinates Start, Coordinates End, int dimension) {
        this.Start = new Point3DF(Start.X, Start.Y, Start.Z);
        this.End = new Point3DF(End.X, End.Y, End.Z);
        this.ComputeLength();
        this.ComputePointAndVectorFromSegment();
        this.Dimension = dimension;
    }

    public LineSegment(Coordinate Start, Coordinate End, int dimension) {
        this.Start = new Point3DF(Start.X, Start.Y, Start.Z);
        this.End = new Point3DF(End.X, End.Y, End.Z);
        this.ComputeLength();
        this.ComputePointAndVectorFromSegment();
        this.Dimension = dimension;
    }

    private void ComputeLength() {
        Euclidian euclidian = new Euclidian();
        this.Length = euclidian.Distance(this.Start, this.End);
        euclidian = null;
    }

    private void ComputePointAndVectorFromSegment() {
        int i2;
        int dim = this.Start.Dimension();
        this.point = new PointND(dim);
        double[] p = this.point.get();
        double[] s = this.Start.get();
        double[] e = this.End.get();
        for (i2 = 0; i2 < dim; ++i2) {
            p[i2] = (s[i2] + e[i2]) / 2.0;
        }
        this.vector = new VectorDouble(dim);
        double[] v = this.vector.get();
        for (i2 = 0; i2 < dim; ++i2) {
            v[i2] = e[i2] - p[i2];
        }
        this.vector.Standardize();
        v = null;
        e = null;
        s = null;
        p = null;
    }

    public LineSegment FindExtremities(BufferedImage image, boolean setIntoStartAndEnd) {
        if (this.Dimension != 2) {
            throw new IllegalArgumentException("This line/segment is dimension " + this.Dimension + ", not 2.");
        }
        double[] vec = this.vector.get();
        if (Math.abs(vec[0]) < 0.001 && Math.abs(vec[1]) < 0.001) {
            throw new IllegalArgumentException("Vector comparable to (0, 0).");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        Coordinates p1 = new Coordinates(0, 0, 0);
        Coordinates p2 = new Coordinates(0, 0, 0);
        if (Math.abs(vec[0]) < 0.001) {
            p1.X = p2.X = (int)(this.point.getX() + 0.5);
            p1.Y = 0;
            p2.Y = height - 1;
        } else if (Math.abs(vec[1]) < 0.001) {
            p1.X = 0;
            p2.X = width - 1;
            p1.Y = p2.Y = (int)(this.point.getY() + 0.5);
        } else {
            double a = vec[1] / vec[0];
            double b = this.point.getY() - a * this.point.getX();
            int xbottom = (int)(-b / a < 0.0 ? -b / a - 0.5 : -b / a + 0.5);
            int xtop = (int)(((double)(height - 1) - b) / a < 0.0 ? ((double)(height - 1) - b) / a - 0.5 : ((double)(height - 1) - b) / a + 0.5);
            int yleft = (int)(b < 0.0 ? b - 0.5 : b + 0.5);
            int yright = (int)(a * (double)(width - 1) + b < 0.0 ? a * (double)(width - 1) + b - 0.5 : a * (double)(width - 1) + b + 0.5);
            boolean p1ok = false;
            boolean p2ok = false;
            if (0 <= xbottom && xbottom < width) {
                p1.X = xbottom;
                p1.Y = 0;
                p1ok = true;
            }
            if (0 <= xtop && xtop < width) {
                if (!p1ok) {
                    p1.X = xtop;
                    p1.Y = height - 1;
                    p1ok = true;
                } else {
                    p2.X = xtop;
                    p2.Y = height - 1;
                    p2ok = true;
                }
            }
            if (!p2ok && 0 <= yleft && yleft < height) {
                if (!p1ok) {
                    p1.X = 0;
                    p1.Y = yleft;
                    p1ok = true;
                } else {
                    p2.X = 0;
                    p2.Y = yleft;
                    p2ok = true;
                }
            }
            if (!p2ok && 0 <= yright && yright < height) {
                if (!p1ok) {
                    throw new IllegalArgumentException("No intersection found between the line/segment and the image borders.");
                }
                p2.X = width - 1;
                p2.Y = yright;
                p2ok = true;
            }
            if (!p2ok) {
                throw new IllegalArgumentException("No intersection found between the line/segment and the image borders.");
            }
        }
        List list = Bresenham.Coordinates((int)p1.X, (int)p1.Y, (int)p2.X, (int)p2.Y);
        vec = null;
        p2 = null;
        p1 = null;
        int istart = 0;
        int iend = list.size() - 1;
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                boolean found = false;
                while (!found && istart < list.size()) {
                    Coordinates c = (Coordinates)list.get(istart);
                    if (0 == wr.getSample(c.X, c.Y, 0)) {
                        ++istart;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                found = false;
                while (!found && 0 <= iend) {
                    Coordinates c = (Coordinates)list.get(iend);
                    if (0 == wr.getSample(c.X, c.Y, 0)) {
                        --iend;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                boolean found = false;
                while (!found && istart < list.size()) {
                    Coordinates c = (Coordinates)list.get(istart);
                    if (0 == bb[c.X + c.Y * width]) {
                        ++istart;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                found = false;
                while (!found && 0 <= iend) {
                    Coordinates c = (Coordinates)list.get(iend);
                    if (0 == bb[c.X + c.Y * width]) {
                        --iend;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                boolean found = false;
                while (!found && istart < list.size()) {
                    Coordinates c = (Coordinates)list.get(istart);
                    if (0 == sb[c.X + c.Y * width]) {
                        ++istart;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                found = false;
                while (!found && 0 <= iend) {
                    Coordinates c = (Coordinates)list.get(iend);
                    if (0 == sb[c.X + c.Y * width]) {
                        --iend;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        if (iend < 0 || list.size() == istart) {
            throw new IllegalArgumentException("No intersection found between the line/segment and the pattern.");
        }
        LineSegment result = new LineSegment((Coordinates)list.get(istart), (Coordinates)list.get(iend), 2);
        if (setIntoStartAndEnd) {
            if (this.Start == null) {
                this.Start = new PointND(((Coordinates)list.get((int)istart)).X, ((Coordinates)list.get((int)istart)).Y);
            } else {
                this.Start.setXY((double)((Coordinates)list.get((int)istart)).X, (double)((Coordinates)list.get((int)istart)).Y);
            }
            if (this.End == null) {
                this.End = new PointND(((Coordinates)list.get((int)iend)).X, ((Coordinates)list.get((int)iend)).Y);
            } else {
                this.End.setXY((double)((Coordinates)list.get((int)iend)).X, (double)((Coordinates)list.get((int)iend)).Y);
            }
        }
        this.ComputeLength();
        list.clear();
        list = null;
        return result;
    }

    public LineSegment FindExtremities(DV dv, boolean setIntoStartAndEnd) {
        this.vector.Standardize();
        double[] pos = (double[])this.point.get().clone();
        double[] vec2 = (double[])this.vector.get().clone();
        ArrayArithmetic.Divide((double[])vec2, (double)2.0, (double[])vec2);
        int w1 = dv.SizeX - 1;
        int h1 = dv.SizeY - 1;
        int d1 = dv.SizeZ - 1;
        Coordinates p1 = null;
        Coordinates p2 = null;
        do {
            ArrayArithmetic.Add((double[])pos, (double[])vec2, (double[])pos);
            if ((int)(pos[0] + 0.5) == 0 || (int)(pos[1] + 0.5) == 0 || (int)(pos[2] + 0.5) == 0 || (int)(pos[0] + 0.5) == w1 || (int)(pos[1] + 0.5) == h1 || (int)(pos[2] + 0.5) == d1) {
                p1 = new Coordinates((int)(pos[0] + 0.5), (int)(pos[1] + 0.5), (int)(pos[2] + 0.5));
            }
            if (!(pos[0] < 0.0 || pos[1] < 0.0 || pos[2] < 0.0 || (double)w1 < pos[0] || (double)h1 < pos[1]) && !((double)d1 < pos[2])) continue;
            throw new Error("Must not occur.");
        } while (p1 == null);
        System.arraycopy(this.point.get(), 0, pos, 0, pos.length);
        ArrayArithmetic.Multiply((double[])vec2, (double)-1.0, (double[])vec2);
        do {
            ArrayArithmetic.Add((double[])pos, (double[])vec2, (double[])pos);
            if ((int)(pos[0] + 0.5) == 0 || (int)(pos[1] + 0.5) == 0 || (int)(pos[2] + 0.5) == 0 || (int)(pos[0] + 0.5) == w1 || (int)(pos[1] + 0.5) == h1 || (int)(pos[2] + 0.5) == d1) {
                p2 = new Coordinates((int)(pos[0] + 0.5), (int)(pos[1] + 0.5), (int)(pos[2] + 0.5));
            }
            if (!(pos[0] < 0.0 || pos[1] < 0.0 || pos[2] < 0.0 || (double)w1 < pos[0] || (double)h1 < pos[1]) && !((double)d1 < pos[2])) continue;
            throw new Error("Must not occur.");
        } while (p2 == null);
        vec2 = null;
        pos = null;
        List<Coordinates> list = Bresenham3D.Coordinates(p1.X, p1.Y, p1.Z, p2.X, p2.Y, p2.Z);
        p2 = null;
        p1 = null;
        int istart = 0;
        int iend = list.size() - 1;
        switch (dv.Type) {
            case 8: {
                Coordinates c;
                byte[] bb = dv.getDataBufferByte(0);
                boolean found = false;
                while (!found && istart < list.size()) {
                    c = list.get(istart);
                    if (0 == bb[dv.Position(c.X, c.Y, c.Z)]) {
                        ++istart;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                found = false;
                while (!found && 0 <= iend) {
                    c = list.get(iend);
                    if (0 == bb[dv.Position(c.X, c.Y, c.Z)]) {
                        --iend;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                bb = null;
                break;
            }
            case 16: {
                Coordinates c;
                short[] sb = dv.getDataBufferShort(0);
                boolean found = false;
                while (!found && istart < list.size()) {
                    c = list.get(istart);
                    if (0 == sb[dv.Position(c.X, c.Y, c.Z)]) {
                        ++istart;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                found = false;
                while (!found && 0 <= iend) {
                    c = list.get(iend);
                    if (0 == sb[dv.Position(c.X, c.Y, c.Z)]) {
                        --iend;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                sb = null;
                break;
            }
            case 32: {
                Coordinates c;
                int[] ib = dv.getDataBufferInt(0);
                boolean found = false;
                while (!found && istart < list.size()) {
                    c = list.get(istart);
                    if (0 == ib[dv.Position(c.X, c.Y, c.Z)]) {
                        ++istart;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                found = false;
                while (!found && 0 <= iend) {
                    c = list.get(iend);
                    if (0 == ib[dv.Position(c.X, c.Y, c.Z)]) {
                        --iend;
                    } else {
                        found = true;
                    }
                    c = null;
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        if (iend < 0 || list.size() == istart) {
            throw new IllegalArgumentException("No intersection found between the line/segment and the pattern.");
        }
        LineSegment result = new LineSegment(list.get(istart), list.get(iend), 3);
        if (setIntoStartAndEnd) {
            if (this.Start == null) {
                this.Start = new PointND(list.get((int)istart).X, list.get((int)istart).Y);
            } else {
                this.Start.setXYZ((double)list.get((int)istart).X, (double)list.get((int)istart).Y, (double)list.get((int)istart).Z);
            }
            if (this.End == null) {
                this.End = new PointND(list.get((int)iend).X, list.get((int)iend).Y);
            } else {
                this.End.setXYZ((double)list.get((int)iend).X, (double)list.get((int)iend).Y, (double)list.get((int)iend).Z);
            }
            this.ComputeLength();
        }
        list.clear();
        list = null;
        return result;
    }

    public Point getStart() {
        return this.Start;
    }

    public Point getEnd() {
        return this.End;
    }

    public double Length() {
        return this.Length;
    }

    public double A() {
        if (this.Dimension != 2) {
            throw new IllegalStateException("This is not a 2D line/segment.");
        }
        return this.vector.get(1) / this.vector.get(0);
    }

    public double B() {
        if (this.Dimension != 2) {
            throw new IllegalStateException("This is not a 2D line/segment.");
        }
        return this.point.getY() - this.A() * this.point.getX();
    }
}

