/*
 * Decompiled with CFR 0.152.
 */
package mathematics.metrics;

import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorI;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointI;

public class Minkowski
implements Metric {
    private double p = 1.0;

    public Minkowski() {
    }

    public Minkowski(double p) {
        this.p = p;
    }

    public void set(double p) {
        this.p = p;
    }

    public double get() {
        return this.p;
    }

    public double Distance(double[] firstVector, double[] secondVector) {
        if (firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightLenght = firstVector.length;
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            sum += Math.pow(Math.abs(secondVector[i2] - firstVector[i2]), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(float[] firstVector, float[] secondVector) {
        if (firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightLenght = firstVector.length;
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            sum += Math.pow(Math.abs(secondVector[i2] - firstVector[i2]), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(int[] firstVector, int[] secondVector) {
        if (firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightLenght = firstVector.length;
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            sum += Math.pow(Math.abs((double)secondVector[i2] - (double)firstVector[i2]), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(short[] firstVector, short[] secondVector) {
        if (firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightLenght = firstVector.length;
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            sum += Math.pow(Math.abs((double)secondVector[i2] - (double)firstVector[i2]), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(Vector u, Vector v) {
        if (u.Dimension() != v.Dimension()) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightSize = u.Dimension();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Math.pow(u.get(i2) - v.get(i2), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(VectorI u, VectorI v) {
        if (u.Dimension() != v.Dimension()) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightSize = u.Dimension();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Math.pow(u.get(i2) - v.get(i2), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(Vector u, VectorI v) {
        if (u.Dimension() != v.Dimension()) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightSize = u.Dimension();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Math.pow(u.get(i2) - (double)v.get(i2), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(Point u, Point v) {
        if (u.Size() != v.Size()) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightSize = u.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Math.pow(u.get(i2) - v.get(i2), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(PointI u, PointI v) {
        if (u.Size() != v.Size()) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightSize = u.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Math.pow(u.get(i2) - v.get(i2), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(Point u, PointI v) {
        if (u.Size() != v.Size()) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double sum = 0.0;
        int weightSize = u.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Math.pow(u.get(i2) - (double)v.get(i2), this.p);
        }
        return Math.pow(sum, 1.0 / this.p);
    }

    public double Distance(double Ux, double Uy, double Uz, double Vx, double Vy, double Vz) {
        return Math.pow(Math.pow(Ux - Vx, this.p) + Math.pow(Uy - Vy, this.p) + Math.pow(Uz - Vz, this.p), 1.0 / this.p);
    }

    public double Distance(Coordinates u, Coordinates v) {
        return Math.pow(Math.pow(u.X - v.X, this.p) + Math.pow(u.Y - v.Y, this.p) + Math.pow(u.Z - v.Z, this.p), 1.0 / this.p);
    }

    public double Distance(Point u, Coordinates v) {
        return Math.pow(Math.pow(u.getX() - (double)v.X, this.p) + Math.pow(u.getY() - (double)v.Y, this.p) + Math.pow(u.getZ() - (double)v.Z, this.p), 1.0 / this.p);
    }

    public double Distance(PointI u, Coordinates v) {
        return Math.pow(Math.pow(u.getX() - v.X, this.p) + Math.pow(u.getY() - v.Y, this.p) + Math.pow(u.getZ() - v.Z, this.p), 1.0 / this.p);
    }

    public double Distance(Coordinate u, Coordinate v) {
        return Math.pow(Math.pow(u.X - v.X, this.p) + Math.pow(u.Y - v.Y, this.p) + Math.pow(u.Z - v.Z, this.p), 1.0 / this.p);
    }

    public double Distance(Coordinates u, Coordinate v) {
        return Math.pow(Math.pow((double)u.X - v.X, this.p) + Math.pow((double)u.Y - v.Y, this.p) + Math.pow((double)u.Z - v.Z, this.p), 1.0 / this.p);
    }

    public double Distance(Point u, Coordinate v) {
        return Math.pow(Math.pow(u.getX() - v.X, this.p) + Math.pow(u.getY() - v.Y, this.p), 1.0 / this.p);
    }

    public double Distance(PointI u, Coordinate v) {
        return Math.pow(Math.pow((double)u.getX() - v.X, this.p) + Math.pow((double)u.getY() - v.Y, this.p), 1.0 / this.p);
    }
}

