/*
 * Decompiled with CFR 0.152.
 */
package mathematics.metrics;

import Jama.Matrix;
import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorI;
import mathematics.metrics.MetricGroup;

public class Mahalanobis
implements MetricGroup {
    @Override
    public double Distance(Matrix CovInv, Vector v) {
        return this.Distance(CovInv, v.get());
    }

    @Override
    public double Distance(Matrix CovInv, VectorI v) {
        return this.Distance(CovInv, v.get());
    }

    @Override
    public double Distance(Matrix CovInv, double[] v) {
        if (CovInv.getColumnDimension() != v.length || CovInv.getRowDimension() != v.length) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double distance = 0.0;
        Matrix m = new Matrix(v.length, 1);
        Matrix mT = new Matrix(1, v.length);
        for (int i2 = 0; i2 < v.length; ++i2) {
            m.set(i2, 0, v[i2]);
            mT.set(0, i2, v[i2]);
        }
        Matrix T = mT.times(CovInv).times(m);
        distance = Math.sqrt(T.get(0, 0));
        T = null;
        m = null;
        mT = null;
        return distance;
    }

    @Override
    public double Distance(Matrix CovInv, int[] v) {
        if (CovInv.getColumnDimension() != v.length || CovInv.getRowDimension() != v.length) {
            throw new IllegalArgumentException("Gap between lengths of vectors.");
        }
        double distance = 0.0;
        Matrix m = new Matrix(v.length, 1);
        Matrix mT = new Matrix(1, v.length);
        for (int i2 = 0; i2 < v.length; ++i2) {
            m.set(i2, 0, (double)v[i2]);
            mT.set(0, i2, (double)v[i2]);
        }
        Matrix T = mT.times(CovInv).times(m);
        distance = Math.sqrt(T.get(0, 0));
        T = null;
        m = null;
        mT = null;
        return distance;
    }
}

