/*
 * Decompiled with CFR 0.152.
 */
package mathematics.metrics;

import mathematics.Maths;
import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorI;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointI;

public class Hellinger
implements Metric {
    public double Distance(double[] v1, double[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Arrays have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(v2[i2]) - Math.sqrt(v1[i2])), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Arrays have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(v2[i2]) - Math.sqrt(v1[i2])), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(int[] v1, int[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Arrays have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(v2[i2]) - Math.sqrt(v1[i2])), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(short[] v1, short[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Arrays have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(v2[i2]) - Math.sqrt(v1[i2])), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(Vector v1, Vector v2) {
        if (v1.Dimension() != v2.Dimension()) {
            throw new IllegalArgumentException("Vectors have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = v1.Dimension();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(v1.get(i2)) - Math.sqrt(v2.get(i2))), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(VectorI v1, VectorI v2) {
        if (v1.Dimension() != v2.Dimension()) {
            throw new IllegalArgumentException("Vectors have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = v1.Dimension();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(v1.get(i2)) - Math.sqrt(v2.get(i2))), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(Vector v1, VectorI v2) {
        if (v1.Dimension() != v2.Dimension()) {
            throw new IllegalArgumentException("Vectors have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = v1.Dimension();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(v1.get(i2)) - Math.sqrt(v2.get(i2))), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(Point p1, Point p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Points have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(p1.get(i2)) - Math.sqrt(p2.get(i2))), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(PointI p1, PointI p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Points have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(p1.get(i2)) - Math.sqrt(p2.get(i2))), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(Point p1, PointI p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Points have difference dimensions.");
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(Math.sqrt(p1.get(i2)) - Math.sqrt(p2.get(i2))), (int)2);
        }
        return Math.sqrt(sum);
    }

    public double Distance(double Ux, double Uy, double Uz, double Vx, double Vy, double Vz) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(Ux) - Math.sqrt(Vx)), (int)2) + Maths.Power((double)(Math.sqrt(Uy) - Math.sqrt(Vy)), (int)2) + Maths.Power((double)(Math.sqrt(Uz) - Math.sqrt(Vz)), (int)2));
    }

    public double Distance(Coordinates u, Coordinates v) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(u.X) - Math.sqrt(v.X)), (int)2) + Maths.Power((double)(Math.sqrt(u.Y) - Math.sqrt(v.Y)), (int)2));
    }

    public double Distance(Coordinates u, Coordinate v) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(u.X) - Math.sqrt(v.X)), (int)2) + Maths.Power((double)(Math.sqrt(u.Y) - Math.sqrt(v.Y)), (int)2));
    }

    public double Distance(Point u, Coordinates v) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(u.getX()) - Math.sqrt(v.X)), (int)2) + Maths.Power((double)(Math.sqrt(u.getY()) - Math.sqrt(v.Y)), (int)2));
    }

    public double Distance(PointI u, Coordinates v) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(u.getX()) - Math.sqrt(v.X)), (int)2) + Maths.Power((double)(Math.sqrt(u.getY()) - Math.sqrt(v.Y)), (int)2));
    }

    public double Distance(Coordinate u, Coordinate v) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(u.X) - Math.sqrt(v.X)), (int)2) + Maths.Power((double)(Math.sqrt(u.Y) - Math.sqrt(v.Y)), (int)2));
    }

    public double Distance(Point u, Coordinate v) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(u.getX()) - Math.sqrt(v.X)), (int)2) + Maths.Power((double)(Math.sqrt(u.getY()) - Math.sqrt(v.Y)), (int)2));
    }

    public double Distance(PointI u, Coordinate v) {
        return Math.sqrt(Maths.Power((double)(Math.sqrt(u.getX()) - Math.sqrt(v.X)), (int)2) + Maths.Power((double)(Math.sqrt(u.getY()) - Math.sqrt(v.Y)), (int)2));
    }
}

