/*
 * Decompiled with CFR 0.152.
 */
package mathematics.metrics;

import mathematics.Maths;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointI;

public class EuclidianSquared
implements Metric {
    public double Distance(double[] v1, double[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + v1.length + " " + v2.length);
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i2 = 0; i2 < weightSize; ++i2) {
            double diff = v2[i2] - v1[i2];
            sum += diff * diff;
        }
        return sum;
    }

    public double Distance(float[] v1, float[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + v1.length + " " + v2.length);
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i2 = 0; i2 < weightSize; ++i2) {
            double diff = v2[i2] - v1[i2];
            sum += diff * diff;
        }
        return sum;
    }

    public double Distance(int[] v1, int[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + v1.length + " " + v2.length);
        }
        double sum = 0.0;
        int weightSize = v1.length;
        for (int i2 = 0; i2 < weightSize; ++i2) {
            int v = v2[i2] - v1[i2];
            sum += (double)(v * v);
        }
        return sum;
    }

    public double Distance(Point p1, Point p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + p1.Size() + " " + p2.Size());
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(p1.get(i2) - p2.get(i2)), (int)2);
        }
        return sum;
    }

    public double Distance(PointI p1, PointI p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + p1.Size() + " " + p2.Size());
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += (double)Maths.Power((int)(p1.get(i2) - p2.get(i2)), (int)2);
        }
        return sum;
    }

    public double Distance(Point p1, PointI p2) {
        if (p1.Size() != p2.Size()) {
            throw new IllegalArgumentException("Gap between dimensions of vectors: " + p1.Size() + " " + p2.Size());
        }
        double sum = 0.0;
        int weightSize = p1.Size();
        for (int i2 = 0; i2 < weightSize; ++i2) {
            sum += Maths.Power((double)(p1.get(i2) - (double)p2.get(i2)), (int)2);
        }
        return sum;
    }

    public double Distance(double Ux, double Uy, double Uz, double Vx, double Vy, double Vz) {
        return (Ux - Vx) * (Ux - Vx) + (Uy - Vy) * (Uy - Vy) + (Uz - Vz) * (Uz - Vz);
    }

    public double Distance(Coordinates u, Coordinates v) {
        return Maths.Power((int)(u.X - v.X), (int)2) + Maths.Power((int)(u.Y - v.Y), (int)2) + Maths.Power((int)(u.Z - v.Z), (int)2);
    }

    public double Distance(Point u, Coordinates v) {
        return Maths.Power((double)(u.getX() - (double)v.X), (int)2) + Maths.Power((double)(u.getY() - (double)v.Y), (int)2);
    }

    public double Distance(PointI u, Coordinates v) {
        return Maths.Power((int)(u.getX() - v.X), (int)2) + Maths.Power((int)(u.getY() - v.Y), (int)2);
    }

    public double Distance(Coordinate u, Coordinate v) {
        return Maths.Power((double)(u.X - v.X), (int)2) + Maths.Power((double)(u.Y - v.Y), (int)2) + Maths.Power((double)(u.Z - v.Z), (int)2);
    }

    public double Distance(Coordinates u, Coordinate v) {
        return Maths.Power((double)((double)u.X - v.X), (int)2) + Maths.Power((double)((double)u.Y - v.Y), (int)2) + Maths.Power((double)((double)u.Z - v.Z), (int)2);
    }

    public double Distance(Point u, Coordinate v) {
        return Maths.Power((double)(u.getX() - v.X), (int)2) + Maths.Power((double)(u.getY() - v.Y), (int)2);
    }

    public double Distance(PointI u, Coordinate v) {
        return Maths.Power((double)((double)u.getX() - v.X), (int)2) + Maths.Power((double)((double)u.getY() - v.Y), (int)2);
    }
}

