/*
 * Decompiled with CFR 0.152.
 */
package mathematics.metrics;

import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorI;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointI;

public class CityBlock
implements Metric {
    public double Distance(double[] firstVector, double[] secondVector) {
        if (firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double distance = 0.0;
        int weightLenght = firstVector.length;
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += Math.abs(secondVector[i2] - firstVector[i2]);
        }
        return distance;
    }

    public double Distance(float[] firstVector, float[] secondVector) {
        if (firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double distance = 0.0;
        int weightLenght = firstVector.length;
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += (double)Math.abs(secondVector[i2] - firstVector[i2]);
        }
        return distance;
    }

    public double Distance(int[] firstVector, int[] secondVector) {
        if (firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double distance = 0.0;
        int weightLenght = firstVector.length;
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += Math.abs((double)secondVector[i2] - (double)firstVector[i2]);
        }
        return distance;
    }

    public double Distance(Vector u, Vector v) {
        if (u.Dimension() != v.Dimension()) {
            throw new IllegalArgumentException("Vectors have different dimensions.");
        }
        double distance = 0.0;
        int weightLenght = u.Dimension();
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += Math.abs(u.get(i2) - v.get(i2));
        }
        return distance;
    }

    public double Distance(VectorI u, VectorI v) {
        if (u.Dimension() != v.Dimension()) {
            throw new IllegalArgumentException("Vectors have different dimensions.");
        }
        double distance = 0.0;
        int weightLenght = u.Dimension();
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += (double)Math.abs(u.get(i2) - v.get(i2));
        }
        return distance;
    }

    public double Distance(Vector u, VectorI v) {
        if (u.Dimension() != v.Dimension()) {
            throw new IllegalArgumentException("Vectors have different dimensions.");
        }
        double distance = 0.0;
        int weightLenght = u.Dimension();
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += Math.abs(u.get(i2) - (double)v.get(i2));
        }
        return distance;
    }

    public double Distance(Point u, Point v) {
        if (u.Size() != v.Size()) {
            throw new IllegalArgumentException("Points have different dimensions.");
        }
        double distance = 0.0;
        int weightLenght = u.Size();
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += Math.abs(u.get(i2) - v.get(i2));
        }
        return distance;
    }

    public double Distance(PointI u, PointI v) {
        if (u.Size() != v.Size()) {
            throw new IllegalArgumentException("Points have different dimensions.");
        }
        double distance = 0.0;
        int weightLenght = u.Size();
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += (double)Math.abs(u.get(i2) - v.get(i2));
        }
        return distance;
    }

    public double Distance(Point u, PointI v) {
        if (u.Size() != v.Size()) {
            throw new IllegalArgumentException("Points have different dimensions.");
        }
        double distance = 0.0;
        int weightLenght = u.Size();
        for (int i2 = 0; i2 < weightLenght; ++i2) {
            distance += Math.abs(u.get(i2) - (double)v.get(i2));
        }
        return distance;
    }

    public double Distance(Coordinates u, Coordinates v) {
        return Math.abs(u.X - v.X) + Math.abs(u.Y - v.Y) + Math.abs(u.Z - v.Z);
    }

    public double Distance(Point u, Coordinates v) {
        return Math.abs(u.getX() - (double)v.X) + Math.abs(u.getY() - (double)v.Y);
    }

    public double Distance(PointI u, Coordinates v) {
        return Math.abs(u.getX() - v.X) + Math.abs(u.getY() - v.Y);
    }

    public double Distance(Coordinate u, Coordinate v) {
        return Math.abs(u.X - v.X) + Math.abs(u.Y - v.Y) + Math.abs(u.Z - v.Z);
    }

    public double Distance(Coordinates u, Coordinate v) {
        return Math.abs((double)u.X - v.X) + Math.abs((double)u.Y - v.Y) + Math.abs((double)u.Z - v.Z);
    }

    public double Distance(Point u, Coordinate v) {
        return Math.abs(u.getX() - v.X) + Math.abs(u.getY() - v.Y);
    }

    public double Distance(PointI u, Coordinate v) {
        return Math.abs((double)u.getX() - v.X) + Math.abs((double)u.getY() - v.Y);
    }

    public double Distance(double Ux, double Uy, double Uz, double Vx, double Vy, double Vz) {
        return Math.abs(Ux - Vx) + Math.abs(Uy - Vy) + Math.abs(Uz - Vz);
    }
}

