/*
 * Decompiled with CFR 0.152.
 */
package mathematics.metrics;

import Jama.Matrix;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import mathematics.metrics.MetricProfiles;

public class Chi2
implements MetricProfiles {
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public double Distance(Matrix matrix, int row1, int row2) {
        double[][] mat = matrix.getArray();
        double[] r1 = mat[row1];
        double[] r2 = mat[row2];
        double sum = 0.0;
        double integral = this.AF.Integral(mat);
        double introw1 = this.AF.Integral(mat[row1]);
        double introw2 = this.AF.Integral(mat[row2]);
        int height = mat.length;
        int width = mat[0].length;
        for (int i2 = 0; i2 < width; ++i2) {
            double sumcol = 0.0;
            for (int j = 0; j < height; ++j) {
                sumcol += mat[j][i2];
            }
            sum += Math.pow(r1[i2] / introw1 - r2[i2] / introw2, 2.0) / sumcol;
        }
        return Math.sqrt(integral * sum);
    }

    @Override
    public double Distance(FichierTabule file, int row1, int row2) {
        int i2;
        int width = file.Width();
        double sum = 0.0;
        double integral = 0.0;
        double introw1 = 0.0;
        double introw2 = 0.0;
        block8: for (i2 = 0; i2 < width; ++i2) {
            if (file.isExcludedColumn(i2)) continue;
            switch (file.ColumnType(i2)) {
                case 1: {
                    introw1 += file.getValueDouble(row1, i2);
                    introw2 += file.getValueDouble(row2, i2);
                    integral += this.AF.Integral(file.getColumnDouble(i2));
                    continue block8;
                }
                case 0: {
                    introw1 += (double)file.getValueInt(row1, i2);
                    introw2 += (double)file.getValueInt(row2, i2);
                    integral += (double)this.AF.Integral(file.getColumnInt(i2));
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Column type not supported (only INTEGER and DOUBLE.");
                }
            }
        }
        block9: for (i2 = 0; i2 < width; ++i2) {
            if (file.isExcludedColumn(i2)) continue;
            switch (file.ColumnType(i2)) {
                case 1: {
                    sum += Math.pow(file.getValueDouble(row1, i2) / introw1 - file.getValueDouble(row2, i2) / introw2, 2.0) / this.AF.Integral(file.getColumnDouble(i2));
                    continue block9;
                }
                case 0: {
                    sum += Math.pow((double)file.getValueInt(row1, i2) / introw1 - (double)file.getValueInt(row2, i2) / introw2, 2.0) / (double)this.AF.Integral(file.getColumnInt(i2));
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Column type not supported (only INTEGER and DOUBLE.");
                }
            }
        }
        return Math.sqrt(integral * sum);
    }
}

