/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel.homography;

import Jama.Matrix;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;

public class Homography {
    private Matrix Q = new Matrix(3, 3);
    private Matrix P = new Matrix(3, 3);
    private Matrix Q4 = new Matrix(3, 1);
    private Matrix P4 = new Matrix(3, 1);

    public void CollineationMatrix(Point[] object, Point[] image, Matrix T) {
        Matrix tmp1_3x3 = null;
        Matrix tmp2_3x3 = null;
        Matrix tmp1_3x3_T = null;
        Matrix tmp2_3x3_T = null;
        for (int i2 = 0; i2 < 3; ++i2) {
            this.Q.set(i2, 0, object[i2].getX());
            this.Q.set(i2, 1, object[i2].getY());
            this.Q.set(i2, 2, object[i2].getZ());
            this.P.set(i2, 0, image[i2].getX());
            this.P.set(i2, 1, image[i2].getY());
            this.P.set(i2, 2, image[i2].getZ());
        }
        this.Q4.set(0, 0, object[3].getX());
        this.Q4.set(1, 0, object[3].getY());
        this.Q4.set(2, 0, object[3].getZ());
        this.P4.set(0, 0, image[3].getX());
        this.P4.set(1, 0, image[3].getY());
        this.P4.set(2, 0, image[3].getZ());
        tmp1_3x3 = this.P.inverse();
        tmp2_3x3 = this.Q.inverse();
        tmp1_3x3_T = tmp1_3x3.transpose();
        tmp2_3x3_T = tmp2_3x3.transpose();
        Matrix W = Matrix.identity((int)3, (int)3);
        Matrix V = tmp1_3x3_T.times(this.P4);
        Matrix R = tmp2_3x3_T.times(this.Q4);
        double tmp = R.get(2, 0) / V.get(2, 0);
        W.set(0, 0, V.get(0, 0) / R.get(0, 0) * tmp);
        W.set(1, 1, V.get(1, 0) / R.get(1, 0) * tmp);
        tmp1_3x3 = tmp2_3x3.times(W);
        tmp2_3x3 = tmp1_3x3.times(this.P);
        Matrix Tinv = tmp2_3x3.transpose();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                T.set(x, y, Tinv.get(x, y));
            }
        }
    }

    public void NormalisedCoordinates(Point img, double width, double height) {
        img.setX(2.0 * img.getX() / width - 1.0);
        img.setY(2.0 * img.getY() / height - 1.0);
    }

    public void NormalisedCoordinates(Point[] img, double width, double height) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.NormalisedCoordinates(img[i2], width, height);
        }
    }

    public void NormalisedCoordinates(Matrix img, double width, double height) {
        for (int i2 = 0; i2 < 4; ++i2) {
            img.set(0, 0, 2.0 * img.get(0, 0) / width - 1.0);
            img.set(1, 0, 2.0 * img.get(1, 0) / height - 1.0);
        }
    }

    public void NormalisedCoordinates(Matrix[] img, double width, double height) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.NormalisedCoordinates(img[i2], width, height);
        }
    }

    public boolean ColineationMatrix2(Point[] l, Point[] r, Matrix H) {
        Point3DF[] cp = new Point3DF[6];
        Point3DF[] col = new Point3DF[3];
        Point3DF[] lig = new Point3DF[3];
        Point3DF[] pv = new Point3DF[3];
        double[] det = new double[6];
        Matrix H1inv = new Matrix(3, 3);
        Matrix H2 = new Matrix(3, 3);
        Matrix tmp = new Matrix(3, 3);
        cp[0] = this.CrossProduct(r[2], r[3]);
        cp[1] = this.CrossProduct(r[0], r[3]);
        cp[2] = this.CrossProduct(r[2], r[0]);
        cp[3] = this.CrossProduct(l[2], l[3]);
        cp[4] = this.CrossProduct(l[0], l[3]);
        cp[5] = this.CrossProduct(l[2], l[0]);
        det[0] = this.DotProduct(r[0], cp[0]);
        det[1] = this.DotProduct(r[1], cp[1]);
        det[2] = this.DotProduct(r[1], cp[2]);
        det[3] = this.DotProduct(l[0], cp[3]);
        det[4] = this.DotProduct(l[1], cp[4]);
        det[5] = this.DotProduct(l[1], cp[5]);
        col[0] = this.ScalarMultiply(r[1], det[0]);
        col[1] = this.ScalarMultiply(r[2], det[1]);
        col[2] = this.ScalarMultiply(r[3], det[2]);
        pv[0] = this.CrossProduct(l[2], l[3]);
        pv[1] = this.CrossProduct(l[3], l[1]);
        pv[2] = this.CrossProduct(l[1], l[2]);
        if (det[0] != 0.0 && det[1] != 0.0 && det[2] != 0.0 && det[3] != 0.0 && det[4] != 0.0 && det[5] != 0.0) {
            lig[0] = this.ScalarMultiply(pv[0], 1.0 / det[3]);
            lig[1] = this.ScalarMultiply(pv[1], 1.0 / det[4]);
            lig[2] = this.ScalarMultiply(pv[2], 1.0 / det[5]);
            H1inv.set(0, 0, lig[0].getX());
            H1inv.set(0, 1, lig[0].getY());
            H1inv.set(0, 2, lig[0].getZ());
            H1inv.set(1, 0, lig[1].getX());
            H1inv.set(1, 1, lig[1].getY());
            H1inv.set(1, 2, lig[1].getZ());
            H1inv.set(2, 0, lig[2].getX());
            H1inv.set(2, 1, lig[2].getY());
            H1inv.set(2, 2, lig[2].getZ());
            H2.set(0, 0, col[0].getX());
            H2.set(1, 0, col[0].getY());
            H2.set(2, 0, col[0].getZ());
            H2.set(0, 1, col[1].getX());
            H2.set(1, 1, col[1].getY());
            H2.set(2, 1, col[1].getZ());
            H2.set(0, 2, col[2].getX());
            H2.set(1, 2, col[2].getY());
            H2.set(2, 2, col[2].getZ());
            this.MatrixMultiply(H2, H1inv, tmp);
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int j = 0; j < 3; ++j) {
                    H.set(i2, j, tmp.get(i2, j) / tmp.get(2, 2));
                }
            }
            return true;
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j = 0; j < 3; ++j) {
                H.set(i3, j, i3 == j ? 1.0 : 0.0);
            }
        }
        return false;
    }

    private Point CrossProduct(Point v1, Point v2) {
        return new Point3DF(v1.getY() * v2.getZ() - v1.getZ() * v2.getY(), v1.getZ() * v2.getX() - v1.getX() * v2.getZ(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
    }

    private Point ScalarMultiply(Point v, double l) {
        return new Point3DF(l * v.getX(), l * v.getY(), l * v.getZ());
    }

    private double DotProduct(Point v1, Point v2) {
        return v1.getX() * v2.getX() + v1.getY() * v2.getY() + v1.getZ() * v2.getZ();
    }

    private void MatrixMultiply(Matrix m1, Matrix m2, Matrix result) {
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                double res = 0.0;
                for (int k = 0; k < 3; ++k) {
                    res += m1.get(i2, k) * m2.get(k, j);
                }
                result.set(i2, j, res);
            }
        }
    }
}

