/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorDouble;
import mathematics.matriciel.VectorI;
import mathematics.matriciel.VectorInt;

public final class VectorTools {
    public static Vector CrossProduct(Vector U, Vector V) {
        if (U.Dimension() != 3 || V.Dimension() != 3) {
            throw new IllegalArgumentException("Vectors must have 3 dimensions.");
        }
        return new VectorDouble(new double[]{U.get(1) * V.get(2) - U.get(2) * V.get(1), U.get(2) * V.get(0) - U.get(0) * V.get(2), U.get(0) * V.get(1) - U.get(1) * V.get(0)});
    }

    public VectorI CrossProduct(VectorI U, VectorI V) {
        if (U.Dimension() != 3 || V.Dimension() != 3) {
            throw new IllegalArgumentException("Vectors must have 3 dimensions.");
        }
        return new VectorInt(new int[]{U.get(1) * V.get(2) - U.get(2) * V.get(1), U.get(2) * V.get(0) - U.get(0) * V.get(2), U.get(0) * V.get(1) - U.get(1) * V.get(0)});
    }

    public Vector CrossProduct(Vector U, VectorI V) {
        if (U.Dimension() != 3 || V.Dimension() != 3) {
            throw new IllegalArgumentException("Vectors must have 3 dimensions.");
        }
        return new VectorDouble(new double[]{U.get(1) * (double)V.get(2) - U.get(2) * (double)V.get(1), U.get(2) * (double)V.get(0) - U.get(0) * (double)V.get(2), U.get(0) * (double)V.get(1) - U.get(1) * (double)V.get(0)});
    }

    public double DotProduct(Vector U, Vector V) {
        if (U.Dimension() != V.Dimension()) {
            throw new IllegalArgumentException("Vectors have different dimensions.");
        }
        double sum = 0.0;
        double[] u = U.get();
        double[] v = V.get();
        for (int i2 = 0; i2 < u.length; ++i2) {
            sum += u[i2] * v[i2];
        }
        v = null;
        u = null;
        return sum;
    }

    public int DotProduct(VectorI U, VectorI V) {
        if (U.Dimension() != V.Dimension()) {
            throw new IllegalArgumentException("Vectors have different dimensions.");
        }
        int sum = 0;
        int[] u = U.get();
        int[] v = V.get();
        for (int i2 = 0; i2 < u.length; ++i2) {
            sum += u[i2] * v[i2];
        }
        v = null;
        u = null;
        return sum;
    }

    public double DotProduct(Vector U, VectorI V) {
        if (U.Dimension() != V.Dimension()) {
            throw new IllegalArgumentException("Vectors have different dimensions.");
        }
        double sum = 0.0;
        double[] u = U.get();
        int[] v = V.get();
        for (int i2 = 0; i2 < u.length; ++i2) {
            sum += u[i2] * (double)v[i2];
        }
        u = null;
        v = null;
        return sum;
    }
}

