/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayTools;
import mathematics.matriciel.Vector;
import mathematics.norms.Norm;

public class VectorDouble
implements Vector {
    private double[] vector = null;

    public VectorDouble(int Dimension2) {
        this.vector = new double[Dimension2];
    }

    public VectorDouble(double[] values) {
        this(values.length);
        System.arraycopy(values, 0, this.vector, 0, values.length);
    }

    public VectorDouble(Vector v) {
        this(v.get());
    }

    public void Display() {
        for (int i2 = 0; i2 < this.vector.length; ++i2) {
            System.out.print(this.vector[i2] + " ");
        }
    }

    @Override
    public double[] get() {
        return this.vector;
    }

    @Override
    public double get(int x) {
        return this.vector[x];
    }

    @Override
    public void set(double[] values) {
        System.arraycopy(values, 0, this.vector, 0, values.length);
    }

    @Override
    public void set(int x, double value) {
        this.vector[x] = value;
    }

    @Override
    public int Dimension() {
        return this.vector.length;
    }

    @Override
    public void Add(double x) {
        ArrayArithmetic.Add((double[])this.vector, (double)x, (double[])this.vector);
    }

    @Override
    public void Add(double[] x) {
        ArrayArithmetic.Add((double[])this.vector, (double[])x, (double[])this.vector);
    }

    @Override
    public void Times(double x) {
        ArrayArithmetic.Multiply((double[])this.vector, (double)x, (double[])this.vector);
    }

    @Override
    public boolean Equal(Vector v, double Epsilon) {
        return ArrayTools.AreEqual((double[])this.vector, (double[])v.get());
    }

    @Override
    public double Norm(Norm norm) {
        return norm.Norm(this);
    }

    @Override
    public void Standardize() {
        double max = Math.abs(this.vector[0]);
        for (int i2 = 1; i2 < this.vector.length; ++i2) {
            if (!(max < Math.abs(this.vector[i2]))) continue;
            max = Math.abs(this.vector[i2]);
        }
        ArrayArithmetic.Divide((double[])this.vector, (double)max, (double[])this.vector);
    }

    @Override
    public Vector Clone() {
        return new VectorDouble(this.vector);
    }
}

