/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;

public class QRDecomposition {
    public void Calculer(Matrix M, double[] vp, double[] ivp) {
        int i2;
        if (M == null) {
            throw new NullPointerException("Matrice nulle.");
        }
        if (vp == null) {
            throw new NullPointerException("vp == null.");
        }
        if (ivp == null) {
            throw new NullPointerException("ivp == null.");
        }
        if (M.getColumnDimension() <= 1 || M.getColumnDimension() != M.getRowDimension()) {
            throw new Error("Matrice non carree ou dimensions trops petites : lignes = " + M.getRowDimension() + ", colonnes = " + M.getColumnDimension());
        }
        double[] evr = new double[vp.length + 1];
        double[] evi = new double[vp.length + 1];
        Matrix copie = new Matrix(M.getRowDimension() + 1, M.getColumnDimension() + 1);
        for (i2 = 0; i2 < M.getRowDimension(); ++i2) {
            for (int j = 0; j < M.getColumnDimension(); ++j) {
                copie.set(i2 + 1, j + 1, M.get(i2, j));
            }
        }
        this.Calculer2(copie.getArray(), M.getRowDimension(), evr, evi);
        for (i2 = 0; i2 < vp.length; ++i2) {
            vp[i2] = evr[i2 + 1];
            ivp[i2] = evi[i2 + 1];
        }
        evr = null;
        evi = null;
        copie = null;
    }

    private void Calculer2(double[][] a, int n, double[] wr, double[] wi) {
        int j;
        int i2;
        double anorm = 0.0;
        double r = 0.0;
        double q = 0.0;
        double p = 0.0;
        for (i2 = 1; i2 <= n; ++i2) {
            for (j = this.IMAX(i2 - 1, 1); j <= n; ++j) {
                anorm += Math.abs(a[i2][j]);
            }
        }
        int nn = n;
        double t = 0.0;
        while (nn >= 1) {
            int l;
            int its = 0;
            do {
                int m;
                double z;
                double s;
                for (l = nn; l >= 2; --l) {
                    s = Math.abs(a[l - 1][l - 1] + a[l][l]);
                    if (s == 0.0) {
                        s = anorm;
                    }
                    if (Math.abs(a[l][l - 1]) + s != s) continue;
                    a[l][l - 1] = 0.0;
                    break;
                }
                double x = a[nn][nn];
                if (l == nn) {
                    wr[nn] = x + t;
                    wi[nn--] = 0.0;
                    continue;
                }
                double y = a[nn - 1][nn - 1];
                double w = a[nn][nn - 1] * a[nn - 1][nn];
                if (l == nn - 1) {
                    p = 0.5 * (y - x);
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    x += t;
                    if (q >= 0.0) {
                        z = p + this.SIGN(z, p);
                        wr[nn - 1] = wr[nn] = x + z;
                        if (z > 0.0) {
                            wr[nn] = x - w / z;
                        }
                        wi[nn] = 0.0;
                        wi[nn - 1] = 0.0;
                    } else {
                        wr[nn - 1] = wr[nn] = x + p;
                        wi[nn] = z;
                        wi[nn - 1] = -wi[nn];
                    }
                    nn -= 2;
                    continue;
                }
                if (its == 30) {
                    throw new Error("Too many iteration in QR");
                }
                if (its == 10 || its == 20) {
                    t += x;
                    i2 = 1;
                    while (i2 <= nn) {
                        double[] dArray = a[i2];
                        int n2 = i2++;
                        dArray[n2] = dArray[n2] - x;
                    }
                    s = Math.abs(a[nn][nn - 1] + a[nn - 1][nn - 2]);
                    y = x = 0.75 * s;
                    w = 0.4375 * s * s;
                }
                ++its;
                for (m = nn - 2; m >= l; --m) {
                    double v;
                    double u;
                    z = a[m][m];
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / a[m + 1][m] + a[m][m + 1];
                    q = a[m + 1][m + 1] - z - r - s;
                    r = a[m + 2][m + 1];
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || Double.compare((u = Math.abs(a[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s))) + (v = Math.abs(p /= s) * (Math.abs(a[m - 1][m - 1]) + Math.abs(z) + Math.abs(a[m + 1][m + 1]))), v) == 0) break;
                }
                for (i2 = m + 2; i2 <= nn; ++i2) {
                    a[i2][i2 - 2] = 0.0;
                    if (i2 == m + 2) continue;
                    a[i2][i2 - 3] = 0.0;
                }
                for (int k = m; k <= nn; ++k) {
                    if (k != m) {
                        p = a[k][k - 1];
                        q = a[k + 1][k - 1];
                        r = 0.0;
                        if (k != nn - 1) {
                            r = a[k + 2][k - 1];
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if ((s = this.SIGN(Math.sqrt(p * p + q * q + r * r), p)) == 0.0) continue;
                    if (k == m) {
                        if (l != m) {
                            a[k][k - 1] = -a[k][k - 1];
                        }
                    } else {
                        a[k][k - 1] = -s * x;
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    j = k;
                    while (j <= nn) {
                        p = a[k][j] + q * a[k + 1][j];
                        if (k != nn - 1) {
                            double[] dArray = a[k + 2];
                            int n3 = j;
                            dArray[n3] = dArray[n3] - (p += r * a[k + 2][j]) * z;
                        }
                        double[] dArray = a[k + 1];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - p * y;
                        double[] dArray2 = a[k];
                        int n5 = j++;
                        dArray2[n5] = dArray2[n5] - p * x;
                    }
                    int mmin = nn < k + 3 ? nn : k + 3;
                    for (i2 = l; i2 <= mmin; ++i2) {
                        p = x * a[i2][k] + y * a[i2][k + 1];
                        if (k != nn - 1) {
                            double[] dArray = a[i2];
                            int n6 = k + 2;
                            dArray[n6] = dArray[n6] - (p += z * a[i2][k + 2]) * r;
                        }
                        double[] dArray = a[i2];
                        int n7 = k + 1;
                        dArray[n7] = dArray[n7] - p * q;
                        double[] dArray3 = a[i2];
                        int n8 = k;
                        dArray3[n8] = dArray3[n8] - p;
                    }
                }
            } while (l < nn - 1);
        }
    }

    private int IMAX(int a, int b) {
        return a > b ? a : b;
    }

    private double SIGN(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }
}

