/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;
import mathematics.Maths;

public class QR2Decomposition {
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public void Compute(Matrix A) {
        this.QR = (double[][])A.getArray().clone();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.Rdiag = new double[this.n];
        for (int k = 0; k < this.n; ++k) {
            int i2;
            double nrm = 0.0;
            for (i2 = k; i2 < this.m; ++i2) {
                nrm = Maths.Hypot((double)nrm, (double)this.QR[i2][k]);
            }
            if (nrm != 0.0) {
                if (this.QR[k][k] < 0.0) {
                    nrm = -nrm;
                }
                for (i2 = k; i2 < this.m; ++i2) {
                    double[] dArray = this.QR[i2];
                    int n = k;
                    dArray[n] = dArray[n] / nrm;
                }
                double[] dArray = this.QR[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (int j = k + 1; j < this.n; ++j) {
                    double s = 0.0;
                    for (i2 = k; i2 < this.m; ++i2) {
                        s += this.QR[i2][k] * this.QR[i2][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i2 = k; i2 < this.m; ++i2) {
                        double[] dArray2 = this.QR[i2];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + s * this.QR[i2][k];
                    }
                }
            }
            this.Rdiag[k] = -nrm;
        }
    }

    public boolean isFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getQ() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] Q = (double[][])X.getArray().clone();
        for (int k = this.n - 1; k >= 0; --k) {
            int i2;
            for (i2 = 0; i2 < this.m; ++i2) {
                Q[i2][k] = 0.0;
            }
            Q[k][k] = 1.0;
            for (int j = k; j < this.n; ++j) {
                if (this.QR[k][k] == 0.0) continue;
                double s = 0.0;
                for (i2 = k; i2 < this.m; ++i2) {
                    s += this.QR[i2][k] * Q[i2][j];
                }
                s = -s / this.QR[k][k];
                for (i2 = k; i2 < this.m; ++i2) {
                    double[] dArray = Q[i2];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i2][k];
                }
            }
        }
        return X;
    }

    public Matrix Solve(Matrix B) {
        int i2;
        int j;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.getColumnDimension();
        double[][] X = (double[][])B.getArray().clone();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                double s = 0.0;
                for (i2 = k; i2 < this.m; ++i2) {
                    s += this.QR[i2][k] * X[i2][j];
                }
                s = -s / this.QR[k][k];
                for (i2 = k; i2 < this.m; ++i2) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i2][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.Rdiag[k];
            }
            for (i2 = 0; i2 < k; ++i2) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.QR[i2][k];
                }
            }
        }
        return new Matrix(X).getMatrix(0, this.n - 1, 0, nx - 1);
    }

    public double[][] getQR() {
        return this.QR;
    }

    public double[] getVP() {
        return this.Rdiag;
    }
}

