/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;

public class MatrixArithmetic {
    public static Matrix Multiply(Matrix A, Matrix B) {
        return A.times(B);
    }

    public static void Multiply(Matrix A, Matrix B, Matrix X) {
        if (A.getColumnDimension() != B.getRowDimension()) {
            throw new IllegalArgumentException("Matrix dimensions (A and B) don't match.");
        }
        if (A.getRowDimension() != X.getRowDimension()) {
            throw new IllegalArgumentException("C matrix dimensions don't match.");
        }
        if (B.getColumnDimension() != X.getColumnDimension()) {
            throw new IllegalArgumentException("C matrix dimensions don't match.");
        }
        int Arow = A.getRowDimension();
        int dim = A.getColumnDimension();
        int Bcol = B.getColumnDimension();
        double[][] Aa = A.getArray();
        double[][] Ba = B.getArray();
        double[][] Xa = X.getArray();
        double[] Arowi = null;
        double[] Bcolj = new double[dim];
        for (int j = 0; j < Bcol; ++j) {
            int k;
            for (k = 0; k < dim; ++k) {
                Bcolj[k] = Ba[k][j];
            }
            for (int i2 = 0; i2 < Arow; ++i2) {
                Arowi = Aa[i2];
                double s = 0.0;
                for (k = 0; k < dim; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                Xa[i2][j] = s;
                Arowi = null;
            }
        }
        Xa = null;
        Ba = null;
        Aa = null;
        Bcolj = null;
    }
}

