/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;

public class LUDecomposition {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;
    private double[] LUcolj = null;

    public LUDecomposition() {
    }

    public LUDecomposition(Matrix M) {
        this.Compute(M);
    }

    public void Compute(Matrix A) {
        int j;
        int i2;
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        if (this.LU == null || this.LU.length != A.getArray().length || this.LU[0].length != A.getArray()[0].length) {
            this.LU = null;
            this.LU = (double[][])A.getArray().clone();
        }
        for (i2 = 0; i2 < this.m; ++i2) {
            for (j = 0; j < this.n; ++j) {
                this.LU[i2][j] = A.getArray()[i2][j];
            }
        }
        if (this.piv == null || this.piv.length != this.m) {
            this.piv = null;
            this.piv = new int[this.m];
            this.LUcolj = null;
            this.LUcolj = new double[this.m];
        }
        for (i2 = 0; i2 < this.m; ++i2) {
            this.piv[i2] = i2;
        }
        this.pivsign = 1;
        for (j = 0; j < this.n; ++j) {
            int k;
            for (i2 = 0; i2 < this.m; ++i2) {
                this.LUcolj[i2] = this.LU[i2][j];
            }
            i2 = 0;
            while (i2 < this.m) {
                double[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * this.LUcolj[k];
                }
                int n = i2++;
                double d = this.LUcolj[n] - s;
                this.LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i2 = j + 1; i2 < this.m; ++i2) {
                if (!(Math.abs(this.LUcolj[i2]) > Math.abs(this.LUcolj[p]))) continue;
                p = i2;
            }
            if (p != j) {
                for (k = 0; k < this.n; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & this.LU[j][j] != 0.0)) continue;
            for (i2 = j + 1; i2 < this.m; ++i2) {
                double[] dArray = this.LU[i2];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] L = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                L[i2][j] = i2 > j ? this.LU[i2][j] : (i2 == j ? 1.0 : 0.0);
            }
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] U = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                U[i2][j] = i2 <= j ? this.LU[i2][j] : 0.0;
            }
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        System.arraycopy(this.piv, 0, p, 0, this.m);
        return p;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            vals[i2] = this.piv[i2];
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i2;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getArray();
        for (k = 0; k < this.n; ++k) {
            for (i2 = k + 1; i2 < this.n; ++i2) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i2][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            for (i2 = 0; i2 < k; ++i2) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i2][k];
                }
            }
        }
        return Xmat;
    }
}

