/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;

public class Jacobi {
    protected int nbRotation = -1;

    public void Compute(Matrix M, double[] ValeursPropres, Matrix VecteursPropres) {
        int j;
        int i2;
        if (M.getColumnDimension() <= 1 || M.getColumnDimension() != M.getRowDimension()) {
            throw new IllegalArgumentException("matrice non carree ou dimensions trops petites : lignes = " + M.getRowDimension() + ", colonnes = " + M.getColumnDimension());
        }
        double[] EigenValues = new double[ValeursPropres.length + 1];
        Matrix copie = new Matrix(M.getRowDimension() + 1, M.getColumnDimension() + 1);
        Matrix EigenVectors = new Matrix(M.getRowDimension() + 1, M.getColumnDimension() + 1);
        for (i2 = 0; i2 < M.getRowDimension(); ++i2) {
            for (j = 0; j < M.getColumnDimension(); ++j) {
                copie.set(i2 + 1, j + 1, M.get(i2, j));
            }
        }
        this.Calculer2(copie, M.getRowDimension(), EigenValues, EigenVectors);
        this.EigSort(EigenValues, EigenVectors, M.getRowDimension());
        for (i2 = 0; i2 < M.getRowDimension(); ++i2) {
            for (j = 0; j < M.getColumnDimension(); ++j) {
                M.set(i2, j, copie.get(i2 + 1, j + 1));
                VecteursPropres.set(i2, j, EigenVectors.get(i2 + 1, j + 1));
            }
        }
        for (i2 = 0; i2 < ValeursPropres.length; ++i2) {
            ValeursPropres[i2] = EigenValues[i2 + 1];
        }
    }

    private void Calculer2(Matrix a, int n, double[] d, Matrix v) {
        int iq;
        int ip;
        double[] b = this.vectornr(1, n);
        double[] z = this.vectornr(1, n);
        for (ip = 1; ip <= n; ++ip) {
            for (iq = 1; iq <= n; ++iq) {
                v.set(ip, iq, 0.0);
            }
            v.set(ip, ip, 1.0);
        }
        for (ip = 1; ip <= n; ++ip) {
            b[ip] = d[ip] = a.get(ip, ip);
            z[ip] = 0.0;
        }
        this.nbRotation = 0;
        for (int i2 = 1; i2 <= 100; ++i2) {
            double sm = 0.0;
            for (ip = 1; ip <= n - 1; ++ip) {
                for (iq = ip + 1; iq <= n; ++iq) {
                    sm += Math.abs(a.get(ip, iq));
                }
            }
            if (sm == 0.0) {
                z = null;
                b = null;
                return;
            }
            double tresh = i2 < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            for (ip = 1; ip <= n - 1; ++ip) {
                for (iq = ip + 1; iq <= n; ++iq) {
                    int j;
                    double t;
                    double g = 100.0 * Math.abs(a.get(ip, iq));
                    if (i2 > 4 && Math.abs(d[ip]) + g == Math.abs(d[ip]) && Math.abs(d[iq]) + g == Math.abs(d[iq])) {
                        a.set(ip, iq, 0.0);
                        continue;
                    }
                    if (!(Math.abs(a.get(ip, iq)) > tresh)) continue;
                    double h = d[iq] - d[ip];
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = a.get(ip, iq) / h;
                    } else {
                        double theta = 0.5 * h / a.get(ip, iq);
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * a.get(ip, iq);
                    int n2 = ip;
                    z[n2] = z[n2] - h;
                    int n3 = iq;
                    z[n3] = z[n3] + h;
                    int n4 = ip;
                    d[n4] = d[n4] - h;
                    int n5 = iq;
                    d[n5] = d[n5] + h;
                    a.set(ip, iq, 0.0);
                    for (j = 1; j <= ip - 1; ++j) {
                        this.Rotatenr(a, j, ip, j, iq, h, s, g, tau);
                    }
                    for (j = ip + 1; j <= iq - 1; ++j) {
                        this.Rotatenr(a, ip, j, j, iq, h, s, g, tau);
                    }
                    for (j = iq + 1; j <= n; ++j) {
                        this.Rotatenr(a, ip, j, iq, j, h, s, g, tau);
                    }
                    for (j = 1; j <= n; ++j) {
                        this.Rotatenr(v, j, ip, j, iq, h, s, g, tau);
                    }
                    ++this.nbRotation;
                }
            }
            for (ip = 1; ip <= n; ++ip) {
                int n6 = ip;
                b[n6] = b[n6] + z[ip];
                d[ip] = b[ip];
                z[ip] = 0.0;
            }
        }
        throw new Error("Too much iterations in routine Jacobi.");
    }

    private void EigSort(double[] d, Matrix v, int n) {
        for (int i2 = 1; i2 < n; ++i2) {
            int j;
            int k = i2;
            double p = d[k];
            for (j = i2 + 1; j <= n; ++j) {
                if (!(d[j] >= p)) continue;
                k = j;
                p = d[k];
            }
            if (k == i2) continue;
            d[k] = d[i2];
            d[i2] = p;
            for (j = 1; j <= n; ++j) {
                p = v.get(j, i2);
                v.set(j, i2, v.get(j, k));
                v.set(j, k, p);
            }
        }
    }

    private void Rotatenr(Matrix a, int i2, int j, int k, int l, double h, double s, double g, double tau) {
        g = a.get(i2, j);
        h = a.get(k, l);
        a.set(i2, j, g - s * (h + g * tau));
        a.set(k, l, h + s * (g - h * tau));
    }

    private double[] vectornr(int nl, int nh) {
        int NR_END = 1;
        double[] v = new double[nh - nl + 1 + NR_END];
        return v;
    }

    public int getnbRotation() {
        return this.nbRotation;
    }
}

