/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;
import arrayTiTi.ArrayNew;
import mathematics.matriciel.LUDecomposition;
import mathematics.matriciel.QR2Decomposition;

public class Inverse {
    private Matrix id = null;
    private LUDecomposition lu = new LUDecomposition();
    private QR2Decomposition qr = new QR2Decomposition();

    public Matrix Gauss(Matrix a) {
        int r;
        if (a.getColumnDimension() != a.getRowDimension()) {
            throw new IllegalArgumentException("Non square matrix (stupid user) !!!");
        }
        int N = a.getRowDimension();
        Matrix aa = new Matrix(a.getArray());
        Matrix x = Matrix.identity((int)a.getRowDimension(), (int)a.getColumnDimension());
        for (r = 0; r < N; ++r) {
            int j;
            double pmax = Math.abs(aa.get(r, r));
            int imax = r;
            for (int i2 = r + 1; i2 < N; ++i2) {
                if (!(Math.abs(aa.get(i2, r)) > pmax)) continue;
                imax = i2;
                pmax = Math.abs(aa.get(i2, r));
            }
            if (pmax == 0.0) {
                throw new Error("Matrice non inversible");
            }
            for (j = r; j < N; ++j) {
                double tmp = aa.get(r, j);
                aa.set(r, j, aa.get(imax, j));
                aa.set(imax, j, tmp);
            }
            for (j = 0; j < x.getColumnDimension(); ++j) {
                double tmp = x.get(r, j);
                x.set(r, j, x.get(imax, j));
                x.set(imax, j, tmp);
            }
            for (int i3 = r + 1; i3 < N; ++i3) {
                int j2;
                double pivot = -aa.get(i3, r) / aa.get(r, r);
                for (j2 = r; j2 < N; ++j2) {
                    aa.set(i3, j2, aa.get(i3, j2) + pivot * aa.get(r, j2));
                }
                for (j2 = 0; j2 < x.getColumnDimension(); ++j2) {
                    x.set(i3, j2, x.get(i3, j2) + pivot * x.get(r, j2));
                }
            }
        }
        for (r = N - 1; r >= 0; --r) {
            for (int i4 = 0; i4 < r; ++i4) {
                double pivot = -aa.get(i4, r) / aa.get(r, r);
                for (int j = 0; j < x.getColumnDimension(); ++j) {
                    x.set(i4, j, x.get(i4, j) + pivot * x.get(r, j));
                }
            }
            for (int j = 0; j < x.getColumnDimension(); ++j) {
                x.set(r, j, x.get(r, j) / aa.get(r, r));
            }
        }
        return x;
    }

    public Matrix GaussJordan(Matrix M, double epsilon) {
        if (M.getColumnDimension() != M.getRowDimension()) {
            throw new Error("Not square matrix: " + M.getColumnDimension() + " =/= " + M.getRowDimension());
        }
        Matrix res = new Matrix(M.getRowDimension(), M.getColumnDimension());
        this.GaussJordan(M, res, epsilon);
        return res;
    }

    public void GaussJordan(Matrix M, Matrix R, double epsilon) {
        this.GaussJordan(M.getArray(), R.getArray(), epsilon);
    }

    public void GaussJordan(double[][] mat1, double[][] mat2, double epsilon) {
        if (mat1.length != mat1[0].length) {
            throw new Error("Not square matrix: " + mat1.length + " =/= " + mat1[0].length);
        }
        if (mat2.length != mat2[0].length) {
            throw new Error("Not square matrix: " + mat2.length + " =/= " + mat2[0].length);
        }
        if (mat1.length != mat2.length) {
            throw new Error("Matrices have differents dimensions: " + mat1.length + " =/= " + mat2.length);
        }
        int dim = mat1.length;
        double[][] temp = new double[dim][dim];
        this.copie_matriceR(mat1, temp, dim);
        double b = 0.0;
        double a = 0.0;
        int c = 0;
        this.Identity(mat2);
        for (int k = 0; k < dim; ++k) {
            a = temp[k][k];
            c = 0;
            while (Math.abs(a) < epsilon) {
                ++c;
                for (int q = 0; q < dim; ++q) {
                    double[] dArray = temp[k];
                    int n = q;
                    dArray[n] = dArray[n] + temp[k + c][q];
                    double[] dArray2 = mat2[k];
                    int n2 = q;
                    dArray2[n2] = dArray2[n2] + mat2[k + c][q];
                }
                a = temp[k][k];
            }
            int l = 0;
            while (l < dim) {
                double[] dArray = temp[k];
                int n = l;
                dArray[n] = dArray[n] / a;
                double[] dArray3 = mat2[k];
                int n3 = l++;
                dArray3[n3] = dArray3[n3] / a;
            }
            for (int i2 = 0; i2 < dim; ++i2) {
                b = temp[i2][k];
                if (i2 == k) continue;
                for (int j = 0; j < dim; ++j) {
                    double[] dArray = temp[i2];
                    int n = j;
                    dArray[n] = dArray[n] - b * temp[k][j];
                    double[] dArray4 = mat2[i2];
                    int n4 = j;
                    dArray4[n4] = dArray4[n4] - b * mat2[k][j];
                }
            }
        }
        temp = null;
    }

    private void copie_matriceR(double[][] mat1, double[][] mat2, int dim) {
        ArrayNew.Copy((double[][])mat1, (double[][])mat2);
    }

    public void Identity(double[][] mat) {
        if (mat.length != mat[0].length) {
            throw new IllegalArgumentException("Not square matrix: " + mat.length + " =/=" + mat[0].length);
        }
        for (int i2 = 0; i2 < mat.length; ++i2) {
            for (int j = 0; j < mat[0].length; ++j) {
                mat[i2][j] = i2 == j ? 1.0 : 0.0;
            }
        }
    }

    public Matrix LU(Matrix m) {
        if (m.getRowDimension() != m.getColumnDimension()) {
            throw new IllegalArgumentException("Not square matrix: " + m.getRowDimension() + " =/=" + m.getColumnDimension());
        }
        if (this.id == null || this.id.getRowDimension() != m.getRowDimension()) {
            this.id = null;
            this.id = new Matrix(m.getRowDimension(), m.getColumnDimension());
            this.Identity(this.id.getArray());
        }
        this.lu.Compute(m);
        return this.lu.solve(this.id);
    }

    public Matrix QR(Matrix m) {
        if (m.getRowDimension() != m.getColumnDimension()) {
            throw new IllegalArgumentException("Not square matrix: " + m.getRowDimension() + " =/=" + m.getColumnDimension());
        }
        if (this.id == null || this.id.getRowDimension() != m.getRowDimension()) {
            this.id = null;
            this.id = new Matrix(m.getRowDimension(), m.getColumnDimension());
            this.Identity(this.id.getArray());
        }
        this.qr.Compute(m);
        return this.lu.solve(this.id);
    }
}

