/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;
import mathematics.Maths;

public class EigensValuesDecomposition {
    private int n;
    private boolean issymmetric;
    private double[] d;
    private double[] e;
    private double[][] V;
    private double[][] H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;

    public EigensValuesDecomposition(Matrix Arg) {
        int i2;
        double[][] A = (double[][])Arg.getArray().clone();
        this.n = Arg.getColumnDimension();
        this.V = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = true;
        int j = 0;
        while (j < this.n & this.issymmetric) {
            i2 = 0;
            while (i2 < this.n & this.issymmetric) {
                this.issymmetric = A[i2][j] == A[j][i2];
                ++i2;
            }
            ++j;
        }
        if (this.issymmetric) {
            for (i2 = 0; i2 < this.n; ++i2) {
                for (j = 0; j < this.n; ++j) {
                    this.V[i2][j] = A[i2][j];
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new double[this.n][this.n];
            this.ort = new double[this.n];
            for (j = 0; j < this.n; ++j) {
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.H[i2][j] = A[i2][j];
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    private void tred2() {
        int i2;
        System.arraycopy(this.V[this.n - 1], 0, this.d, 0, this.n);
        for (i2 = this.n - 1; i2 > 0; --i2) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i2; ++k) {
                scale += Math.abs(this.d[k]);
            }
            if (scale == 0.0) {
                this.e[i2] = this.d[i2 - 1];
                for (int j = 0; j < i2; ++j) {
                    this.d[j] = this.V[i2 - 1][j];
                    this.V[i2][j] = 0.0;
                    this.V[j][i2] = 0.0;
                }
            } else {
                int j;
                int j2;
                for (k = 0; k < i2; ++k) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                }
                double f = this.d[i2 - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i2] = scale * g;
                h -= f * g;
                this.d[i2 - 1] = f - g;
                for (j2 = 0; j2 < i2; ++j2) {
                    this.e[j2] = 0.0;
                }
                for (j2 = 0; j2 < i2; ++j2) {
                    this.V[j2][i2] = f = this.d[j2];
                    g = this.e[j2] + this.V[j2][j2] * f;
                    for (int k2 = j2 + 1; k2 <= i2 - 1; ++k2) {
                        g += this.V[k2][j2] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V[k2][j2] * f;
                    }
                    this.e[j2] = g;
                }
                f = 0.0;
                for (j2 = 0; j2 < i2; ++j2) {
                    int n = j2;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j2] * this.d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i2; ++j) {
                    int n = j;
                    this.e[n] = this.e[n] - hh * this.d[j];
                }
                for (j = 0; j < i2; ++j) {
                    f = this.d[j];
                    g = this.e[j];
                    for (int k3 = j; k3 <= i2 - 1; ++k3) {
                        double[] dArray = this.V[k3];
                        int n = j;
                        dArray[n] = dArray[n] - (f * this.e[k3] + g * this.d[k3]);
                    }
                    this.d[j] = this.V[i2 - 1][j];
                    this.V[i2][j] = 0.0;
                }
            }
            this.d[i2] = h;
        }
        for (i2 = 0; i2 < this.n - 1; ++i2) {
            int k;
            this.V[this.n - 1][i2] = this.V[i2][i2];
            this.V[i2][i2] = 1.0;
            double h = this.d[i2 + 1];
            if (h != 0.0) {
                for (k = 0; k <= i2; ++k) {
                    this.d[k] = this.V[k][i2 + 1] / h;
                }
                for (int j = 0; j <= i2; ++j) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i2; ++k4) {
                        g += this.V[k4][i2 + 1] * this.V[k4][j];
                    }
                    for (k4 = 0; k4 <= i2; ++k4) {
                        double[] dArray = this.V[k4];
                        int n = j;
                        dArray[n] = dArray[n] - g * this.d[k4];
                    }
                }
            }
            for (k = 0; k <= i2; ++k) {
                this.V[k][i2 + 1] = 0.0;
            }
        }
        for (int j = 0; j < this.n; ++j) {
            this.d[j] = this.V[this.n - 1][j];
            this.V[this.n - 1][j] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i2 = 1; i2 < this.n; ++i2) {
            this.e[i2 - 1] = this.e[i2];
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = Maths.Hypot((double)p, (double)1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i3 = l + 2;
                    while (i3 < this.n) {
                        int n = i3++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i4 = m - 1; i4 >= l; --i4) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i4];
                        h = c * p;
                        r = Maths.Hypot((double)p, (double)this.e[i4]);
                        this.e[i4 + 1] = s * r;
                        s = this.e[i4] / r;
                        c = p / r;
                        p = c * this.d[i4] - s * g;
                        this.d[i4 + 1] = h + s * (c * g + s * this.d[i4]);
                        for (int k = 0; k < this.n; ++k) {
                            h = this.V[k][i4 + 1];
                            this.V[k][i4 + 1] = s * this.V[k][i4] + c * h;
                            this.V[k][i4] = c * this.V[k][i4] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            int n = l;
            this.d[n] = this.d[n] + f;
            this.e[l] = 0.0;
        }
        for (int i5 = 0; i5 < this.n - 1; ++i5) {
            int j;
            int k = i5;
            double p = this.d[i5];
            for (j = i5 + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i5) continue;
            this.d[k] = this.d[i5];
            this.d[i5] = p;
            for (j = 0; j < this.n; ++j) {
                p = this.V[j][i5];
                this.V[j][i5] = this.V[j][k];
                this.V[j][k] = p;
            }
        }
    }

    private void orthes() {
        int m;
        int low = 0;
        int high = this.n - 1;
        for (m = low + 1; m <= high - 1; ++m) {
            double f;
            double scale = 0.0;
            for (int i2 = m; i2 <= high; ++i2) {
                scale += Math.abs(this.H[i2][m - 1]);
            }
            if (scale == 0.0) continue;
            double h = 0.0;
            for (int i3 = high; i3 >= m; --i3) {
                this.ort[i3] = this.H[i3][m - 1] / scale;
                h += this.ort[i3] * this.ort[i3];
            }
            double g = Math.sqrt(h);
            if (this.ort[m] > 0.0) {
                g = -g;
            }
            h -= this.ort[m] * g;
            int n = m;
            this.ort[n] = this.ort[n] - g;
            for (int j = m; j < this.n; ++j) {
                int i4;
                f = 0.0;
                for (i4 = high; i4 >= m; --i4) {
                    f += this.ort[i4] * this.H[i4][j];
                }
                f /= h;
                for (i4 = m; i4 <= high; ++i4) {
                    double[] dArray = this.H[i4];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - f * this.ort[i4];
                }
            }
            for (int i5 = 0; i5 <= high; ++i5) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += this.ort[j] * this.H[i5][j];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    double[] dArray = this.H[i5];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - f * this.ort[j];
                }
            }
            this.ort[m] = scale * this.ort[m];
            this.H[m][m - 1] = scale * g;
        }
        for (int i6 = 0; i6 < this.n; ++i6) {
            for (int j = 0; j < this.n; ++j) {
                this.V[i6][j] = i6 == j ? 1.0 : 0.0;
            }
        }
        for (m = high - 1; m >= low + 1; --m) {
            if (this.H[m][m - 1] == 0.0) continue;
            for (int i7 = m + 1; i7 <= high; ++i7) {
                this.ort[i7] = this.H[i7][m - 1];
            }
            for (int j = m; j <= high; ++j) {
                int i8;
                double g = 0.0;
                for (i8 = m; i8 <= high; ++i8) {
                    g += this.ort[i8] * this.V[i8][j];
                }
                g = g / this.ort[m] / this.H[m][m - 1];
                for (i8 = m; i8 <= high; ++i8) {
                    double[] dArray = this.V[i8];
                    int n = j;
                    dArray[n] = dArray[n] + g * this.ort[i8];
                }
            }
        }
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    private void hqr2() {
        double y;
        int i2;
        double x;
        double w;
        int l;
        int j;
        int nn = this.n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = 0.0;
        for (int i3 = 0; i3 < nn; ++i3) {
            if (i3 < low | i3 > high) {
                this.d[i3] = this.H[i3][i3];
                this.e[i3] = 0.0;
            }
            for (j = Math.max(i3 - 1, 0); j < nn; ++j) {
                norm += Math.abs(this.H[i3][j]);
            }
        }
        int iter = 0;
        block2: while (n >= low) {
            int m;
            for (l = n; l > low; --l) {
                s = Math.abs(this.H[l - 1][l - 1]) + Math.abs(this.H[l][l]);
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(this.H[l][l - 1]) < eps * s) break;
            }
            if (l == n) {
                double[] dArray = this.H[n];
                int n2 = n;
                dArray[n2] = dArray[n2] + exshift;
                this.d[n] = this.H[n][n];
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.H[n][n - 1] * this.H[n - 1][n];
                p = (this.H[n - 1][n - 1] - this.H[n][n]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                double[] dArray = this.H[n];
                int n3 = n;
                dArray[n3] = dArray[n3] + exshift;
                double[] dArray2 = this.H[n - 1];
                int n4 = n - 1;
                dArray2[n4] = dArray2[n4] + exshift;
                x = this.H[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0;
                    this.e[n] = 0.0;
                    x = this.H[n][n - 1];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j2 = n - 1; j2 < nn; ++j2) {
                        z = this.H[n - 1][j2];
                        this.H[n - 1][j2] = q * z + p * this.H[n][j2];
                        this.H[n][j2] = q * this.H[n][j2] - p * z;
                    }
                    for (i2 = 0; i2 <= n; ++i2) {
                        z = this.H[i2][n - 1];
                        this.H[i2][n - 1] = q * z + p * this.H[i2][n];
                        this.H[i2][n] = q * this.H[i2][n] - p * z;
                    }
                    for (i2 = low; i2 <= high; ++i2) {
                        z = this.V[i2][n - 1];
                        this.V[i2][n - 1] = q * z + p * this.V[i2][n];
                        this.V[i2][n] = q * this.V[i2][n] - p * z;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.H[n][n];
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = this.H[n - 1][n - 1];
                w = this.H[n][n - 1] * this.H[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i2 = low;
                while (i2 <= n) {
                    double[] dArray = this.H[i2];
                    int n5 = i2++;
                    dArray[n5] = dArray[n5] - x;
                }
                s = Math.abs(this.H[n][n - 1]) + Math.abs(this.H[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    i2 = low;
                    while (i2 <= n) {
                        double[] dArray = this.H[i2];
                        int n6 = i2++;
                        dArray[n6] = dArray[n6] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = this.H[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.H[m + 1][m] + this.H[m][m + 1];
                q = this.H[m + 1][m + 1] - z - r - s;
                r = this.H[m + 2][m + 1];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.H[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H[m - 1][m - 1]) + Math.abs(z) + Math.abs(this.H[m + 1][m + 1])))) break;
            }
            for (int i4 = m + 2; i4 <= n; ++i4) {
                this.H[i4][i4 - 2] = 0.0;
                if (i4 <= m + 2) continue;
                this.H[i4][i4 - 3] = 0.0;
            }
            for (int k = m; k <= n - 1; ++k) {
                int i5;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.H[k][k - 1];
                    q = this.H[k + 1][k - 1];
                    r = notlast ? this.H[k + 2][k - 1] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block2;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    this.H[k][k - 1] = -s * x;
                } else if (l != m) {
                    this.H[k][k - 1] = -this.H[k][k - 1];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                int j3 = k;
                while (j3 < nn) {
                    p = this.H[k][j3] + q * this.H[k + 1][j3];
                    if (notlast) {
                        double[] dArray = this.H[k + 2];
                        int n7 = j3;
                        dArray[n7] = dArray[n7] - (p += r * this.H[k + 2][j3]) * z;
                    }
                    double[] dArray = this.H[k];
                    int n8 = j3;
                    dArray[n8] = dArray[n8] - p * x;
                    double[] dArray3 = this.H[k + 1];
                    int n9 = j3++;
                    dArray3[n9] = dArray3[n9] - p * y;
                }
                for (i5 = 0; i5 <= Math.min(n, k + 3); ++i5) {
                    p = x * this.H[i5][k] + y * this.H[i5][k + 1];
                    if (notlast) {
                        double[] dArray = this.H[i5];
                        int n10 = k + 2;
                        dArray[n10] = dArray[n10] - (p += z * this.H[i5][k + 2]) * r;
                    }
                    double[] dArray = this.H[i5];
                    int n11 = k;
                    dArray[n11] = dArray[n11] - p;
                    double[] dArray4 = this.H[i5];
                    int n12 = k + 1;
                    dArray4[n12] = dArray4[n12] - p * q;
                }
                for (i5 = low; i5 <= high; ++i5) {
                    p = x * this.V[i5][k] + y * this.V[i5][k + 1];
                    if (notlast) {
                        double[] dArray = this.V[i5];
                        int n13 = k + 2;
                        dArray[n13] = dArray[n13] - (p += z * this.V[i5][k + 2]) * r;
                    }
                    double[] dArray = this.V[i5];
                    int n14 = k;
                    dArray[n14] = dArray[n14] - p;
                    double[] dArray5 = this.V[i5];
                    int n15 = k + 1;
                    dArray5[n15] = dArray5[n15] - p * q;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.H[n][n] = 1.0;
                for (i2 = n - 1; i2 >= 0; --i2) {
                    int j4;
                    w = this.H[i2][i2] - p;
                    r = 0.0;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += this.H[i2][j4] * this.H[j4][n];
                    }
                    if (this.e[i2] < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i2;
                    if (this.e[i2] == 0.0) {
                        this.H[i2][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                    } else {
                        x = this.H[i2][i2 + 1];
                        y = this.H[i2 + 1][i2];
                        q = (this.d[i2] - p) * (this.d[i2] - p) + this.e[i2] * this.e[i2];
                        this.H[i2][n] = t = (x * s - z * r) / q;
                        this.H[i2 + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = Math.abs(this.H[i2][n]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i2; j4 <= n; ++j4) {
                        double[] dArray = this.H[j4];
                        int n16 = n;
                        dArray[n16] = dArray[n16] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(this.H[n][n - 1]) > Math.abs(this.H[n - 1][n])) {
                this.H[n - 1][n - 1] = q / this.H[n][n - 1];
                this.H[n - 1][n] = -(this.H[n][n] - p) / this.H[n][n - 1];
            } else {
                this.cdiv(0.0, -this.H[n - 1][n], this.H[n - 1][n - 1] - p, q);
                this.H[n - 1][n - 1] = this.cdivr;
                this.H[n - 1][n] = this.cdivi;
            }
            this.H[n][n - 1] = 0.0;
            this.H[n][n] = 1.0;
            for (i2 = n - 2; i2 >= 0; --i2) {
                int j5;
                double ra = 0.0;
                double sa = 0.0;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += this.H[i2][j5] * this.H[j5][n - 1];
                    sa += this.H[i2][j5] * this.H[j5][n];
                }
                w = this.H[i2][i2] - p;
                if (this.e[i2] < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i2;
                if (this.e[i2] == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    this.H[i2][n - 1] = this.cdivr;
                    this.H[i2][n] = this.cdivi;
                } else {
                    double vi;
                    x = this.H[i2][i2 + 1];
                    y = this.H[i2 + 1][i2];
                    double vr = (this.d[i2] - p) * (this.d[i2] - p) + this.e[i2] * this.e[i2] - q * q;
                    if (vr == 0.0 & (vi = (this.d[i2] - p) * 2.0 * q) == 0.0) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    this.H[i2][n - 1] = this.cdivr;
                    this.H[i2][n] = this.cdivi;
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        this.H[i2 + 1][n - 1] = (-ra - w * this.H[i2][n - 1] + q * this.H[i2][n]) / x;
                        this.H[i2 + 1][n] = (-sa - w * this.H[i2][n] - q * this.H[i2][n - 1]) / x;
                    } else {
                        this.cdiv(-r - y * this.H[i2][n - 1], -s - y * this.H[i2][n], z, q);
                        this.H[i2 + 1][n - 1] = this.cdivr;
                        this.H[i2 + 1][n] = this.cdivi;
                    }
                }
                t = Math.max(Math.abs(this.H[i2][n - 1]), Math.abs(this.H[i2][n]));
                if (!(eps * t * t > 1.0)) continue;
                for (j5 = i2; j5 <= n; ++j5) {
                    double[] dArray = this.H[j5];
                    int n17 = n - 1;
                    dArray[n17] = dArray[n17] / t;
                    double[] dArray6 = this.H[j5];
                    int n18 = n;
                    dArray6[n18] = dArray6[n18] / t;
                }
            }
        }
        for (int i6 = 0; i6 < nn; ++i6) {
            if (!(i6 < low | i6 > high)) continue;
            System.arraycopy(this.H[i6], i6, this.V[i6], i6, nn - i6);
        }
        for (j = nn - 1; j >= low; --j) {
            for (i2 = low; i2 <= high; ++i2) {
                z = 0.0;
                for (int k = low; k <= Math.min(j, high); ++k) {
                    z += this.V[i2][k] * this.H[k][j];
                }
                this.V[i2][j] = z;
            }
        }
    }

    public Matrix getV() {
        return new Matrix(this.V);
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] D = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j = 0; j < this.n; ++j) {
                D[i2][j] = 0.0;
            }
            D[i2][i2] = this.d[i2];
            if (this.e[i2] > 0.0) {
                D[i2][i2 + 1] = this.e[i2];
                continue;
            }
            if (!(this.e[i2] < 0.0)) continue;
            D[i2][i2 - 1] = this.e[i2];
        }
        return X;
    }
}

