/*
 * Decompiled with CFR 0.152.
 */
package mathematics.matriciel;

import Jama.Matrix;

public class Cholesky {
    private double[][] L;
    private int n;
    private boolean isspd;

    public Cholesky(Matrix Arg) {
        double[][] A = (double[][])Arg.getArray().clone();
        this.n = Arg.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = Arg.getColumnDimension() == this.n;
        for (int j = 0; j < this.n; ++j) {
            int k;
            double[] Lrowj = this.L[j];
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double[] Lrowk = this.L[k];
                double s = 0.0;
                for (int i2 = 0; i2 < k; ++i2) {
                    s += Lrowk[i2] * Lrowj[i2];
                }
                Lrowj[k] = s = (A[j][k] - s) / this.L[k][k];
                d += s * s;
                this.isspd &= A[k][j] == A[j][k];
            }
            this.isspd &= (d = A[j][j] - d) > 0.0;
            this.L[j][j] = Math.sqrt(Math.max(d, 0.0));
            for (k = j + 1; k < this.n; ++k) {
                this.L[j][k] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return Matrix.constructWithCopy((double[][])this.L);
    }

    public Matrix solve(Matrix B) {
        int j;
        int i2;
        int k;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] X = (double[][])B.getArray().clone();
        int nx = B.getColumnDimension();
        for (k = 0; k < this.n; ++k) {
            for (i2 = k + 1; i2 < this.n; ++i2) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.L[i2][k];
                }
            }
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
            for (i2 = 0; i2 < k; ++i2) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i2];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.L[k][i2];
                }
            }
        }
        return new Matrix(X);
    }
}

