/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import java.util.Arrays;
import mathematics.functions.Function;

public class Sum
implements Function {
    protected double[] CoefficientsDouble = null;
    protected float[] CoefficientsFloat = null;

    public Sum(int dimension, double[] useless) {
        this.CoefficientsDouble = new double[dimension];
        Arrays.fill(this.CoefficientsDouble, 1.0);
    }

    public Sum(double[] Coefficients) {
        this.CoefficientsDouble = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    public Sum(int dimension, float[] useless) {
        this.CoefficientsFloat = new float[dimension];
        Arrays.fill(this.CoefficientsFloat, 1.0f);
    }

    public Sum(float[] Coefficients) {
        this.CoefficientsFloat = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    @Override
    public double ComputeSafer(double[] variables) {
        if (this.CoefficientsDouble == null) {
            throw new IllegalArgumentException("The function is defined using Float, not Double.");
        }
        if (variables.length != this.CoefficientsDouble.length) {
            throw new IllegalArgumentException("parameters.length != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public double Compute(double[] variables) {
        double sum = 0.0;
        for (int i2 = 0; i2 < variables.length; ++i2) {
            sum += this.CoefficientsDouble[i2] * variables[i2];
        }
        return sum;
    }

    @Override
    public float ComputeSafer(float[] variables) {
        if (this.CoefficientsFloat == null) {
            throw new IllegalArgumentException("The function is defined using Double, not Float.");
        }
        if (variables.length != this.CoefficientsFloat.length) {
            throw new IllegalArgumentException("parameters.length != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public float Compute(float[] variables) {
        float sum = 0.0f;
        for (int i2 = 0; i2 < variables.length; ++i2) {
            sum += this.CoefficientsFloat[i2] * variables[i2];
        }
        return sum;
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsDouble, 0, Coefficients.length);
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsFloat, 0, Coefficients.length);
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return this.CoefficientsDouble;
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return this.CoefficientsFloat;
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        return this.CoefficientsDouble[num];
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        return this.CoefficientsFloat[num];
    }

    @Override
    public void Coefficient(int num, double value) {
        this.CoefficientsDouble[num] = value;
    }

    @Override
    public void Coefficient(int num, float value) {
        this.CoefficientsFloat[num] = value;
    }

    @Override
    public int Dimension() {
        return this.CoefficientsFloat != null ? this.CoefficientsFloat.length : this.CoefficientsDouble.length;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        Sum s = null;
        s = this.CoefficientsDouble != null ? new Sum(this.CoefficientsDouble) : new Sum(this.CoefficientsFloat);
        return s;
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new Sum(coefficients);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new Sum(coefficients);
    }
}

