/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import arrayTiTi.ArrayFeatures;
import mathematics.functions.Function;
import mathematics.functions.SubSamplingFunction;

public class SubSamplingBinFunction
extends SubSamplingFunction {
    private double thresholdd = 0.5;
    private float thresholdf = 0.5f;
    private final ArrayFeatures AF = new ArrayFeatures();

    public SubSamplingBinFunction(double[] Coefficients) {
        super(Coefficients);
    }

    public SubSamplingBinFunction(double[] Coefficients, double threshold) {
        super(Coefficients);
        this.Threshold(threshold);
    }

    public SubSamplingBinFunction(float[] Coefficients) {
        super(Coefficients);
    }

    public SubSamplingBinFunction(float[] Coefficients, float threshold) {
        super(Coefficients);
        this.Threshold(threshold);
    }

    @Override
    public double Compute(double[] variables) {
        return this.CoefficientsDouble[0] * this.AF.Integral(variables) + this.CoefficientsDouble[1] < this.thresholdd ? 0.0 : 1.0;
    }

    @Override
    public float Compute(float[] variables) {
        return this.CoefficientsFloat[0] * (float)this.AF.Integral(variables) + this.CoefficientsFloat[1] < this.thresholdf ? 0.0f : 1.0f;
    }

    public void Threshold(double threshold) {
        this.thresholdd = threshold;
        this.thresholdf = (float)threshold;
    }

    public void Threshold(float threshold) {
        this.thresholdf = threshold;
        this.thresholdd = threshold;
    }

    public double getThresholdDouble() {
        return this.thresholdd;
    }

    public float getThresholdFloat() {
        return this.thresholdf;
    }

    @Override
    public Function Clone() {
        SubSamplingBinFunction ssf = null;
        ssf = this.CoefficientsDouble != null ? new SubSamplingBinFunction(this.CoefficientsDouble, this.thresholdd) : new SubSamplingBinFunction(this.CoefficientsFloat, this.thresholdf);
        return ssf;
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new SubSamplingBinFunction((double[])null);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new SubSamplingBinFunction(null);
    }
}

