/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.Function;
import mathematics.functions.Function1D;
import mathematics.functions.Sigmoid;

public class SigmoidDerivative
implements Function1D {
    protected double lambda;

    public SigmoidDerivative(double lambda) {
        this.lambda = lambda;
    }

    public SigmoidDerivative(Sigmoid sigmoid) {
        this.lambda = sigmoid.getCoefficients((double[])null)[0];
    }

    @Override
    public double ComputeSafer(double[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double X) {
        double e = Math.exp(-this.lambda * X);
        return this.lambda * e / ((1.0 + e) * (1.0 + e));
    }

    @Override
    public float ComputeSafer(float[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float X) {
        double e = Math.exp(-this.lambda * (double)X);
        return (float)(this.lambda * e / ((1.0 + e) * (1.0 + e)));
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        this.lambda = Coefficients[0];
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        this.lambda = Coefficients[0];
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return new double[]{this.lambda};
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return new float[]{(float)this.lambda};
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        if (num == 0) {
            return this.lambda;
        }
        throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        if (num == 0) {
            return (float)this.lambda;
        }
        throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
    }

    @Override
    public void Coefficient(int num, double value) {
        if (num != 0) {
            throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
        }
        this.lambda = value;
    }

    @Override
    public void Coefficient(int num, float value) {
        if (num != 0) {
            throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
        }
        this.lambda = value;
    }

    @Override
    public int Dimension() {
        return 1;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        return new Sigmoid(this.lambda);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new SigmoidDerivative(1.0);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new SigmoidDerivative(1.0);
    }
}

