/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.BinaryFunction;
import mathematics.functions.Function;
import mathematics.functions.Sigmoid;

public class SigmoidBin
extends Sigmoid
implements BinaryFunction {
    private double thresholdd = 0.5;
    private float thresholdf = 0.5f;

    public SigmoidBin(double lambda) {
        super(lambda);
    }

    public SigmoidBin(double lambda, double threshold) {
        super(lambda);
        this.Threshold(threshold);
    }

    public SigmoidBin(double lambda, float threshold) {
        super(lambda);
        this.Threshold(threshold);
    }

    @Override
    public double Compute(double X) {
        double LX = -this.lambda * X;
        if (LX < -40.0) {
            return 1.0;
        }
        if (40.0 < LX) {
            return 0.0;
        }
        double v = 1.0 / (1.0 + Math.exp(LX));
        return v < this.thresholdd ? 0.0 : 1.0;
    }

    @Override
    public float Compute(float X) {
        double LX = -this.lambda * (double)X;
        if (LX < -40.0) {
            return 1.0f;
        }
        if (40.0 < LX) {
            return 0.0f;
        }
        float v = 1.0f / (1.0f + (float)Math.exp(-this.lambda * (double)X));
        return v < this.thresholdf ? 0.0f : 1.0f;
    }

    @Override
    public void Threshold(double threshold) {
        this.thresholdd = threshold;
        this.thresholdf = (float)threshold;
    }

    @Override
    public void Threshold(float threshold) {
        this.thresholdf = threshold;
        this.thresholdd = threshold;
    }

    @Override
    public double getThresholdDouble() {
        return this.thresholdd;
    }

    @Override
    public float getThresholdFloat() {
        return this.thresholdf;
    }

    @Override
    public Function Clone() {
        return new SigmoidBin(this.lambda, this.thresholdd);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new SigmoidBin(1.0);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new SigmoidBin(1.0);
    }
}

