/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.BinaryFunction;
import mathematics.functions.Function;
import mathematics.functions.Sigmoid1;

public class Sigmoid1Bin
extends Sigmoid1
implements BinaryFunction {
    private double thresholdd = 0.5;
    private float thresholdf = 0.5f;

    public Sigmoid1Bin(double threshold) {
        this.Threshold(threshold);
    }

    public Sigmoid1Bin(float threshold) {
        this.Threshold(threshold);
    }

    @Override
    public double Compute(double X) {
        if (X < -40.0) {
            return 1.0;
        }
        if (40.0 < X) {
            return 0.0;
        }
        double v = 1.0 / (1.0 + Math.exp(X));
        return v < this.thresholdd ? 0.0 : 1.0;
    }

    @Override
    public float Compute(float X) {
        if ((double)X < -40.0) {
            return 1.0f;
        }
        if (40.0 < (double)X) {
            return 0.0f;
        }
        float v = 1.0f / (1.0f + (float)Math.exp(-((double)X)));
        return v < this.thresholdf ? 0.0f : 1.0f;
    }

    @Override
    public void Threshold(double threshold) {
        this.thresholdd = threshold;
        this.thresholdf = (float)threshold;
    }

    @Override
    public void Threshold(float threshold) {
        this.thresholdf = threshold;
        this.thresholdd = threshold;
    }

    @Override
    public double getThresholdDouble() {
        return this.thresholdd;
    }

    @Override
    public float getThresholdFloat() {
        return this.thresholdf;
    }

    @Override
    public Function Clone() {
        return new Sigmoid1Bin(this.thresholdd);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new Sigmoid1Bin(0.5);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new Sigmoid1Bin(0.5f);
    }
}

