/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.Differentiable;
import mathematics.functions.Function;
import mathematics.functions.Function1D;
import mathematics.functions.SigmoidDerivative;

public class Sigmoid
implements Differentiable {
    protected double lambda;
    protected Function1D derivative = null;

    public Sigmoid(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double ComputeSafer(double[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double X) {
        double LX = -this.lambda * X;
        if (35.0 < LX) {
            return 0.9999999999999998;
        }
        if (LX < -700.0) {
            return 1.216780750623423E-308;
        }
        return 1.0 / (1.0 + Math.exp(LX));
    }

    @Override
    public float ComputeSafer(float[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float X) {
        double LX = -this.lambda * (double)X;
        if (17.0 < LX) {
            return 0.99999994f;
        }
        if (LX < -100.0) {
            return Float.MIN_VALUE;
        }
        return (float)(1.0 / (1.0 + Math.exp(LX)));
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        this.lambda = Coefficients[0];
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        this.lambda = Coefficients[0];
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return new double[]{this.lambda};
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return new float[]{(float)this.lambda};
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        if (num == 0) {
            return this.lambda;
        }
        throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        if (num == 0) {
            return (float)this.lambda;
        }
        throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
    }

    @Override
    public void Coefficient(int num, double value) {
        if (num != 0) {
            throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
        }
        this.lambda = value;
    }

    @Override
    public void Coefficient(int num, float value) {
        if (num != 0) {
            throw new IllegalArgumentException("Only one coefficient, so the number must be 0.");
        }
        this.lambda = value;
    }

    @Override
    public int Dimension() {
        return 1;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        return new Sigmoid(this.lambda);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new Sigmoid(1.0);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new Sigmoid(1.0);
    }

    @Override
    public Function1D Derivative() {
        if (this.derivative == null) {
            this.derivative = new SigmoidDerivative(this.lambda);
        }
        return this.derivative;
    }
}

