/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class Polynomial
implements Function1D {
    protected double[] CoefficientsDouble;
    protected double[] RootsDouble;
    protected float[] CoefficientsFloat;
    protected float[] RootsFloat;
    protected int Degree;
    protected int nbRoots;

    public Polynomial(int Degree, double[] useless) {
        if (Degree < 0) {
            throw new IllegalArgumentException("Bad value of degree: " + Degree + ", (wished >= 0).");
        }
        this.Degree = Degree;
        this.CoefficientsDouble = new double[Degree + 1];
        this.RootsDouble = new double[Degree + 1];
    }

    public Polynomial(double[] Coefficients) {
        this(Coefficients.length - 1, (double[])null);
        System.arraycopy(Coefficients, 0, this.CoefficientsDouble, 0, Coefficients.length);
    }

    public Polynomial(int Degree, float[] useless) {
        if (Degree < 0) {
            throw new IllegalArgumentException("Bad value of degree: " + Degree + ", (wished >= 0).");
        }
        this.Degree = Degree;
        this.CoefficientsFloat = new float[Degree + 1];
        this.RootsFloat = new float[Degree + 1];
    }

    public Polynomial(float[] Coefficients) {
        this(Coefficients.length - 1, (float[])null);
        System.arraycopy(Coefficients, 0, this.CoefficientsFloat, 0, Coefficients.length);
    }

    @Override
    public double ComputeSafer(double[] variables) {
        if (this.CoefficientsDouble == null) {
            throw new IllegalArgumentException("The function is defined using Float, not Double.");
        }
        if (variables.length != 1) {
            throw new IllegalArgumentException("Variable number different of 1.");
        }
        return this.Compute(variables);
    }

    @Override
    public double Compute(double[] variables) {
        return this.Compute(variables[0]);
    }

    @Override
    public double Compute(double X) {
        double value = this.CoefficientsDouble[this.Degree];
        for (int i2 = this.Degree - 1; i2 >= 0; --i2) {
            value = X * value + this.CoefficientsDouble[i2];
        }
        return value;
    }

    @Override
    public float ComputeSafer(float[] variables) {
        if (this.CoefficientsFloat == null) {
            throw new IllegalArgumentException("The function is defined using Double, not Float.");
        }
        if (variables.length != 1) {
            throw new IllegalArgumentException("Variable number different of 1.");
        }
        return this.Compute(variables);
    }

    @Override
    public float Compute(float[] variables) {
        return this.Compute(variables[0]);
    }

    @Override
    public float Compute(float X) {
        float value = this.CoefficientsFloat[this.Degree];
        for (int i2 = this.Degree - 1; i2 >= 0; --i2) {
            value = X * value + this.CoefficientsFloat[i2];
        }
        return value;
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsDouble, 0, Coefficients.length);
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsFloat, 0, Coefficients.length);
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return this.CoefficientsDouble;
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return this.CoefficientsFloat;
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        return this.CoefficientsDouble[num];
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        return this.CoefficientsFloat[num];
    }

    @Override
    public void Coefficient(int num, double value) {
        this.CoefficientsDouble[num] = value;
    }

    @Override
    public void Coefficient(int num, float value) {
        this.CoefficientsFloat[num] = value;
    }

    @Override
    public int Dimension() {
        return this.CoefficientsFloat != null ? this.CoefficientsFloat.length : this.CoefficientsDouble.length;
    }

    public int getDegree() {
        return this.Degree;
    }

    @Override
    public boolean hasConstant() {
        return true;
    }

    public int getNbRoots() {
        return this.nbRoots;
    }

    public void setNbRoots(int nbRoots) {
        this.nbRoots = nbRoots;
    }

    public double[] getRoots(double[] useless) {
        return this.RootsDouble;
    }

    public float[] getRoots(float[] useless) {
        return this.RootsFloat;
    }

    @Override
    public Polynomial Clone() {
        Polynomial p = null;
        p = this.CoefficientsDouble != null ? new Polynomial(this.CoefficientsDouble) : new Polynomial(this.CoefficientsFloat);
        return p;
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new Polynomial(coefficients);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new Polynomial(coefficients);
    }
}

