/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import java.util.Arrays;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class LinearFunction
implements Function1D {
    protected double[] CoefficientsDouble = null;
    protected float[] CoefficientsFloat = null;

    public LinearFunction(int dimension, double[] useless) {
        this.CoefficientsDouble = new double[dimension];
        Arrays.fill(this.CoefficientsDouble, 1.0);
        this.CoefficientsDouble[dimension - 1] = 0.0;
    }

    public LinearFunction(double[] Coefficients) {
        this.CoefficientsDouble = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    public LinearFunction(int dimension, float[] useless) {
        this.CoefficientsFloat = new float[dimension];
        Arrays.fill(this.CoefficientsFloat, 1.0f);
        this.CoefficientsFloat[dimension - 1] = 0.0f;
    }

    public LinearFunction(float[] Coefficients) {
        this.CoefficientsFloat = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    @Override
    public double ComputeSafer(double[] variables) {
        if (this.CoefficientsDouble == null) {
            throw new IllegalArgumentException("The function is defined using Float, not Double.");
        }
        if (variables.length + 1 != this.CoefficientsDouble.length) {
            throw new IllegalArgumentException("variables.length+1 != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public double Compute(double[] variables) {
        int i2;
        double sum = 0.0;
        for (i2 = 0; i2 < variables.length; ++i2) {
            sum += this.CoefficientsDouble[i2] * variables[i2];
        }
        return sum += this.CoefficientsDouble[i2];
    }

    @Override
    public double Compute(double X) {
        return this.CoefficientsDouble[0] * X + this.CoefficientsDouble[1];
    }

    @Override
    public float ComputeSafer(float[] variables) {
        if (this.CoefficientsFloat == null) {
            throw new IllegalArgumentException("The function is defined using Double, not Float.");
        }
        if (variables.length + 1 != this.CoefficientsFloat.length) {
            throw new IllegalArgumentException("variables.length+1 != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public float Compute(float[] variables) {
        int i2;
        float sum = 0.0f;
        for (i2 = 0; i2 < variables.length; ++i2) {
            sum += this.CoefficientsFloat[i2] * variables[i2];
        }
        return sum += this.CoefficientsFloat[i2];
    }

    @Override
    public float Compute(float X) {
        return this.CoefficientsFloat[0] * X + this.CoefficientsFloat[1];
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsDouble, 0, Coefficients.length);
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsFloat, 0, Coefficients.length);
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return this.CoefficientsDouble;
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return this.CoefficientsFloat;
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        return this.CoefficientsDouble[num];
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        return this.CoefficientsFloat[num];
    }

    @Override
    public void Coefficient(int num, double value) {
        this.CoefficientsDouble[num] = value;
    }

    @Override
    public void Coefficient(int num, float value) {
        this.CoefficientsFloat[num] = value;
    }

    @Override
    public int Dimension() {
        return this.CoefficientsFloat != null ? this.CoefficientsFloat.length : this.CoefficientsDouble.length;
    }

    @Override
    public boolean hasConstant() {
        return true;
    }

    @Override
    public Function Clone() {
        LinearFunction f = null;
        f = this.CoefficientsDouble != null ? new LinearFunction(this.CoefficientsDouble) : new LinearFunction(this.CoefficientsFloat);
        return f;
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new LinearFunction(coefficients);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new LinearFunction(coefficients);
    }
}

