/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.Function;
import mathematics.functions.Function1D;
import mathematics.functions.HyperbolicTangent;
import org.jdom2.Element;

public class HyperbolicTangentDerivative
implements Function1D {
    protected double alpha;
    protected double lambda;

    public HyperbolicTangentDerivative(double alpha, double lambda) {
        this.alpha = alpha;
        this.lambda = lambda;
    }

    public HyperbolicTangentDerivative(HyperbolicTangent ht) {
        double[] coef = ht.getCoefficients((double[])null);
        this.alpha = coef[0];
        this.lambda = coef[1];
    }

    @Override
    public double ComputeSafer(double[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double X) {
        double LX = this.lambda * X;
        if (10.0 < LX) {
            return 0.0;
        }
        if (LX < -10.0) {
            return 0.0;
        }
        double e = Math.exp(2.0 * LX);
        return this.alpha * this.lambda * (1.0 - (e - 1.0) / (e + 1.0));
    }

    @Override
    public float ComputeSafer(float[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float X) {
        double LX = this.lambda * (double)X;
        if (10.0 < LX) {
            return 0.0f;
        }
        if (LX < -10.0) {
            return 0.0f;
        }
        double e = Math.exp(2.0 * LX);
        return (float)(this.alpha * this.lambda * (1.0 - (e - 1.0) / (e + 1.0)));
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        this.alpha = Coefficients[0];
        this.lambda = Coefficients[1];
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        this.alpha = Coefficients[0];
        this.lambda = Coefficients[1];
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return new double[]{this.alpha, this.lambda};
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return new float[]{(float)this.alpha, (float)this.lambda};
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        switch (num) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.lambda;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,1].");
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        switch (num) {
            case 0: {
                return (float)this.alpha;
            }
            case 1: {
                return (float)this.lambda;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,1].");
    }

    @Override
    public void Coefficient(int num, double value) {
        switch (num) {
            case 0: {
                this.alpha = value;
                break;
            }
            case 1: {
                this.lambda = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Coefficient number must be into the range [0,1].");
            }
        }
    }

    @Override
    public void Coefficient(int num, float value) {
        switch (num) {
            case 0: {
                this.alpha = value;
                break;
            }
            case 1: {
                this.lambda = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Coefficient number must be into the range [0,1].");
            }
        }
    }

    @Override
    public int Dimension() {
        return 1;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        return new HyperbolicTangentDerivative(this.alpha, this.lambda);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new HyperbolicTangentDerivative(1.0, 1.0);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new HyperbolicTangentDerivative(1.0, 1.0);
    }

    public Element Xml() {
        Element f = new Element(this.getClass().getName());
        f.setAttribute("alpha", String.valueOf(this.alpha));
        f.setAttribute("lambda", String.valueOf(this.lambda));
        return f;
    }
}

