/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.BinaryFunction;
import mathematics.functions.Function;
import mathematics.functions.Function1D;
import mathematics.functions.HyperbolicTangent;

public class HyperbolicTangentBin
extends HyperbolicTangent
implements Function1D,
BinaryFunction {
    private double thresholdd = 0.5;
    private float thresholdf = 0.5f;

    public HyperbolicTangentBin(double alpha, double lambda) {
        super(alpha, lambda);
    }

    public HyperbolicTangentBin(double alpha, double lambda, double threshold) {
        super(alpha, lambda);
        this.Threshold(threshold);
    }

    public HyperbolicTangentBin(double alpha, double lambda, float threshold) {
        super(alpha, lambda);
        this.Threshold(threshold);
    }

    @Override
    public double Compute(double X) {
        double e = Math.exp(2.0 * this.lambda * X);
        return this.alpha * (e - 1.0) / (e + 1.0) < this.thresholdd ? 0.0 : 1.0;
    }

    @Override
    public float Compute(float X) {
        double e = Math.exp(2.0 * this.lambda * (double)X);
        return (float)(this.alpha * (e - 1.0) / (e + 1.0)) < this.thresholdf ? 0.0f : 1.0f;
    }

    @Override
    public void Threshold(double threshold) {
        this.thresholdd = threshold;
        this.thresholdf = (float)threshold;
    }

    @Override
    public void Threshold(float threshold) {
        this.thresholdf = threshold;
        this.thresholdd = threshold;
    }

    @Override
    public double getThresholdDouble() {
        return this.thresholdd;
    }

    @Override
    public float getThresholdFloat() {
        return this.thresholdf;
    }

    @Override
    public Function Clone() {
        return new HyperbolicTangentBin(this.lambda, this.thresholdd);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new HyperbolicTangentBin(1.0, 1.0);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new HyperbolicTangentBin(1.0, 1.0);
    }
}

