/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.Function;
import mathematics.functions.HyperbolicTangentDerivative;
import org.jdom2.Element;

public class HyperbolicTangent1Derivative
extends HyperbolicTangentDerivative {
    public HyperbolicTangent1Derivative() {
        super(1.0, 1.0);
    }

    @Override
    public double Compute(double X) {
        if (10.0 < X) {
            return 0.0;
        }
        if (X < -10.0) {
            return 0.0;
        }
        double e = Math.exp(2.0 * X);
        double ee = (e - 1.0) / (e + 1.0);
        return 1.0 - ee * ee;
    }

    @Override
    public float Compute(float X) {
        if (10.0 < (double)X) {
            return 0.0f;
        }
        if ((double)X < -10.0) {
            return 0.0f;
        }
        double e = Math.exp(2.0 * (double)X);
        double ee = (e - 1.0) / (e + 1.0);
        return (float)(1.0 - ee * ee);
    }

    @Override
    public Function Clone() {
        return new HyperbolicTangent1Derivative();
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new HyperbolicTangent1Derivative();
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new HyperbolicTangent1Derivative();
    }

    @Override
    public Element Xml() {
        return new Element(this.getClass().getName());
    }
}

