/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.BinaryFunction;
import mathematics.functions.Function;
import mathematics.functions.HyperbolicTangent1;

public class HyperbolicTangent1Bin
extends HyperbolicTangent1
implements BinaryFunction {
    private double thresholdd = 0.5;
    private float thresholdf = 0.5f;

    public HyperbolicTangent1Bin() {
    }

    public HyperbolicTangent1Bin(double lambda, double threshold) {
        this.Threshold(threshold);
    }

    public HyperbolicTangent1Bin(double lambda, float threshold) {
        this.Threshold(threshold);
    }

    @Override
    public double Compute(double X) {
        double e = Math.exp(2.0 * X);
        return (e - 1.0) / (e + 1.0) < this.thresholdd ? 0.0 : 1.0;
    }

    @Override
    public float Compute(float X) {
        double e = Math.exp(2.0 * (double)X);
        return (float)((e - 1.0) / (e + 1.0)) < this.thresholdf ? 0.0f : 1.0f;
    }

    @Override
    public void Threshold(double threshold) {
        this.thresholdd = threshold;
        this.thresholdf = (float)threshold;
    }

    @Override
    public void Threshold(float threshold) {
        this.thresholdf = threshold;
        this.thresholdd = threshold;
    }

    @Override
    public double getThresholdDouble() {
        return this.thresholdd;
    }

    @Override
    public float getThresholdFloat() {
        return this.thresholdf;
    }

    @Override
    public Function Clone() {
        return new HyperbolicTangent1Bin(this.lambda, this.thresholdd);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new HyperbolicTangent1Bin();
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new HyperbolicTangent1Bin();
    }
}

