/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import java.util.Arrays;

public class GaussianGenerator {
    public static double[] Generate1D(double center, double signal, double sigma, int length) {
        double[] gaussian = new double[length];
        GaussianGenerator.Generate1D(center, signal, sigma, gaussian);
        return gaussian;
    }

    public static void Generate1D(double center, double signal, double sigma, double[] gaussian) {
        if (sigma <= 0.0) {
            Arrays.fill(gaussian, 0.0);
            return;
        }
        double sigma2 = sigma * sigma;
        signal /= Math.PI * 2 * sigma2;
        for (int x = 0; x < gaussian.length; ++x) {
            double r = Math.abs((double)x - center);
            double arg = 0.5 * r * r / sigma2;
            gaussian[x] = signal * Math.exp(-arg);
        }
    }

    public static double[][] Generate1D(double center, double signal, double sigma, double step, int nbsamples) {
        double[][] gaussian = new double[nbsamples][2];
        GaussianGenerator.Generate1D(center, signal, sigma, step, gaussian);
        return gaussian;
    }

    public static void Generate1D(double center, double signal, double sigma, double step, double[][] gaussian) {
        double arg;
        double r;
        if (sigma <= 0.0) {
            Arrays.fill((Object[])gaussian, (Object)0.0);
            return;
        }
        int middle = gaussian.length >> 1;
        double sigma2 = sigma * sigma;
        signal /= Math.PI * 2 * sigma2;
        int pos = middle;
        double x = center;
        while (pos < gaussian.length) {
            r = Math.abs(x - center);
            arg = 0.5 * r * r / sigma2;
            gaussian[pos][0] = x;
            gaussian[pos][1] = signal * Math.exp(-arg) / (Math.PI * 2 * sigma2);
            ++pos;
            x += step;
        }
        pos = middle - 1;
        x = center - step;
        while (0 <= pos) {
            r = Math.abs(x - center);
            arg = 0.5 * r * r / sigma2;
            gaussian[pos][0] = x;
            gaussian[pos][1] = signal * Math.exp(-arg);
            --pos;
            x -= step;
        }
    }

    public static double[] Generate2D(double centerx, double centery, double signal, double sigma, double background, int width, int height) {
        double[] gaussian = new double[width * height];
        GaussianGenerator.Generate2D(centerx, centery, signal, sigma, background, gaussian, width, height);
        return gaussian;
    }

    public static void Generate2D(double centerx, double centery, double signal, double sigma, double background, double[] gaussian, int width, int height) {
        if (gaussian.length != width * height) {
            throw new IllegalArgumentException("gaussian.length != width*height");
        }
        if (sigma <= 0.0) {
            Arrays.fill(gaussian, 0.0);
            return;
        }
        double sigma2 = sigma * sigma;
        signal /= Math.PI * 2 * sigma2;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                double X = (double)x - centerx;
                double Y = (double)y - centery;
                double r = Math.sqrt(X * X + Y * Y);
                double arg = 0.5 * r * r / sigma2;
                gaussian[pos] = background + signal * Math.exp(-arg);
                ++x;
                ++pos;
            }
        }
    }
}

