/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.Function;

public class GaussianFunction
implements Function {
    private double center;
    private double signal;
    private double sigma2;

    public GaussianFunction(double center, double signal, double sigma) {
        this.center = center;
        this.sigma2 = sigma * sigma;
        this.signal = signal / (Math.PI * 2 * this.sigma2);
    }

    public GaussianFunction(double[] coefficients) {
        if (coefficients.length != 3) {
            throw new IllegalArgumentException("An array of length 3 is required.");
        }
        this.center = coefficients[0];
        this.sigma2 = coefficients[2] * coefficients[2];
        this.signal = coefficients[1] / (Math.PI * 2 * this.sigma2);
    }

    @Override
    public double ComputeSafer(double[] variables) {
        if (variables.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variables);
    }

    @Override
    public double Compute(double[] variables) {
        double r = Math.abs(variables[0] - this.center);
        double arg = 0.5 * r * r / this.sigma2;
        return this.signal * Math.exp(-arg);
    }

    @Override
    public float ComputeSafer(float[] variables) {
        if (variables.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variables);
    }

    @Override
    public float Compute(float[] variables) {
        double r = Math.abs((double)variables[0] - this.center);
        double arg = 0.5 * r * r / this.sigma2;
        return (float)(this.signal * Math.exp(-arg));
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        this.center = Coefficients[0];
        this.signal = Coefficients[1];
        this.sigma2 = Coefficients[2];
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        this.center = Coefficients[0];
        this.signal = Coefficients[1];
        this.sigma2 = Coefficients[2];
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return new double[]{this.center, this.signal, this.sigma2};
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return new float[]{(float)this.center, (float)this.signal, (float)this.sigma2};
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        switch (num) {
            case 0: {
                return this.center;
            }
            case 1: {
                return this.signal;
            }
            case 2: {
                return this.sigma2;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        switch (num) {
            case 0: {
                return (float)this.center;
            }
            case 1: {
                return (float)this.signal;
            }
            case 2: {
                return (float)this.sigma2;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
    }

    @Override
    public void Coefficient(int num, double value) {
        switch (num) {
            case 0: {
                this.center = value;
                break;
            }
            case 1: {
                this.signal = value;
                break;
            }
            case 2: {
                this.sigma2 = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
            }
        }
    }

    @Override
    public void Coefficient(int num, float value) {
        switch (num) {
            case 0: {
                this.center = value;
                break;
            }
            case 1: {
                this.signal = value;
                break;
            }
            case 2: {
                this.sigma2 = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
            }
        }
    }

    @Override
    public int Dimension() {
        return 1;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        return new GaussianFunction(this.center, this.signal, this.sigma2);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new GaussianFunction(coefficients);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new GaussianFunction(coefficients[0], coefficients[1], coefficients[2]);
    }
}

