/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.functions.Function;

public class Exponential
implements Function {
    private float alphaf;
    private float lambdaf;
    private float powerf;
    private double alphad;
    private double lambdad;
    private double powerd;

    public Exponential(float alpha, float lambda, float power) {
        this.alphad = alpha;
        this.lambdad = lambda;
        this.powerd = power;
        this.alphaf = alpha;
        this.lambdaf = lambda;
        this.powerf = power;
    }

    public Exponential(double alpha, double lambda, double power) {
        this.alphad = alpha;
        this.lambdad = lambda;
        this.powerd = power;
        this.alphaf = (float)alpha;
        this.lambdaf = (float)lambda;
        this.powerf = (float)power;
    }

    @Override
    public double ComputeSafer(double[] variables) {
        if (variables.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variables);
    }

    @Override
    public double Compute(double[] variables) {
        return this.alphad * Math.exp(-this.lambdad * Math.pow(variables[0], this.powerd));
    }

    @Override
    public float ComputeSafer(float[] variables) {
        if (variables.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variables);
    }

    @Override
    public float Compute(float[] variables) {
        return this.alphaf * (float)Math.exp((double)(-this.lambdaf) * Math.pow(variables[0], this.powerf));
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        this.alphad = Coefficients[0];
        this.lambdad = Coefficients[1];
        this.powerd = Coefficients[2];
        this.alphaf = (float)Coefficients[0];
        this.lambdaf = (float)Coefficients[1];
        this.powerf = (float)Coefficients[2];
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        this.alphad = Coefficients[0];
        this.lambdad = Coefficients[1];
        this.powerd = Coefficients[2];
        this.alphaf = Coefficients[0];
        this.lambdaf = Coefficients[1];
        this.powerf = Coefficients[2];
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return new double[]{this.alphad, this.lambdad, this.powerd};
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return new float[]{this.alphaf, this.lambdaf, this.powerf};
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        switch (num) {
            case 0: {
                return this.alphad;
            }
            case 1: {
                return this.lambdad;
            }
            case 2: {
                return this.powerd;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        switch (num) {
            case 0: {
                return this.alphaf;
            }
            case 1: {
                return this.lambdaf;
            }
            case 2: {
                return this.powerf;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
    }

    @Override
    public void Coefficient(int num, double value) {
        switch (num) {
            case 0: {
                this.alphad = value;
                break;
            }
            case 1: {
                this.lambdad = value;
                break;
            }
            case 2: {
                this.powerd = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
            }
        }
    }

    @Override
    public void Coefficient(int num, float value) {
        switch (num) {
            case 0: {
                this.alphaf = value;
                break;
            }
            case 1: {
                this.lambdaf = value;
                break;
            }
            case 2: {
                this.powerf = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Coefficient number must be into the range [0,2].");
            }
        }
    }

    @Override
    public int Dimension() {
        return 1;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        return new Exponential(this.alphad, this.lambdad, this.powerd);
    }

    @Override
    public Function Instance(double[] coefficients) {
        if (coefficients.length != 3) {
            throw new IllegalArgumentException("An array of length 3 is required.");
        }
        return new Exponential(coefficients[0], coefficients[1], coefficients[2]);
    }

    @Override
    public Function Instance(float[] coefficients) {
        if (coefficients.length != 3) {
            throw new IllegalArgumentException("An array of length 3 is required.");
        }
        return new Exponential(coefficients[0], coefficients[1], coefficients[2]);
    }
}

