/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import java.util.Arrays;
import mathematics.functions.Function;

public class EuclideanRadialBasis
implements Function {
    private double[] CoefficientsDouble = null;
    private float[] CoefficientsFloat = null;

    public EuclideanRadialBasis(int dimension, double[] useless) {
        this.CoefficientsDouble = new double[dimension];
        Arrays.fill(this.CoefficientsDouble, 0.0);
    }

    public EuclideanRadialBasis(double[] Coefficients) {
        this.CoefficientsDouble = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    public EuclideanRadialBasis(int dimension, float[] useless) {
        this.CoefficientsFloat = new float[dimension];
        Arrays.fill(this.CoefficientsFloat, 0.0f);
    }

    public EuclideanRadialBasis(float[] Coefficients) {
        this.CoefficientsFloat = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    @Override
    public double ComputeSafer(double[] variables) {
        if (this.CoefficientsDouble == null) {
            throw new IllegalArgumentException("The function is defined using Float, not Double.");
        }
        if (variables.length != this.CoefficientsDouble.length) {
            throw new IllegalArgumentException("parameters.length != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public double Compute(double[] variables) {
        double sum = 0.0;
        for (int i2 = 0; i2 < variables.length; ++i2) {
            double v = variables[i2] - this.CoefficientsDouble[i2];
            sum += v * v;
        }
        return sum / 2.0;
    }

    @Override
    public float ComputeSafer(float[] variables) {
        if (this.CoefficientsFloat == null) {
            throw new IllegalArgumentException("The function is defined using Double, not Float.");
        }
        if (variables.length != this.CoefficientsFloat.length) {
            throw new IllegalArgumentException("parameters.length != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public float Compute(float[] variables) {
        float sum = 0.0f;
        for (int i2 = 0; i2 < variables.length; ++i2) {
            float v = variables[i2] - this.CoefficientsFloat[i2];
            sum += v * v;
        }
        return sum / 2.0f;
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsDouble, 0, Coefficients.length);
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsFloat, 0, Coefficients.length);
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return this.CoefficientsDouble;
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return this.CoefficientsFloat;
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        return this.CoefficientsDouble[num];
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        return this.CoefficientsFloat[num];
    }

    @Override
    public void Coefficient(int num, double value) {
        this.CoefficientsDouble[num] = value;
    }

    @Override
    public void Coefficient(int num, float value) {
        this.CoefficientsFloat[num] = value;
    }

    @Override
    public int Dimension() {
        return this.CoefficientsFloat != null ? this.CoefficientsFloat.length : this.CoefficientsDouble.length;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        EuclideanRadialBasis ssf = null;
        ssf = this.CoefficientsDouble != null ? new EuclideanRadialBasis(this.CoefficientsDouble) : new EuclideanRadialBasis(this.CoefficientsFloat);
        return ssf;
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new EuclideanRadialBasis(coefficients);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new EuclideanRadialBasis(coefficients);
    }
}

