/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import arrayTiTi.ArrayFeatures;
import java.util.Arrays;
import mathematics.functions.Function;

public class Average
implements Function {
    protected double[] CoefficientsDouble = null;
    protected float[] CoefficientsFloat = null;
    protected float sumweightsfloat = 1.0f;
    protected double sumweightsdouble = 1.0;
    private final ArrayFeatures AF = new ArrayFeatures();

    public Average(int dimension, double[] useless) {
        this.CoefficientsDouble = new double[dimension];
        Arrays.fill(this.CoefficientsDouble, 1.0);
        this.sumweightsdouble = dimension;
    }

    public Average(double[] Coefficients) {
        this.CoefficientsDouble = Arrays.copyOf(Coefficients, Coefficients.length);
        this.sumweightsdouble = this.AF.Integral(Coefficients);
    }

    public Average(int dimension, float[] useless) {
        this.CoefficientsFloat = new float[dimension];
        Arrays.fill(this.CoefficientsFloat, 1.0f);
        this.sumweightsdouble = dimension;
    }

    public Average(float[] Coefficients) {
        this.CoefficientsFloat = Arrays.copyOf(Coefficients, Coefficients.length);
        this.sumweightsfloat = (float)this.AF.Integral(Coefficients);
    }

    @Override
    public double ComputeSafer(double[] variables) {
        if (this.CoefficientsDouble == null) {
            throw new IllegalArgumentException("The function is defined using Float, not Double.");
        }
        if (variables.length != this.CoefficientsDouble.length) {
            throw new IllegalArgumentException("parameters.length != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public double Compute(double[] variables) {
        double sum = 0.0;
        for (int i2 = 0; i2 < variables.length; ++i2) {
            sum += this.CoefficientsDouble[i2] * variables[i2];
        }
        return sum / this.sumweightsdouble;
    }

    @Override
    public float ComputeSafer(float[] variables) {
        if (this.CoefficientsFloat == null) {
            throw new IllegalArgumentException("The function is defined using Double, not Float.");
        }
        if (variables.length != this.CoefficientsFloat.length) {
            throw new IllegalArgumentException("parameters.length != Coefficients.length.");
        }
        return this.Compute(variables);
    }

    @Override
    public float Compute(float[] variables) {
        float sum = 0.0f;
        for (int i2 = 0; i2 < variables.length; ++i2) {
            sum += this.CoefficientsFloat[i2] * variables[i2];
        }
        return sum / this.sumweightsfloat;
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsDouble, 0, Coefficients.length);
        this.sumweightsdouble = this.AF.Integral(Coefficients);
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
        System.arraycopy(Coefficients, 0, this.CoefficientsFloat, 0, Coefficients.length);
        this.sumweightsfloat = (float)this.AF.Integral(Coefficients);
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return this.CoefficientsDouble;
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return this.CoefficientsFloat;
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        return this.CoefficientsDouble[num];
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        return this.CoefficientsFloat[num];
    }

    @Override
    public void Coefficient(int num, double value) {
        this.CoefficientsDouble[num] = value;
    }

    @Override
    public void Coefficient(int num, float value) {
        this.CoefficientsFloat[num] = value;
    }

    @Override
    public int Dimension() {
        return this.CoefficientsFloat != null ? this.CoefficientsFloat.length : this.CoefficientsDouble.length;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        Average a = null;
        a = this.CoefficientsDouble != null ? new Average(this.CoefficientsDouble) : new Average(this.CoefficientsFloat);
        return a;
    }

    @Override
    public Function Instance(double[] coefficients) {
        return new Average(coefficients);
    }

    @Override
    public Function Instance(float[] coefficients) {
        return new Average(coefficients);
    }
}

