/*
 * Decompiled with CFR 0.152.
 */
package mathematics.functions;

import mathematics.Maths;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class AbsConvex
implements Function1D {
    private final int power;
    private final int radius;
    private final double denominator;

    public AbsConvex(int power, int radius) {
        if (power < 1) {
            throw new IllegalArgumentException("power < 1");
        }
        if (radius < 1) {
            throw new IllegalArgumentException("radius < 1");
        }
        this.power = power;
        this.radius = radius;
        this.denominator = Maths.Power((int)radius, (int)power);
    }

    @Override
    public double ComputeSafer(double[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public double Compute(double X) {
        return -Maths.Power((double)Math.abs(X), (int)this.power) / this.denominator + 1.0;
    }

    @Override
    public float ComputeSafer(float[] variable) {
        if (variable.length != 1) {
            throw new IllegalArgumentException("1D function, so only 1 parameter required.");
        }
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float[] variable) {
        return this.Compute(variable[0]);
    }

    @Override
    public float Compute(float X) {
        return (float)this.Compute((double)X);
    }

    @Override
    public void setCoefficients(double[] Coefficients) {
    }

    @Override
    public void setCoefficients(float[] Coefficients) {
    }

    @Override
    public double[] getCoefficients(double[] useless) {
        return new double[]{this.power, this.radius};
    }

    @Override
    public float[] getCoefficients(float[] useless) {
        return new float[]{this.power, this.radius};
    }

    @Override
    public double Coefficient(int num, double[] useless) {
        switch (num) {
            case 0: {
                return this.power;
            }
            case 1: {
                return this.radius;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,1].");
    }

    @Override
    public float Coefficient(int num, float[] useless) {
        switch (num) {
            case 0: {
                return this.power;
            }
            case 1: {
                return this.radius;
            }
        }
        throw new IllegalArgumentException("Coefficient number must be into the range [0,1].");
    }

    @Override
    public void Coefficient(int num, double value) {
    }

    @Override
    public void Coefficient(int num, float value) {
    }

    @Override
    public int Dimension() {
        return 1;
    }

    @Override
    public boolean hasConstant() {
        return false;
    }

    @Override
    public Function Clone() {
        return new AbsConvex(this.power, this.radius);
    }

    @Override
    public Function Instance(double[] coefficients) {
        return this.Clone();
    }

    @Override
    public Function Instance(float[] coefficients) {
        return this.Clone();
    }
}

