/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fourier;

import arrayTiTi.ArrayNew;
import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import mathematics.Maths;
import mathematics.complex.Complex;
import mathematics.complex.ComplexTools;

public final class ToolsFFT {
    public static void Multiply(double[] object1, double[] object2, double[] result) {
        for (int pos = 0; pos < result.length; pos += 2) {
            double img_r = object1[pos];
            double img_i = object1[pos + 1];
            double mask_r = object2[pos];
            double mask_i = object2[pos + 1];
            result[pos] = img_r * mask_r - img_i * mask_i;
            result[pos + 1] = img_r * mask_i + img_i * mask_r;
        }
    }

    public static Complex[][] CreateFreeFFTBuffer(BufferedImage source, boolean square) {
        if (square) {
            int size = Maths.NextPower2((int)Math.max(source.getWidth(), source.getHeight()));
            return ToolsFFT.CreateFreeFFTBuffer(size, size);
        }
        return ToolsFFT.CreateFreeFFTBuffer(Maths.NextPower2((int)source.getWidth()), Maths.NextPower2((int)source.getHeight()));
    }

    public static Complex[][][] CreateFreeFFTBuffer(DV source, boolean square) {
        if (square) {
            int size = Maths.NextPower2((int)Math.max(Math.max(source.SizeX, source.SizeY), source.SizeZ));
            return ToolsFFT.CreateFreeFFTBuffer(size, size, size);
        }
        return ToolsFFT.CreateFreeFFTBuffer(Maths.NextPower2((int)source.SizeX), Maths.NextPower2((int)source.SizeY), Maths.NextPower2((int)source.SizeZ));
    }

    public static Complex[][] CreateFreeFFTBuffer(int width, int height) {
        if (!Maths.isPowerOf((int)width, (int)2)) {
            throw new IllegalArgumentException("Width is not dyadic.");
        }
        if (!Maths.isPowerOf((int)height, (int)2)) {
            throw new IllegalArgumentException("Height is not dyadic.");
        }
        Complex[][] data = new Complex[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[y][x] = new Complex();
            }
        }
        return data;
    }

    public static Complex[][][] CreateFreeFFTBuffer(int width, int height, int depth) {
        if (!Maths.isPowerOf((int)width, (int)2)) {
            throw new IllegalArgumentException("Width is not dyadic.");
        }
        if (!Maths.isPowerOf((int)height, (int)2)) {
            throw new IllegalArgumentException("Height is not dyadic.");
        }
        if (!Maths.isPowerOf((int)depth, (int)2)) {
            throw new IllegalArgumentException("Depth is not dyadic.");
        }
        Complex[][][] data = new Complex[depth][height][width];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    data[z][y][x] = new Complex();
                }
            }
        }
        return data;
    }

    public static Complex[][] BufferedImageToFreeFFTBuffer_And_Padding(BufferedImage source, double outframe, boolean square) {
        if (square) {
            int size = Maths.NextPower2((int)Math.max(source.getWidth(), source.getHeight()));
            return ToolsFFT.BufferedImageToFreeFFTBuffer_And_Padding(source, size, size, outframe);
        }
        return ToolsFFT.BufferedImageToFreeFFTBuffer_And_Padding(source, Maths.NextPower2((int)source.getWidth()), Maths.NextPower2((int)source.getHeight()), outframe);
    }

    public static Complex[][] BufferedImageToFreeFFTBuffer_And_Padding(BufferedImage source, int width, int height, double outframe) {
        Complex[][] data = new Complex[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[y][x] = new Complex();
            }
        }
        ToolsFFT.BufferedImageToFreeFFTBuffer_And_Padding(source, data, outframe);
        return data;
    }

    public static void BufferedImageToFreeFFTBuffer_And_Padding(BufferedImage source, Complex[][] Data, double outframe) {
        int height = source.getHeight();
        int width = source.getWidth();
        if (!Maths.isPowerOf((int)Data[0].length, (int)2) || width > Data[0].length) {
            throw new IllegalArgumentException("!Maths.isPowerOf(Data[0].length, 2) || width > Data[0].length.");
        }
        if (!Maths.isPowerOf((int)Data.length, (int)2) || height > Data.length) {
            throw new IllegalArgumentException("!Maths.isPowerOf(Data.length, 2) || height > Data[0].length.");
        }
        int dx = Data[0].length - width >> 1;
        int dy = Data.length - height >> 1;
        ComplexTools.Fill(Data, outframe, outframe);
        switch (source.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Data[y + dy][x + dx].Init(bb[pos] & 0xFF, outframe);
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        Data[y + dy][x + dx].Init(sb[pos] & 0xFFFF, outframe);
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                throw new IllegalArgumentException("Colored images not supported.");
            }
            default: {
                WritableRaster wr = source.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Data[y + dy][x + dx].Init(wr.getSampleDouble(x, y, 0), outframe);
                    }
                }
                wr = null;
            }
        }
    }

    public static void FreeFFTBufferToImage_And_UnPadding(Complex[][] Data, BufferedImage result) {
        int W = Data[0].length;
        int H = Data.length;
        int width = result.getWidth();
        int height = result.getHeight();
        if (width > Data[0].length) {
            throw new IllegalArgumentException("width > Data[0].length.");
        }
        if (height > Data.length) {
            throw new IllegalArgumentException("height > Data.length.");
        }
        int dx = W - width >> 1;
        int dy = H - height >> 1;
        switch (result.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        bb[pos] = (byte)(Data[y + dy][x + dx].re + 0.5);
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        sb[pos] = (short)(Data[y + dy][x + dx].re + 0.5);
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                throw new IllegalArgumentException("Colored images not supported.");
            }
            default: {
                WritableRaster wr = result.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wr.setSample(x, y, 0, (int)(Data[y + dy][x + dx].re + 0.5));
                    }
                }
                wr = null;
            }
        }
    }

    public static Complex[][][] DvToFreeFFTBuffer_And_Padding(DV source, double outframe, boolean square) {
        if (square) {
            int size = Maths.NextPower2((int)Math.max(Math.max(source.SizeX, source.SizeY), source.SizeZ));
            return ToolsFFT.DvToFreeFFTBuffer_And_Padding(source, size, size, size, outframe);
        }
        return ToolsFFT.DvToFreeFFTBuffer_And_Padding(source, Maths.NextPower2((int)source.SizeX), Maths.NextPower2((int)source.SizeY), Maths.NextPower2((int)source.SizeZ), outframe);
    }

    public static Complex[][][] DvToFreeFFTBuffer_And_Padding(DV source, int width, int height, int depth, double outframe) {
        Complex[][][] data = new Complex[depth][height][width];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    data[z][y][x] = new Complex();
                }
            }
        }
        ToolsFFT.DvToFreeFFTBuffer_And_Padding(source, data, outframe);
        return data;
    }

    public static void DvToFreeFFTBuffer_And_Padding(DV source, Complex[][][] Data, double outframe) {
        int depth = source.SizeZ;
        int height = source.SizeY;
        int width = source.SizeX;
        if (!Maths.isPowerOf((int)Data[0][0].length, (int)2) || width > Data[0][0].length) {
            throw new IllegalArgumentException("!Maths.isPowerOf(Data[0][0].length, 2) || width > Data[0][0].length.");
        }
        if (!Maths.isPowerOf((int)Data[0].length, (int)2) || height > Data[0].length) {
            throw new IllegalArgumentException("!Maths.isPowerOf(Data[0].length, 2) || height > Data[0].length.");
        }
        if (!Maths.isPowerOf((int)Data.length, (int)2) || depth > Data.length) {
            throw new IllegalArgumentException("!Maths.isPowerOf(Data.length, 2) || depth > Data.length.");
        }
        int dx = Data[0][0].length - width >> 1;
        int dy = Data[0].length - height >> 1;
        int dz = Data.length - depth >> 1;
        ComplexTools.Fill(Data, outframe, outframe);
        switch (source.Type) {
            case 8: {
                byte[] bb = source.getDataBufferByte(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            Data[z + dz][y + dy][x + dx].Init(bb[pos] & 0xFF, outframe);
                            ++x;
                            ++pos;
                        }
                    }
                }
                break;
            }
            case 11: {
                short[] sb = source.getDataBufferShort(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            Data[z + dz][y + dy][x + dx].Init(sb[pos] & 0xFFFF, outframe);
                            ++x;
                            ++pos;
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void FreeFFTBufferToDv_And_UnPadding(Complex[][][] Data, DV result) {
        int W = Data[0][0].length;
        int H = Data[0].length;
        int D = Data.length;
        int width = result.SizeX;
        int height = result.SizeY;
        int depth = result.SizeZ;
        if (width > Data[0][0].length) {
            throw new IllegalArgumentException("width > Data[0][0].length.");
        }
        if (height > Data[0].length) {
            throw new IllegalArgumentException("height > Data[0].length.");
        }
        if (depth > Data[0].length) {
            throw new IllegalArgumentException("depth > Data.length.");
        }
        int dx = W - width >> 1;
        int dy = H - height >> 1;
        int dz = D - depth >> 1;
        switch (result.Type) {
            case 10: {
                byte[] bb = result.getDataBufferByte(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            bb[pos] = (byte)(Data[z + dz][y + dy][x + dx].re + 0.5);
                            ++x;
                            ++pos;
                        }
                    }
                }
                break;
            }
            case 11: {
                short[] sb = result.getDataBufferShort(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            sb[pos] = (short)(Data[z + dz][y + dy][x + dx].re + 0.5);
                            ++x;
                            ++pos;
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static Complex[][] IntToFreeFFTBuffer_And_Padding(int[][] source, double outframe, boolean square) {
        int height;
        int width;
        if (square) {
            height = width = Maths.NextPower2((int)Math.max(source[0].length, source.length));
        } else {
            width = Maths.NextPower2((int)source[0].length);
            height = Maths.NextPower2((int)source.length);
        }
        Complex[][] data = new Complex[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[y][x] = new Complex();
            }
        }
        ToolsFFT.IntToFreeFFTBuffer_And_Padding(source, data, outframe);
        return data;
    }

    public static void IntToFreeFFTBuffer_And_Padding(int[][] source, Complex[][] Data, double outframe) {
        int height = source.length;
        int width = source[0].length;
        int H = Data.length;
        int W = Data[0].length;
        if (W < width || H < height) {
            throw new IllegalArgumentException("Data dimension < source dimension.");
        }
        if (!Maths.isPowerOf((int)Data[0].length, (int)2)) {
            throw new IllegalArgumentException("Data width is not dyadic.");
        }
        if (!Maths.isPowerOf((int)Data.length, (int)2)) {
            throw new IllegalArgumentException("Data height is not dyadic.");
        }
        int dx = W - width >> 1;
        int dy = H - height >> 1;
        ComplexTools.Fill(Data, outframe, outframe);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Data[y + dy][x + dx].Init(source[y][x]);
            }
        }
    }

    public static void FreeFFTBufferToInt_And_UnPadding(Complex[][] Data, int[][] result) {
        int W = Data[0].length;
        int H = Data.length;
        int width = result[0].length;
        int height = result.length;
        if (width > W) {
            throw new IllegalArgumentException("result[0].length > Data[0].length.");
        }
        if (height > H) {
            throw new IllegalArgumentException("result.length > Data.length.");
        }
        int dx = W - width >> 1;
        int dy = H - height >> 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = (int)(Data[y + dy][x + dx].re + 0.5);
            }
        }
    }

    public static Complex[][] DoubleToFreeFFTBuffer_And_Padding(double[][] source, double outframe, boolean square) {
        int height;
        int width;
        if (square) {
            height = width = Maths.NextPower2((int)Math.max(source[0].length, source.length));
        } else {
            width = Maths.NextPower2((int)source[0].length);
            height = Maths.NextPower2((int)source.length);
        }
        Complex[][] data = new Complex[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[y][x] = new Complex();
            }
        }
        ToolsFFT.DoubleToFreeFFTBuffer_And_Padding(source, data, outframe);
        return data;
    }

    public static void DoubleToFreeFFTBuffer_And_Padding(double[][] source, Complex[][] Data, double outframe) {
        int height = source.length;
        int width = source[0].length;
        int H = Data.length;
        int W = Data[0].length;
        if (W < width || H < height) {
            throw new IllegalArgumentException("Data dimension < source dimension.");
        }
        if (!Maths.isPowerOf((int)Data[0].length, (int)2)) {
            throw new IllegalArgumentException("Data width is not dyadic.");
        }
        if (!Maths.isPowerOf((int)Data.length, (int)2)) {
            throw new IllegalArgumentException("Data height is not dyadic.");
        }
        int dx = W - width + 1 >> 1;
        int dy = H - height + 1 >> 1;
        ComplexTools.Fill(Data, outframe, outframe);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Data[y + dy][x + dx].Init(source[y][x], outframe);
            }
        }
    }

    public static Complex[][][] DoubleToFreeFFTBuffer_And_Padding(double[][][] source, double outframe, boolean square) {
        int height;
        int width;
        int depth;
        if (square) {
            height = depth = (width = Maths.NextPower2((int)Math.max(Math.max(source[0].length, source.length), source[0][0].length)));
        } else {
            width = Maths.NextPower2((int)source[0][0].length);
            height = Maths.NextPower2((int)source[0].length);
            depth = Maths.NextPower2((int)source.length);
        }
        Complex[][][] data = new Complex[depth][height][width];
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    data[z][y][x] = new Complex();
                }
            }
        }
        ToolsFFT.DoubleToFreeFFTBuffer_And_Padding(source, data, outframe);
        return data;
    }

    public static void DoubleToFreeFFTBuffer_And_Padding(double[][][] source, Complex[][][] Data, double outframe) {
        int depth = source.length;
        int height = source[0].length;
        int width = source[0][0].length;
        int D = Data.length;
        int H = Data[0].length;
        int W = Data[0][0].length;
        if (W < width || H < height || D < depth) {
            throw new IllegalArgumentException("Data dimensions < source dimensions.");
        }
        if (!Maths.isPowerOf((int)Data[0][0].length, (int)2)) {
            throw new IllegalArgumentException("Data width is not dyadic.");
        }
        if (!Maths.isPowerOf((int)Data[0].length, (int)2)) {
            throw new IllegalArgumentException("Data height is not dyadic.");
        }
        if (!Maths.isPowerOf((int)Data.length, (int)2)) {
            throw new IllegalArgumentException("Data depth is not dyadic.");
        }
        int dx = W - width + 1 >> 1;
        int dy = H - height + 1 >> 1;
        int dz = D - depth + 1 >> 1;
        ComplexTools.Fill(Data, outframe, outframe);
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    Data[z + dz][y + dy][x + dx].Init(source[z][y][x], outframe);
                }
            }
        }
    }

    public static void FreeFFTBufferToDouble_And_UnPadding(Complex[][] Data, double[][] result) {
        int W = Data[0].length;
        int H = Data.length;
        int width = result[0].length;
        int height = result.length;
        if (width > W) {
            throw new IllegalArgumentException("result[0].length > Data[0].length.");
        }
        if (height > H) {
            throw new IllegalArgumentException("result.length > Data.length.");
        }
        int dx = W - width >> 1;
        int dy = H - height >> 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = Data[y + dy][x + dx].re;
            }
        }
    }

    public static void FreeFFTBufferToDouble_And_UnPadding(Complex[][][] Data, double[][][] result) {
        int W = Data[0][0].length;
        int H = Data[0].length;
        int D = Data.length;
        int width = result[0][0].length;
        int height = result[0].length;
        int depth = result.length;
        if (width > W) {
            throw new IllegalArgumentException("result[0][0].length > Data[0][0].length.");
        }
        if (height > H) {
            throw new IllegalArgumentException("result[0].length > Data[0].length.");
        }
        if (depth > D) {
            throw new IllegalArgumentException("result.length > Data.length.");
        }
        int dx = W - width >> 1;
        int dy = H - height >> 1;
        int dz = D - depth >> 1;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    result[z][y][x] = Data[z + dz][y + dy][x + dx].re;
                }
            }
        }
    }

    public static void Shift(Complex[][] Data) {
        int y;
        int width = Data[0].length;
        int height = Data.length;
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        Complex[] buffer = new Complex[width];
        if (mw == 0) {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2, buffer, 0, w2);
                System.arraycopy(Data[y], 0, Data[y], w2, w2);
                System.arraycopy(buffer, 0, Data[y], 0, w2);
            }
        } else {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2 - 1, buffer, 0, w2 + 1);
                System.arraycopy(Data[y], 0, Data[y], w2 + 1, w2 - 1);
                System.arraycopy(buffer, 0, Data[y], 0, w2 + 1);
            }
        }
        if (mh == 0) {
            y = h2;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(Data[y], 0, Data[y2], 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
        } else {
            Complex[] buffer2 = new Complex[width];
            System.arraycopy(Data[h2], 0, buffer2, 0, width);
            y = h2 + 1;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data[y2], 0, width);
                System.arraycopy(Data[y], 0, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
            System.arraycopy(buffer2, 0, Data[y2], 0, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(double[][] Data) {
        int y;
        int width = Data[0].length;
        int height = Data.length;
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        double[] buffer = new double[width];
        if (mw == 0) {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2, buffer, 0, w2);
                System.arraycopy(Data[y], 0, Data[y], w2, w2);
                System.arraycopy(buffer, 0, Data[y], 0, w2);
            }
        } else {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2 - 1, buffer, 0, w2 + 1);
                System.arraycopy(Data[y], 0, Data[y], w2 + 1, w2 - 1);
                System.arraycopy(buffer, 0, Data[y], 0, w2 + 1);
            }
        }
        if (mh == 0) {
            y = h2;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(Data[y], 0, Data[y2], 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
        } else {
            double[] buffer2 = new double[width];
            System.arraycopy(Data[h2], 0, buffer2, 0, width);
            y = h2 + 1;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data[y2], 0, width);
                System.arraycopy(Data[y], 0, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
            System.arraycopy(buffer2, 0, Data[y2], 0, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(float[][] Data) {
        int y;
        int width = Data[0].length;
        int height = Data.length;
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        float[] buffer = new float[width];
        if (mw == 0) {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2, buffer, 0, w2);
                System.arraycopy(Data[y], 0, Data[y], w2, w2);
                System.arraycopy(buffer, 0, Data[y], 0, w2);
            }
        } else {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2 - 1, buffer, 0, w2 + 1);
                System.arraycopy(Data[y], 0, Data[y], w2 + 1, w2 - 1);
                System.arraycopy(buffer, 0, Data[y], 0, w2 + 1);
            }
        }
        if (mh == 0) {
            y = h2;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(Data[y], 0, Data[y2], 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
        } else {
            float[] buffer2 = new float[width];
            System.arraycopy(Data[h2], 0, buffer2, 0, width);
            y = h2 + 1;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data[y2], 0, width);
                System.arraycopy(Data[y], 0, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
            System.arraycopy(buffer2, 0, Data[y2], 0, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(int[][] Data) {
        int y;
        int width = Data[0].length;
        int height = Data.length;
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        int[] buffer = new int[width];
        if (mw == 0) {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2, buffer, 0, w2);
                System.arraycopy(Data[y], 0, Data[y], w2, w2);
                System.arraycopy(buffer, 0, Data[y], 0, w2);
            }
        } else {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2 - 1, buffer, 0, w2 + 1);
                System.arraycopy(Data[y], 0, Data[y], w2 + 1, w2 - 1);
                System.arraycopy(buffer, 0, Data[y], 0, w2 + 1);
            }
        }
        if (mh == 0) {
            y = h2;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(Data[y], 0, Data[y2], 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
        } else {
            int[] buffer2 = new int[width];
            System.arraycopy(Data[h2], 0, buffer2, 0, width);
            y = h2 + 1;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data[y2], 0, width);
                System.arraycopy(Data[y], 0, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
            System.arraycopy(buffer2, 0, Data[y2], 0, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(byte[][] Data) {
        int y;
        int width = Data[0].length;
        int height = Data.length;
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        byte[] buffer = new byte[width];
        if (mw == 0) {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2, buffer, 0, w2);
                System.arraycopy(Data[y], 0, Data[y], w2, w2);
                System.arraycopy(buffer, 0, Data[y], 0, w2);
            }
        } else {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2 - 1, buffer, 0, w2 + 1);
                System.arraycopy(Data[y], 0, Data[y], w2 + 1, w2 - 1);
                System.arraycopy(buffer, 0, Data[y], 0, w2 + 1);
            }
        }
        if (mh == 0) {
            y = h2;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(Data[y], 0, Data[y2], 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
        } else {
            byte[] buffer2 = new byte[width];
            System.arraycopy(Data[h2], 0, buffer2, 0, width);
            y = h2 + 1;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data[y2], 0, width);
                System.arraycopy(Data[y], 0, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
            System.arraycopy(buffer2, 0, Data[y2], 0, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(short[][] Data) {
        int y;
        int width = Data[0].length;
        int height = Data.length;
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        short[] buffer = new short[width];
        if (mw == 0) {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2, buffer, 0, w2);
                System.arraycopy(Data[y], 0, Data[y], w2, w2);
                System.arraycopy(buffer, 0, Data[y], 0, w2);
            }
        } else {
            for (y = 0; y < height; ++y) {
                System.arraycopy(Data[y], w2 - 1, buffer, 0, w2 + 1);
                System.arraycopy(Data[y], 0, Data[y], w2 + 1, w2 - 1);
                System.arraycopy(buffer, 0, Data[y], 0, w2 + 1);
            }
        }
        if (mh == 0) {
            y = h2;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(Data[y], 0, Data[y2], 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
        } else {
            short[] buffer2 = new short[width];
            System.arraycopy(Data[h2], 0, buffer2, 0, width);
            y = h2 + 1;
            int y2 = 0;
            while (y < height) {
                System.arraycopy(Data[y2], 0, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data[y2], 0, width);
                System.arraycopy(Data[y], 0, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data[y], 0, width);
                ++y;
                ++y2;
            }
            System.arraycopy(buffer2, 0, Data[y2], 0, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(BufferedImage source) {
        switch (source.getType()) {
            case 10: {
                ToolsFFT.Shift(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                break;
            }
            case 11: {
                ToolsFFT.Shift(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), source.getWidth(), source.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("Only gray level images are supported.");
            }
        }
    }

    public static void Shift(double[] Data, int width, int height) {
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        double[] buffer = new double[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            y = h2;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(Data, pos, Data, pos2, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            double[] buffer2 = new double[width];
            System.arraycopy(Data, h2 * width, buffer2, 0, width);
            y = h2 + 1;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data, pos2, width);
                System.arraycopy(Data, pos, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
            System.arraycopy(buffer2, 0, Data, pos2, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(float[] Data, int width, int height) {
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        float[] buffer = new float[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            y = h2;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(Data, pos, Data, pos2, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            float[] buffer2 = new float[width];
            System.arraycopy(Data, h2 * width, buffer2, 0, width);
            y = h2 + 1;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data, pos2, width);
                System.arraycopy(Data, pos, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
            System.arraycopy(buffer2, 0, Data, pos2, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(int[] Data, int width, int height) {
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        int[] buffer = new int[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            y = h2;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(Data, pos, Data, pos2, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            int[] buffer2 = new int[width];
            System.arraycopy(Data, h2 * width, buffer2, 0, width);
            y = h2 + 1;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data, pos2, width);
                System.arraycopy(Data, pos, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
            System.arraycopy(buffer2, 0, Data, pos2, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(byte[] Data, int width, int height) {
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        byte[] buffer = new byte[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            y = h2;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(Data, pos, Data, pos2, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            byte[] buffer2 = new byte[width];
            System.arraycopy(Data, h2 * width, buffer2, 0, width);
            y = h2 + 1;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data, pos2, width);
                System.arraycopy(Data, pos, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
            System.arraycopy(buffer2, 0, Data, pos2, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(short[] Data, int width, int height) {
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        short[] buffer = new short[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            y = h2;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(Data, pos, Data, pos2, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            short[] buffer2 = new short[width];
            System.arraycopy(Data, h2 * width, buffer2, 0, width);
            y = h2 + 1;
            pos = y * width;
            pos2 = 0;
            while (y < height) {
                System.arraycopy(Data, pos2, buffer, 0, width);
                System.arraycopy(buffer2, 0, Data, pos2, width);
                System.arraycopy(Data, pos, buffer2, 0, width);
                System.arraycopy(buffer, 0, Data, pos, width);
                ++y;
                pos += width;
                pos2 += width;
            }
            System.arraycopy(buffer2, 0, Data, pos2, width);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(double[][][] Data) {
        int z;
        int d2 = Data.length >> 1;
        int md = Maths.ModuloDyadic((int)Data.length, (int)2);
        double[][] buffer = ArrayNew.Same((double[][])Data[0]);
        for (z = 0; z < Data.length; ++z) {
            ToolsFFT.Shift(Data[z]);
        }
        if (md == 0) {
            z = 0;
            int z2 = d2;
            while (z < d2) {
                ArrayNew.CopyRough((double[][])Data[z], (double[][])buffer);
                ArrayNew.CopyRough((double[][])Data[z2], (double[][])Data[z]);
                ArrayNew.CopyRough((double[][])buffer, (double[][])Data[z2]);
                ++z;
                ++z2;
            }
        } else {
            double[][] buffer2 = ArrayNew.Same((double[][])buffer);
            ArrayNew.CopyRough((double[][])Data[d2], (double[][])buffer2);
            z = d2 + 1;
            int z2 = 0;
            while (z < Data.length) {
                ArrayNew.CopyRough((double[][])Data[z2], (double[][])buffer);
                ArrayNew.CopyRough((double[][])buffer2, (double[][])Data[z2]);
                ArrayNew.CopyRough((double[][])Data[z], (double[][])buffer2);
                ArrayNew.CopyRough((double[][])buffer, (double[][])Data[z]);
                ++z;
                ++z2;
            }
            ArrayNew.CopyRough((double[][])buffer2, (double[][])Data[z2]);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(float[][][] Data) {
        int z;
        int d2 = Data.length >> 1;
        int md = Maths.ModuloDyadic((int)Data.length, (int)2);
        float[][] buffer = ArrayNew.Same((float[][])Data[0]);
        for (z = 0; z < Data.length; ++z) {
            ToolsFFT.Shift(Data[z]);
        }
        if (md == 0) {
            z = 0;
            int z2 = d2;
            while (z < d2) {
                ArrayNew.CopyRough((float[][])Data[z], (float[][])buffer);
                ArrayNew.CopyRough((float[][])Data[z2], (float[][])Data[z]);
                ArrayNew.CopyRough((float[][])buffer, (float[][])Data[z2]);
                ++z;
                ++z2;
            }
        } else {
            float[][] buffer2 = ArrayNew.Same((float[][])buffer);
            ArrayNew.CopyRough((float[][])Data[d2], (float[][])buffer2);
            z = d2 + 1;
            int z2 = 0;
            while (z < Data.length) {
                ArrayNew.CopyRough((float[][])Data[z2], (float[][])buffer);
                ArrayNew.CopyRough((float[][])buffer2, (float[][])Data[z2]);
                ArrayNew.CopyRough((float[][])Data[z], (float[][])buffer2);
                ArrayNew.CopyRough((float[][])buffer, (float[][])Data[z]);
                ++z;
                ++z2;
            }
            ArrayNew.CopyRough((float[][])buffer2, (float[][])Data[z2]);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(Complex[][][] Data) {
        throw new Error("Method not implemented (yet).");
    }

    public static void Shift(DV dv) {
        switch (dv.Type) {
            case 8: {
                ToolsFFT.Shift(dv.getDataBufferByte(0), dv.SizeX, dv.SizeY, dv.SizeZ);
                break;
            }
            case 16: {
                ToolsFFT.Shift(dv.getDataBufferShort(0), dv.SizeX, dv.SizeY, dv.SizeZ);
                break;
            }
            case 32: {
                ToolsFFT.Shift(dv.getDataBufferInt(0), dv.SizeX, dv.SizeY, dv.SizeZ);
                break;
            }
            case 64: {
                ToolsFFT.Shift(dv.getDataBufferDouble(0), dv.SizeX, dv.SizeY, dv.SizeZ);
                break;
            }
            case -32: {
                ToolsFFT.Shift(dv.getDataBufferFloat(0), dv.SizeX, dv.SizeY, dv.SizeZ);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public static void Shift(double[] Data, int width, int height, int depth) {
        double[] buffer2;
        int z;
        int pos3;
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height * depth) {
            throw new IllegalArgumentException("Data.length != width*height*depth");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int d2 = depth >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        int md = Maths.ModuloDyadic((int)depth, (int)2);
        int wh = width * height;
        int hd = height * depth;
        double[] buffer = new double[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            pos3 = 0;
            z = 0;
            while (z < depth) {
                y = h2;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(Data, pos, Data, pos2, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                ++z;
                pos3 += wh;
            }
        } else {
            buffer2 = new double[width];
            pos3 = 0;
            z = 0;
            while (z < depth) {
                System.arraycopy(Data, pos3 + h2 * width, buffer2, 0, width);
                y = h2 + 1;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(buffer2, 0, Data, pos2, width);
                    System.arraycopy(Data, pos, buffer2, 0, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                System.arraycopy(buffer2, 0, Data, pos2, width);
                ++z;
                pos3 += wh;
            }
            buffer2 = null;
        }
        buffer = null;
        buffer = new double[wh];
        if (md == 0) {
            z = d2;
            pos = d2 * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(Data, pos, Data, pos2, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
        } else {
            buffer2 = new double[wh];
            System.arraycopy(Data, d2 * wh, buffer2, 0, wh);
            z = d2 + 1;
            pos = z * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(buffer2, 0, Data, pos2, wh);
                System.arraycopy(Data, pos, buffer2, 0, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
            System.arraycopy(buffer2, 0, Data, pos2, wh);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(float[] Data, int width, int height, int depth) {
        float[] buffer2;
        int z;
        int pos3;
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height * depth) {
            throw new IllegalArgumentException("Data.length != width*height*depth");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int d2 = depth >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        int md = Maths.ModuloDyadic((int)depth, (int)2);
        int wh = width * height;
        int hd = height * depth;
        float[] buffer = new float[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            pos3 = 0;
            z = 0;
            while (z < depth) {
                y = h2;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(Data, pos, Data, pos2, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                ++z;
                pos3 += wh;
            }
        } else {
            buffer2 = new float[width];
            pos3 = 0;
            z = 0;
            while (z < depth) {
                System.arraycopy(Data, pos3 + h2 * width, buffer2, 0, width);
                y = h2 + 1;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(buffer2, 0, Data, pos2, width);
                    System.arraycopy(Data, pos, buffer2, 0, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                System.arraycopy(buffer2, 0, Data, pos2, width);
                ++z;
                pos3 += wh;
            }
            buffer2 = null;
        }
        buffer = null;
        buffer = new float[wh];
        if (md == 0) {
            z = d2;
            pos = d2 * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(Data, pos, Data, pos2, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
        } else {
            buffer2 = new float[wh];
            System.arraycopy(Data, d2 * wh, buffer2, 0, wh);
            z = d2 + 1;
            pos = z * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(buffer2, 0, Data, pos2, wh);
                System.arraycopy(Data, pos, buffer2, 0, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
            System.arraycopy(buffer2, 0, Data, pos2, wh);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(byte[] Data, int width, int height, int depth) {
        byte[] buffer2;
        int z;
        int pos3;
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height * depth) {
            throw new IllegalArgumentException("Data.length != width*height*depth");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int d2 = depth >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        int md = Maths.ModuloDyadic((int)depth, (int)2);
        int wh = width * height;
        int hd = height * depth;
        byte[] buffer = new byte[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            pos3 = 0;
            z = 0;
            while (z < depth) {
                y = h2;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(Data, pos, Data, pos2, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                ++z;
                pos3 += wh;
            }
        } else {
            buffer2 = new byte[width];
            pos3 = 0;
            z = 0;
            while (z < depth) {
                System.arraycopy(Data, pos3 + h2 * width, buffer2, 0, width);
                y = h2 + 1;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(buffer2, 0, Data, pos2, width);
                    System.arraycopy(Data, pos, buffer2, 0, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                System.arraycopy(buffer2, 0, Data, pos2, width);
                ++z;
                pos3 += wh;
            }
            buffer2 = null;
        }
        buffer = null;
        buffer = new byte[wh];
        if (md == 0) {
            z = d2;
            pos = d2 * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(Data, pos, Data, pos2, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
        } else {
            buffer2 = new byte[wh];
            System.arraycopy(Data, d2 * wh, buffer2, 0, wh);
            z = d2 + 1;
            pos = z * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(buffer2, 0, Data, pos2, wh);
                System.arraycopy(Data, pos, buffer2, 0, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
            System.arraycopy(buffer2, 0, Data, pos2, wh);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(short[] Data, int width, int height, int depth) {
        short[] buffer2;
        int z;
        int pos3;
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height * depth) {
            throw new IllegalArgumentException("Data.length != width*height*depth");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int d2 = depth >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        int md = Maths.ModuloDyadic((int)depth, (int)2);
        int wh = width * height;
        int hd = height * depth;
        short[] buffer = new short[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            pos3 = 0;
            z = 0;
            while (z < depth) {
                y = h2;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(Data, pos, Data, pos2, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                ++z;
                pos3 += wh;
            }
        } else {
            buffer2 = new short[width];
            pos3 = 0;
            z = 0;
            while (z < depth) {
                System.arraycopy(Data, pos3 + h2 * width, buffer2, 0, width);
                y = h2 + 1;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(buffer2, 0, Data, pos2, width);
                    System.arraycopy(Data, pos, buffer2, 0, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                System.arraycopy(buffer2, 0, Data, pos2, width);
                ++z;
                pos3 += wh;
            }
            buffer2 = null;
        }
        buffer = null;
        buffer = new short[wh];
        if (md == 0) {
            z = d2;
            pos = d2 * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(Data, pos, Data, pos2, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
        } else {
            buffer2 = new short[wh];
            System.arraycopy(Data, d2 * wh, buffer2, 0, wh);
            z = d2 + 1;
            pos = z * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(buffer2, 0, Data, pos2, wh);
                System.arraycopy(Data, pos, buffer2, 0, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
            System.arraycopy(buffer2, 0, Data, pos2, wh);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Shift(int[] Data, int width, int height, int depth) {
        int[] buffer2;
        int z;
        int pos3;
        int pos2;
        int y;
        int pos;
        if (Data.length != width * height * depth) {
            throw new IllegalArgumentException("Data.length != width*height*depth");
        }
        int w2 = width >> 1;
        int h2 = height >> 1;
        int d2 = depth >> 1;
        int mw = Maths.ModuloDyadic((int)w2, (int)2);
        int mh = Maths.ModuloDyadic((int)height, (int)2);
        int md = Maths.ModuloDyadic((int)depth, (int)2);
        int wh = width * height;
        int hd = height * depth;
        int[] buffer = new int[width];
        if (mw == 0) {
            pos = 0;
            y = 0;
            pos2 = w2;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2);
                System.arraycopy(Data, pos, Data, pos2, w2);
                System.arraycopy(buffer, 0, Data, pos, w2);
                ++y;
                pos += width;
                pos2 += width;
            }
        } else {
            pos = 0;
            y = 0;
            pos2 = w2 - 1;
            while (y < hd) {
                System.arraycopy(Data, pos2, buffer, 0, w2 + 1);
                System.arraycopy(Data, pos, Data, pos2 + 2, w2 - 1);
                System.arraycopy(buffer, 0, Data, pos, w2 + 1);
                ++y;
                pos += width;
                pos2 += width;
            }
        }
        if (mh == 0) {
            pos3 = 0;
            z = 0;
            while (z < depth) {
                y = h2;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(Data, pos, Data, pos2, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                ++z;
                pos3 += wh;
            }
        } else {
            buffer2 = new int[width];
            pos3 = 0;
            z = 0;
            while (z < depth) {
                System.arraycopy(Data, pos3 + h2 * width, buffer2, 0, width);
                y = h2 + 1;
                pos = pos3 + y * width;
                pos2 = pos3;
                while (y < height) {
                    System.arraycopy(Data, pos2, buffer, 0, width);
                    System.arraycopy(buffer2, 0, Data, pos2, width);
                    System.arraycopy(Data, pos, buffer2, 0, width);
                    System.arraycopy(buffer, 0, Data, pos, width);
                    ++y;
                    pos += width;
                    pos2 += width;
                }
                System.arraycopy(buffer2, 0, Data, pos2, width);
                ++z;
                pos3 += wh;
            }
            buffer2 = null;
        }
        buffer = null;
        buffer = new int[wh];
        if (md == 0) {
            z = d2;
            pos = d2 * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(Data, pos, Data, pos2, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
        } else {
            buffer2 = new int[wh];
            System.arraycopy(Data, d2 * wh, buffer2, 0, wh);
            z = d2 + 1;
            pos = z * wh;
            pos2 = 0;
            while (z < depth) {
                System.arraycopy(Data, pos2, buffer, 0, wh);
                System.arraycopy(buffer2, 0, Data, pos2, wh);
                System.arraycopy(Data, pos, buffer2, 0, wh);
                System.arraycopy(buffer, 0, Data, pos, wh);
                ++z;
                pos += wh;
                pos2 += wh;
            }
            System.arraycopy(buffer2, 0, Data, pos2, wh);
            buffer2 = null;
        }
        buffer = null;
    }

    public static void Normalisation(Complex[][] Data, BufferedImage imout) {
        int x;
        int y;
        double Max;
        int width = Data[0].length;
        int height = Data.length;
        double Min = Max = Data[0][0].re;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (Data[y][x].re > Max) {
                    Max = Data[y][x].re;
                }
                if (!(Data[y][x].re < Min)) continue;
                Min = Data[y][x].re;
            }
        }
        switch (imout.getType()) {
            case 10: {
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        Data[y][x].Init((Data[y][x].re - Min) / (Max - Min) * 255.0, 0.0);
                    }
                }
                break;
            }
            case 11: {
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        Data[y][x].Init((Data[y][x].re - Min) / (Max - Min) * 65535.0, 0.0);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported. Gray level required.");
            }
        }
    }

    public static void Normalized(BufferedImage bufferIn, BufferedImage bufferOut) {
        int x;
        int y;
        int Min;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)bufferIn, (BufferedImage)bufferOut)) {
            throw new IllegalArgumentException("Images have different type or dimensions.");
        }
        WritableRaster wrin = bufferIn.getRaster();
        WritableRaster wrout = bufferOut.getRaster();
        int height = bufferIn.getHeight();
        int width = bufferIn.getWidth();
        int Max = Min = wrin.getSample(0, 0, 0);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (wrin.getSample(x, y, 0) > Max) {
                    Max = wrin.getSample(x, y, 0);
                }
                if (wrin.getSample(x, y, 0) >= Min) continue;
                Min = wrin.getSample(x, y, 0);
            }
        }
        switch (bufferIn.getType()) {
            case 10: {
                double c = 255.0 / (double)(Max - Min);
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        wrout.setSample(x, y, 0, (int)((wrin.getSampleDouble(x, y, 0) - (double)Min) * c));
                    }
                }
                break;
            }
            case 11: {
                double c = 65535.0 / (double)(Max - Min);
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        wrout.setSample(x, y, 0, (int)((wrin.getSampleDouble(x, y, 0) - (double)Min) * c));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported. Gray level required.");
            }
        }
        wrout = null;
        wrin = null;
    }

    public static BufferedImage PowerSpectrum(Complex[][] data) {
        float r;
        int col;
        int row;
        int maxN = data.length;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float[][] fps = new float[maxN][maxN];
        byte[][] ps = new byte[maxN][maxN];
        for (row = 0; row < maxN; ++row) {
            ToolsFFT.FHTps(row, maxN, data, fps);
            for (col = 0; col < maxN; ++col) {
                r = fps[row][col];
                if (r < min) {
                    min = r;
                }
                if (!(r > max)) continue;
                max = r;
            }
        }
        min = (double)min < 1.0 ? 0.0f : (float)Math.log(min);
        max = (float)Math.log(max);
        float scale = (float)(253.0 / (double)(max - min));
        for (row = 0; row < maxN; ++row) {
            for (col = 0; col < maxN; ++col) {
                r = fps[row][col];
                r = r < 1.0f ? 0.0f : (float)Math.log(r);
                ps[row][col] = (byte)((double)((r - min) * scale) + 0.5 + 1.0);
            }
        }
        fps = null;
        return ImageConverter.ByteToImage((byte[][])ps);
    }

    private static void FHTps(int row, int maxN, Complex[][] fht, float[][] ps) {
        for (int c = 0; c < maxN; ++c) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            ps[row][c] = (float)(Math.pow(fht[row][c].re, 2.0) + Math.pow(fht[l / maxN][l % maxN].re, 2.0)) / 2.0f;
        }
    }

    public static BufferedImage Display(Complex[][] bufferIn, boolean logScale) {
        BufferedImage result = new BufferedImage(bufferIn[0].length, bufferIn.length, 10);
        ToolsFFT.Display(bufferIn, result, logScale);
        return result;
    }

    public static void Display(Complex[][] bufferIn, BufferedImage bufferOut, boolean logScale) {
        double Mod;
        int x;
        int y;
        int graylevel;
        int width = bufferIn[0].length;
        int height = bufferIn.length;
        WritableRaster wr = bufferOut.getRaster();
        switch (bufferOut.getType()) {
            case 10: {
                graylevel = 255;
                break;
            }
            case 11: {
                graylevel = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported. Gray level required.");
            }
        }
        double Min = logScale ? Math.log(1.0 + Math.sqrt(Math.pow(bufferIn[0][0].re, 2.0) + Math.pow(bufferIn[0][0].im, 2.0))) : Math.log(Math.sqrt(Math.pow(bufferIn[0][0].re, 2.0) + Math.pow(bufferIn[0][0].im, 2.0)));
        double Max = Min;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                Mod = Math.sqrt(Math.pow(bufferIn[y][x].re, 2.0) + Math.pow(bufferIn[y][x].im, 2.0));
                if (logScale) {
                    Mod = Math.log(1.0 + Mod);
                }
                if (Min > Mod) {
                    Min = Mod;
                }
                if (!(Max < Mod)) continue;
                Max = Mod;
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                Mod = Math.sqrt(Math.pow(bufferIn[y][x].re, 2.0) + Math.pow(bufferIn[y][x].im, 2.0));
                if (logScale) {
                    Mod = Math.log(1.0 + Mod);
                }
                wr.setSample(x, y, 0, (int)((Mod - Min) / (Max - Min) * (double)graylevel + 0.5));
            }
        }
        wr = null;
    }

    public static BufferedImage Display(double[] bufferIn, int width, int height, boolean logScale) {
        BufferedImage result = new BufferedImage(width, height, 10);
        ToolsFFT.Display(bufferIn, result, logScale);
        return result;
    }

    public static void Display(double[] bufferIn, BufferedImage bufferOut, boolean logScale) {
        int width = bufferOut.getWidth();
        int height = bufferOut.getHeight();
        double Min = logScale ? Math.log(1.0 + Math.sqrt(bufferIn[0] * bufferIn[0] + bufferIn[1] * bufferIn[1])) : Math.log(Math.sqrt(bufferIn[0] * bufferIn[0] + bufferIn[1] * bufferIn[1]));
        double Max = Min;
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                double Mod = Math.sqrt(bufferIn[pos] * bufferIn[pos] + bufferIn[pos + 1] * bufferIn[pos + 1]);
                if (logScale) {
                    Mod = Math.log(1.0 + Mod);
                }
                if (Min > Mod) {
                    Min = Mod;
                }
                if (Max < Mod) {
                    Max = Mod;
                }
                ++x;
                pos += 2;
            }
        }
        double maxmin = Max - Min;
        switch (bufferOut.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)bufferOut.getRaster().getDataBuffer()).getData();
                int pos2 = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int pos22 = pos2 << 1;
                        double Mod = Math.sqrt(bufferIn[pos22] * bufferIn[pos22] + bufferIn[pos22 + 1] * bufferIn[pos22 + 1]);
                        if (logScale) {
                            Mod = Math.log(1.0 + Mod);
                        }
                        bb[pos2] = (byte)((Mod - Min) / maxmin * 255.0 + 0.5);
                        ++x;
                        ++pos2;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)bufferOut.getRaster().getDataBuffer()).getData();
                int pos3 = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int pos2 = pos3 << 1;
                        double Mod = Math.sqrt(bufferIn[pos2] * bufferIn[pos2] + bufferIn[pos2 + 1] * bufferIn[pos2 + 1]);
                        if (logScale) {
                            Mod = Math.log(1.0 + Mod);
                        }
                        sb[pos3] = (short)((Mod - Min) / maxmin * 65535.0 + 0.5);
                        ++x;
                        ++pos3;
                    }
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported. Gray level required.");
            }
        }
    }

    public static BufferedImage Display(double[][] bufferIn, boolean logScale) {
        BufferedImage result = new BufferedImage(bufferIn[0].length >> 1, bufferIn.length, 10);
        ToolsFFT.Display(bufferIn, result, logScale);
        return result;
    }

    public static void Display(double[][] bufferIn, BufferedImage bufferOut, boolean logScale) {
        int width = bufferIn[0].length >> 1;
        int height = bufferIn.length;
        double Min = logScale ? Math.log(1.0 + Math.sqrt(bufferIn[0][0] * bufferIn[0][0] + bufferIn[0][1] * bufferIn[0][1])) : Math.log(Math.sqrt(bufferIn[0][0] * bufferIn[0][0] + bufferIn[0][1] * bufferIn[0][1]));
        double Max = Min;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int x2 = x << 1;
                double Mod = Math.sqrt(bufferIn[y][x2] * bufferIn[y][x2] + bufferIn[y][x2 + 1] * bufferIn[y][x2 + 1]);
                if (logScale) {
                    Mod = Math.log(1.0 + Mod);
                }
                if (Min > Mod) {
                    Min = Mod;
                }
                if (!(Max < Mod)) continue;
                Max = Mod;
            }
        }
        double maxmin = Max - Min;
        switch (bufferOut.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)bufferOut.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int x2 = x << 1;
                        double Mod = Math.sqrt(bufferIn[y][x2] * bufferIn[y][x2] + bufferIn[y][x2 + 1] * bufferIn[y][x2 + 1]);
                        if (logScale) {
                            Mod = Math.log(1.0 + Mod);
                        }
                        bb[pos] = (byte)((Mod - Min) / maxmin * 255.0 + 0.5);
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)bufferOut.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int x2 = x << 1;
                        double Mod = Math.sqrt(bufferIn[y][x2] * bufferIn[y][x2] + bufferIn[y][x2 + 1] * bufferIn[y][x2 + 1]);
                        if (logScale) {
                            Mod = Math.log(1.0 + Mod);
                        }
                        sb[pos] = (short)((Mod - Min) / maxmin * 65535.0 + 0.5);
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported. Gray level required.");
            }
        }
    }
}

