/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fourier;

import arrayTiTi.ArrayOperations;
import dv.DV;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import mathematics.fourier.FastFourierTransform;
import mathematics.fourier.ToolsFFT;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.DoubleFFT_3D;
import org.jtransforms.fft.FloatFFT_2D;
import org.jtransforms.fft.FloatFFT_3D;

public class JTransformsReal
implements FastFourierTransform {
    private DoubleFFT_2D fft2d = null;
    private DoubleFFT_3D fft3d = null;
    private FloatFFT_2D fft2f = null;
    private FloatFFT_3D fft3f = null;
    private int Width = -1;
    private int Height = -1;
    private int Depth = -1;
    private int lastWidth = -1;
    private int lastHeight = -1;
    private int lastDepth = -1;
    private boolean Mode3D = true;
    private boolean DoublePrecision = true;

    public JTransformsReal(boolean Mode3D, boolean DoublePrecision) {
        this.Mode3D = Mode3D;
        this.DoublePrecision = DoublePrecision;
    }

    @Override
    public Object CreateObject(int width, int height) {
        this.Width = width;
        this.Height = height;
        this.Depth = 0;
        if (this.DoublePrecision) {
            return new double[this.Height * (this.Width << 1)];
        }
        return new float[this.Height * (this.Width << 1)];
    }

    @Override
    public Object CreateObject(int width, int height, int depth) {
        this.Width = width;
        this.Height = height;
        this.Depth = depth;
        if (this.Mode3D) {
            if (this.DoublePrecision) {
                return new double[depth][height][width << 1];
            }
            return new float[depth][height][width << 1];
        }
        long length = depth * height * (width << 1);
        if (Integer.MAX_VALUE < length) {
            throw new IllegalArgumentException("Dimensions too big for the 1D mode.");
        }
        if (this.DoublePrecision) {
            return new double[(int)length];
        }
        return new float[(int)length];
    }

    @Override
    public Object CreateObject(BufferedImage image) {
        return this.CreateObject(image.getWidth(), image.getHeight());
    }

    @Override
    public Object CreateObject(DV dv) {
        return this.CreateObject(dv.SizeX, dv.SizeY, dv.SizeZ);
    }

    @Override
    public Object CreateObject(double[][] image) {
        return this.CreateObject(image[0].length, image.length);
    }

    @Override
    public Object Transform(BufferedImage image) {
        Object object = this.CreateObject(image);
        this.Transform(image, object);
        return object;
    }

    @Override
    public void Transform(BufferedImage image, Object object) {
        if (!this.areDimensionsCorrect(image, object)) {
            throw new IllegalArgumentException("(image.getWidth()<<1)*image.getHeight().");
        }
        if (this.DoublePrecision) {
            double[] obj = (double[])object;
            switch (image.getType()) {
                case 10: {
                    byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < bb.length; ++x) {
                        obj[x] = bb[x] & 0xFF;
                    }
                    break;
                }
                case 11: {
                    short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < sb.length; ++x) {
                        obj[x] = sb[x] & 0xFFFF;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported.");
                }
            }
            obj = null;
            return;
        }
        float[] obj = (float[])object;
        switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bb.length; ++x) {
                    obj[x] = bb[x] & 0xFF;
                }
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sb.length; ++x) {
                    obj[x] = sb[x] & 0xFFFF;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        obj = null;
    }

    @Override
    public Object Transform(double[][] image) {
        Object result = this.CreateObject(image);
        this.Transform(image, result);
        return result;
    }

    @Override
    public void Transform(double[][] image, Object object) {
        int width = image[0].length;
        int height = image.length;
        int dx = this.Width - image[0].length + 1 >> 1;
        int dy = this.Height - image.length + 1 >> 1;
        if (this.DoublePrecision) {
            double[] obj = (double[])object;
            Arrays.fill(obj, 0.0);
            int y = 0;
            int pos = dy * this.Width + dx;
            while (y < height) {
                System.arraycopy(image[y], 0, obj, pos, width);
                ++y;
                pos += this.Width;
            }
            obj = null;
            return;
        }
        float[] obj = (float[])object;
        Arrays.fill(obj, 0.0f);
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                obj[pos] = (float)image[y][x];
                ++x;
                ++pos;
            }
        }
        obj = null;
    }

    @Override
    public Object Transform(DV dv) {
        Object result = this.CreateObject(dv);
        this.Transform(dv, result);
        return result;
    }

    @Override
    public void Transform(DV dv, Object object) {
        if (this.Mode3D) {
            if (this.DoublePrecision) {
                int sizex = dv.SizeX;
                int sizey = dv.SizeY;
                int sizez = dv.SizeZ;
                double[][][] obj3d = (double[][][])object;
                ArrayOperations.Fill((double[][][])obj3d, (double)0.0);
                switch (dv.Type) {
                    case 8: {
                        byte[] bb = dv.getDataBufferByte(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    obj3d[z][y][x] = bb[pos] & 0xFF;
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case 16: {
                        short[] sb = dv.getDataBufferShort(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    obj3d[z][y][x] = sb[pos] & 0xFFFF;
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case 32: {
                        int[] ib = dv.getDataBufferInt(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    obj3d[z][y][x] = ib[pos];
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case -32: {
                        float[] fb = dv.getDataBufferFloat(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    obj3d[z][y][x] = fb[pos];
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case 64: {
                        double[] db = dv.getDataBufferDouble(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            int y = 0;
                            while (y < sizey) {
                                System.arraycopy(db, pos, obj3d[z][y], 0, sizex);
                                ++y;
                                pos += sizex;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("DV type not supported.");
                    }
                }
                obj3d = null;
                return;
            }
            int sizex = dv.SizeX;
            int sizey = dv.SizeY;
            int sizez = dv.SizeZ;
            float[][][] obj3d = (float[][][])object;
            ArrayOperations.Fill((float[][][])obj3d, (float)0.0f);
            switch (dv.Type) {
                case 8: {
                    byte[] bb = dv.getDataBufferByte(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                obj3d[z][y][x] = bb[pos] & 0xFF;
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                case 16: {
                    short[] sb = dv.getDataBufferShort(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                obj3d[z][y][x] = sb[pos] & 0xFFFF;
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                case 32: {
                    int[] ib = dv.getDataBufferInt(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                obj3d[z][y][x] = ib[pos];
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                case -32: {
                    float[] fb = dv.getDataBufferFloat(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        int y = 0;
                        while (y < sizey) {
                            System.arraycopy(fb, pos, obj3d[z][y], 0, sizex);
                            ++y;
                            pos += sizex;
                        }
                    }
                    break;
                }
                case 64: {
                    double[] db = dv.getDataBufferDouble(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                obj3d[z][y][x] = (float)db[pos];
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported.");
                }
            }
            obj3d = null;
            return;
        }
        if (this.DoublePrecision) {
            double[] obj = (double[])object;
            Arrays.fill(obj, 0.0);
            switch (dv.Type) {
                case 8: {
                    byte[] bb = dv.getDataBufferByte(0);
                    for (int x = 0; x < bb.length; ++x) {
                        obj[x] = bb[x] & 0xFF;
                    }
                    break;
                }
                case 16: {
                    short[] sb = dv.getDataBufferShort(0);
                    for (int x = 0; x < sb.length; ++x) {
                        obj[x] = sb[x] & 0xFFFF;
                    }
                    break;
                }
                case 32: {
                    int[] ib = dv.getDataBufferInt(0);
                    for (int x = 0; x < ib.length; ++x) {
                        obj[x] = ib[x];
                    }
                    break;
                }
                case -32: {
                    float[] fb = dv.getDataBufferFloat(0);
                    for (int x = 0; x < fb.length; ++x) {
                        obj[x] = fb[x];
                    }
                    break;
                }
                case 64: {
                    System.arraycopy(dv.getDataBufferDouble(0), 0, obj, 0, dv.Length);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported.");
                }
            }
            obj = null;
            return;
        }
        float[] obj = (float[])object;
        Arrays.fill(obj, 0.0f);
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(0);
                for (int x = 0; x < bb.length; ++x) {
                    obj[x] = bb[x] & 0xFF;
                }
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(0);
                for (int x = 0; x < sb.length; ++x) {
                    obj[x] = sb[x] & 0xFFFF;
                }
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(0);
                for (int x = 0; x < ib.length; ++x) {
                    obj[x] = ib[x];
                }
                break;
            }
            case 64: {
                double[] db = dv.getDataBufferDouble(0);
                for (int x = 0; x < db.length; ++x) {
                    obj[x] = (float)db[x];
                }
                break;
            }
            case -32: {
                System.arraycopy(dv.getDataBufferFloat(0), 0, obj, 0, dv.Length);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        obj = null;
    }

    @Override
    public Object Transform(StructuringElement se) {
        Object object = this.CreateObject(this.Width, this.Height);
        this.Transform(se, object);
        return object;
    }

    @Override
    public void Transform(StructuringElement se, Object object) {
        int dx = this.Width >> 1;
        int dy = this.Height >> 1;
        int pos = dx + dy * this.Width;
        CoordinatesWeighted[] coords = se.getSE();
        se.PreComputePositions(this.Width);
        if (this.DoublePrecision) {
            double[] obj = (double[])object;
            if ((this.Width << 1) * this.Height != obj.length) {
                throw new IllegalArgumentException("The last created Object had different dimensions.");
            }
            Arrays.fill(obj, 0.0);
            for (int x = 0; x < coords.length; ++x) {
                CoordinatesWeighted c = coords[x];
                obj[pos + c.Pos] = c.Wd;
                c = null;
            }
            obj = null;
            return;
        }
        float[] obj = (float[])object;
        if ((this.Width << 1) * this.Height != obj.length) {
            throw new IllegalArgumentException("The last created Object had different dimensions.");
        }
        Arrays.fill(obj, 0.0f);
        for (int x = 0; x < coords.length; ++x) {
            CoordinatesWeighted c = coords[x];
            obj[pos + c.Pos] = (float)c.Wd;
            c = null;
        }
        obj = null;
    }

    @Override
    public Object Transform(StructuringElement3D se) {
        Object object = this.CreateObject(this.Width, this.Height, this.Depth);
        this.Transform(se, object);
        return object;
    }

    @Override
    public void Transform(StructuringElement3D se, Object object) {
        int dx = this.Width >> 1;
        int dy = this.Height >> 1;
        int dz = this.Depth >> 1;
        CoordinatesWeighted[] coords = se.getSE();
        if (this.Mode3D) {
            if (this.DoublePrecision) {
                double[][][] obj3d = (double[][][])object;
                if (this.Width << 1 != obj3d[0][0].length || this.Height != obj3d[0].length || this.Depth != obj3d.length) {
                    throw new IllegalArgumentException("The last created Object had different dimensions.");
                }
                ArrayOperations.Fill((double[][][])obj3d, (double)0.0);
                for (int x = 0; x < coords.length; ++x) {
                    CoordinatesWeighted c = coords[x];
                    obj3d[dz + c.Z][dy + c.Y][dx + c.X] = c.Wd;
                    c = null;
                }
                coords = null;
                obj3d = null;
                return;
            }
            float[][][] obj3d = (float[][][])object;
            if (this.Width << 1 != obj3d[0][0].length || this.Height != obj3d[0].length || this.Depth != obj3d.length) {
                throw new IllegalArgumentException("The last created Object had different dimensions.");
            }
            ArrayOperations.Fill((float[][][])obj3d, (float)0.0f);
            for (int x = 0; x < coords.length; ++x) {
                CoordinatesWeighted c = coords[x];
                obj3d[dz + c.Z][dy + c.Y][dx + c.X] = (float)c.Wd;
                c = null;
            }
            coords = null;
            obj3d = null;
            return;
        }
        se.PreComputePositions(this.Width, this.Height);
        if (this.DoublePrecision) {
            double[] obj = (double[])object;
            if ((this.Width << 1) * this.Height * this.Depth != obj.length) {
                throw new IllegalArgumentException("The last created Object had different dimensions.");
            }
            int pos = dx + (dy + dz * this.Height) * this.Width;
            Arrays.fill(obj, 0.0);
            for (int x = 0; x < coords.length; ++x) {
                CoordinatesWeighted c = coords[x];
                obj[pos + c.Pos] = c.Wd;
                c = null;
            }
            coords = null;
            obj = null;
            return;
        }
        float[] obj = (float[])object;
        if ((this.Width << 1) * this.Height * this.Depth != obj.length) {
            throw new IllegalArgumentException("The last created Object had different dimensions.");
        }
        int pos = dx + (dy + dz * this.Height) * this.Width;
        Arrays.fill(obj, 0.0f);
        for (int x = 0; x < coords.length; ++x) {
            CoordinatesWeighted c = coords[x];
            obj[pos + c.Pos] = (float)c.Wd;
            c = null;
        }
        coords = null;
        obj = null;
    }

    @Override
    public void Transform(Object object, BufferedImage image) {
        if (this.DoublePrecision) {
            double[] obj = (double[])object;
            switch (image.getType()) {
                case 10: {
                    byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    int pos = 0;
                    int x = 0;
                    while (x < bb.length) {
                        bb[x] = (byte)(obj[pos] + 0.5);
                        ++x;
                        pos += 2;
                    }
                    break;
                }
                case 11: {
                    short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                    int pos = 0;
                    int x = 0;
                    while (x < sb.length) {
                        sb[x] = (short)(obj[pos] + 0.5);
                        ++x;
                        pos += 2;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported.");
                }
            }
            obj = null;
            return;
        }
        float[] obj = (float[])object;
        switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int x = 0;
                while (x < bb.length) {
                    bb[x] = (byte)((double)obj[pos] + 0.5);
                    ++x;
                    pos += 2;
                }
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int x = 0;
                while (x < sb.length) {
                    sb[x] = (short)((double)obj[pos] + 0.5);
                    ++x;
                    pos += 2;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        obj = null;
    }

    @Override
    public void Transform(Object object, DV dv) {
        int sizex = dv.SizeX;
        int sizey = dv.SizeY;
        int sizez = dv.SizeZ;
        if (this.Mode3D) {
            if (this.DoublePrecision) {
                double[][][] obj3d = (double[][][])object;
                switch (dv.Type) {
                    case 8: {
                        byte[] bb = dv.getDataBufferByte(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    bb[pos] = (byte)(obj3d[z][y][x << 1] + 0.5);
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case 16: {
                        short[] sb = dv.getDataBufferShort(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    sb[pos] = (short)(obj3d[z][y][x << 1] + 0.5);
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case 32: {
                        int[] ib = dv.getDataBufferInt(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    ib[pos] = (int)(obj3d[z][y][x << 1] + 0.5);
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case -32: {
                        float[] fb = dv.getDataBufferFloat(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    fb[pos] = (float)obj3d[z][y][x << 1];
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    case 64: {
                        double[] db = dv.getDataBufferDouble(0);
                        int pos = 0;
                        for (int z = 0; z < sizez; ++z) {
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                while (x < sizex) {
                                    db[pos] = obj3d[z][y][x << 1];
                                    ++x;
                                    ++pos;
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("DV type not supported.");
                    }
                }
                obj3d = null;
                return;
            }
            float[][][] obj3d = (float[][][])object;
            switch (dv.Type) {
                case 8: {
                    byte[] bb = dv.getDataBufferByte(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                bb[pos] = (byte)((double)obj3d[z][y][x << 1] + 0.5);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                case 16: {
                    short[] sb = dv.getDataBufferShort(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                sb[pos] = (short)((double)obj3d[z][y][x << 1] + 0.5);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                case 32: {
                    int[] ib = dv.getDataBufferInt(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                ib[pos] = (int)((double)obj3d[z][y][x << 1] + 0.5);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    ib = null;
                    break;
                }
                case -32: {
                    float[] fb = dv.getDataBufferFloat(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                fb[pos] = obj3d[z][y][x << 1];
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                case 64: {
                    double[] db = dv.getDataBufferDouble(0);
                    int pos = 0;
                    for (int z = 0; z < sizez; ++z) {
                        for (int y = 0; y < sizey; ++y) {
                            int x = 0;
                            while (x < sizex) {
                                db[pos] = obj3d[z][y][x << 1];
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported.");
                }
            }
            obj3d = null;
            return;
        }
        if (this.DoublePrecision) {
            double[] obj = (double[])object;
            switch (dv.Type) {
                case 8: {
                    byte[] bb = dv.getDataBufferByte(0);
                    int pos = 0;
                    int x = 0;
                    while (x < dv.Length) {
                        bb[x] = (byte)(obj[pos] + 0.5);
                        ++x;
                        pos += 2;
                    }
                    break;
                }
                case 16: {
                    short[] sb = dv.getDataBufferShort(0);
                    int pos = 0;
                    int x = 0;
                    while (x < dv.Length) {
                        sb[x] = (short)(obj[pos] + 0.5);
                        ++x;
                        pos += 2;
                    }
                    break;
                }
                case 32: {
                    int[] ib = dv.getDataBufferInt(0);
                    int pos = 0;
                    int x = 0;
                    while (x < dv.Length) {
                        ib[x] = (int)(obj[pos] + 0.5);
                        ++x;
                        pos += 2;
                    }
                    break;
                }
                case -32: {
                    float[] fb = dv.getDataBufferFloat(0);
                    int pos = 0;
                    int x = 0;
                    while (x < dv.Length) {
                        fb[x] = (float)obj[pos];
                        ++x;
                        pos += 2;
                    }
                    break;
                }
                case 64: {
                    double[] db = dv.getDataBufferDouble(0);
                    int pos = 0;
                    int x = 0;
                    while (x < dv.Length) {
                        db[x] = obj[pos];
                        ++x;
                        pos += 2;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported.");
                }
            }
            obj = null;
            return;
        }
        float[] obj = (float[])object;
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(0);
                int pos = 0;
                int x = 0;
                while (x < dv.Length) {
                    bb[x] = (byte)((double)obj[pos] + 0.5);
                    ++x;
                    pos += 2;
                }
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(0);
                int pos = 0;
                int x = 0;
                while (x < dv.Length) {
                    sb[x] = (short)((double)obj[pos] + 0.5);
                    ++x;
                    pos += 2;
                }
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(0);
                int pos = 0;
                int x = 0;
                while (x < dv.Length) {
                    ib[x] = (int)((double)obj[pos] + 0.5);
                    ++x;
                    pos += 2;
                }
                break;
            }
            case -32: {
                float[] fb = dv.getDataBufferFloat(0);
                int pos = 0;
                int x = 0;
                while (x < dv.Length) {
                    fb[x] = obj[pos];
                    ++x;
                    pos += 2;
                }
                break;
            }
            case 64: {
                double[] db = dv.getDataBufferDouble(0);
                int pos = 0;
                int x = 0;
                while (x < dv.Length) {
                    db[x] = obj[pos];
                    ++x;
                    pos += 2;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        obj = null;
    }

    @Override
    public void Transform(Object object, double[][] image) {
        int x;
        int y;
        int pos;
        Object[] obj;
        int width = image[0].length;
        int height = image.length;
        if (this.DoublePrecision) {
            obj = (double[])object;
            pos = 0;
            for (y = 0; y < height; ++y) {
                x = 0;
                while (x < width) {
                    image[y][x] = obj[pos];
                    ++x;
                    pos += 2;
                }
            }
            obj = null;
        }
        obj = (float[])object;
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                image[y][x] = obj[pos];
                ++x;
                pos += 2;
            }
        }
        obj = null;
    }

    @Override
    public void Compute2D(Object object, int direction, int nbCPU) {
        block11: {
            block10: {
                if (!this.DoublePrecision) break block10;
                if (this.fft2d == null || this.Width != this.lastWidth || this.Height != this.lastHeight) {
                    this.fft2d = null;
                    this.fft2d = new DoubleFFT_2D((long)this.Height, (long)this.Width);
                }
                switch (direction) {
                    case -1: {
                        this.fft2d.realForwardFull((double[])object);
                        break block11;
                    }
                    case 1: {
                        this.fft2d.complexInverse((double[])object, true);
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown direction.");
                    }
                }
            }
            if (this.fft2f == null || this.Width != this.lastWidth || this.Height != this.lastHeight) {
                this.fft2f = null;
                this.fft2f = new FloatFFT_2D((long)this.Height, (long)this.Width);
            }
            switch (direction) {
                case -1: {
                    this.fft2f.realForwardFull((float[])object);
                    break;
                }
                case 1: {
                    this.fft2f.complexInverse((float[])object, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown direction.");
                }
            }
        }
        this.lastWidth = this.Width;
        this.lastHeight = this.Height;
        this.Depth = -1;
        this.lastDepth = -1;
    }

    @Override
    public void Compute3D(Object object, int direction, int nbCPU) {
        block17: {
            block16: {
                if (!this.DoublePrecision) break block16;
                if (this.fft3d == null || this.Width != this.lastWidth || this.Height != this.lastHeight || this.Depth != this.lastDepth) {
                    this.fft3d = null;
                    this.fft3d = new DoubleFFT_3D((long)this.Depth, (long)this.Height, (long)this.Width);
                }
                switch (direction) {
                    case -1: {
                        if (this.Mode3D) {
                            this.fft3d.realForwardFull((double[][][])object);
                        } else {
                            this.fft3d.realForwardFull((double[])object);
                        }
                        break block17;
                    }
                    case 1: {
                        if (this.Mode3D) {
                            this.fft3d.complexInverse((double[][][])object, true);
                        } else {
                            this.fft3d.complexInverse((double[])object, true);
                        }
                        break block17;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown direction.");
                    }
                }
            }
            if (this.fft3f == null || this.Width != this.lastWidth || this.Height != this.lastHeight || this.Depth != this.lastDepth) {
                this.fft3f = null;
                this.fft3f = new FloatFFT_3D((long)this.Depth, (long)this.Height, (long)this.Width);
            }
            switch (direction) {
                case -1: {
                    if (this.Mode3D) {
                        this.fft3f.realForwardFull((float[][][])object);
                        break;
                    }
                    this.fft3f.realForwardFull((float[])object);
                    break;
                }
                case 1: {
                    if (this.Mode3D) {
                        this.fft3f.complexInverse((float[][][])object, true);
                        break;
                    }
                    this.fft3f.complexInverse((float[])object, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown direction.");
                }
            }
        }
        this.lastWidth = this.Width;
        this.lastHeight = this.Height;
        this.lastDepth = this.Depth;
    }

    @Override
    public void Multiply2D(Object object1, Object object2, Object result) {
        if (this.DoublePrecision) {
            double[] obj1 = (double[])object1;
            double[] obj2 = (double[])object2;
            double[] res = (double[])result;
            for (int pos = 0; pos < res.length; pos += 2) {
                double img_r = obj1[pos];
                double img_i = obj1[pos + 1];
                double mask_r = obj2[pos];
                double mask_i = obj2[pos + 1];
                res[pos] = img_r * mask_r - img_i * mask_i;
                res[pos + 1] = img_r * mask_i + img_i * mask_r;
            }
            return;
        }
        float[] obj1 = (float[])object1;
        float[] obj2 = (float[])object2;
        float[] res = (float[])result;
        for (int pos = 0; pos < res.length; pos += 2) {
            float img_r = obj1[pos];
            float img_i = obj1[pos + 1];
            float mask_r = obj2[pos];
            float mask_i = obj2[pos + 1];
            res[pos] = img_r * mask_r - img_i * mask_i;
            res[pos + 1] = img_r * mask_i + img_i * mask_r;
        }
    }

    @Override
    public void Multiply3D(Object object1, Object object2, Object result) {
        if (!this.Mode3D) {
            this.Multiply2D(object1, object2, result);
            return;
        }
        if (this.DoublePrecision) {
            double[][][] obj1 = (double[][][])object1;
            double[][][] obj2 = (double[][][])object2;
            double[][][] res = (double[][][])result;
            int sizex = obj1[0][0].length;
            int sizey = obj1[0].length;
            int sizez = obj1.length;
            for (int z = 0; z < sizez; ++z) {
                for (int y = 0; y < sizey; ++y) {
                    for (int x = 0; x < sizex; x += 2) {
                        double img_r = obj1[z][y][x];
                        double img_i = obj1[z][y][x + 1];
                        double mask_r = obj2[z][y][x];
                        double mask_i = obj2[z][y][x + 1];
                        res[z][y][x] = img_r * mask_r - img_i * mask_i;
                        res[z][y][x + 1] = img_r * mask_i + img_i * mask_r;
                    }
                }
            }
            return;
        }
        float[][][] obj1 = (float[][][])object1;
        float[][][] obj2 = (float[][][])object2;
        float[][][] res = (float[][][])result;
        int sizex = obj1[0][0].length;
        int sizey = obj1[0].length;
        int sizez = obj1.length;
        for (int z = 0; z < sizez; ++z) {
            for (int y = 0; y < sizey; ++y) {
                for (int x = 0; x < sizex; x += 2) {
                    float img_r = obj1[z][y][x];
                    float img_i = obj1[z][y][x + 1];
                    float mask_r = obj2[z][y][x];
                    float mask_i = obj2[z][y][x + 1];
                    res[z][y][x] = img_r * mask_r - img_i * mask_i;
                    res[z][y][x + 1] = img_r * mask_i + img_i * mask_r;
                }
            }
        }
    }

    @Override
    public void Shift(Object object) {
        if (this.DoublePrecision) {
            if (this.Depth == -1) {
                ToolsFFT.Shift((double[])object, this.Width << 1, this.Height);
            } else if (this.Mode3D) {
                ToolsFFT.Shift((double[][][])object);
            } else {
                ToolsFFT.Shift((double[])object, this.Width << 1, this.Height, this.Depth);
            }
        } else if (this.Depth == -1) {
            ToolsFFT.Shift((float[])object, this.Width << 1, this.Height);
        } else if (this.Mode3D) {
            ToolsFFT.Shift((float[][][])object);
        } else {
            ToolsFFT.Shift((float[])object, this.Width << 1, this.Height, this.Depth);
        }
    }

    @Override
    public boolean ShiftRequired() {
        return true;
    }

    @Override
    public boolean areDimensionsCorrect(BufferedImage image, Object object) {
        try {
            if (this.DoublePrecision) {
                return ((double[])object).length == image.getHeight() * (image.getWidth() << 1);
            }
            return ((float[])object).length == image.getHeight() * (image.getWidth() << 1);
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public boolean areDimensionsCorrect(DV dv, Object object) {
        try {
            if (this.DoublePrecision) {
                if (this.Mode3D) {
                    double[][][] obj = (double[][][])object;
                    return obj.length == dv.SizeZ && obj[0].length == dv.SizeY && obj[0][0].length == dv.SizeX << 1;
                }
                long length = dv.SizeZ * dv.SizeY * (dv.SizeX << 1);
                return (long)((double[])object).length == length;
            }
            if (this.Mode3D) {
                float[][][] obj = (float[][][])object;
                return obj.length == dv.SizeZ && obj[0].length == dv.SizeY && obj[0][0].length == dv.SizeX << 1;
            }
            long length = dv.SizeZ * dv.SizeY * (dv.SizeX << 1);
            return (long)((float[])object).length == length;
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public boolean areDimensionsCorrect(double[][] image, Object object) {
        try {
            if (this.DoublePrecision) {
                double[][] obj = (double[][])object;
                return obj.length == image.length && obj[0].length == image[0].length << 1;
            }
            float[][] obj = (float[][])object;
            return obj.length == image.length && obj[0].length == image[0].length << 1;
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public FastFourierTransform Clone() {
        return new JTransformsReal(this.Mode3D, this.DoublePrecision);
    }
}

