/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fourier;

import arrayTiTi.ArrayOperations;
import dv.DV;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import mathematics.Maths;
import mathematics.fourier.FastFourierTransform;
import mathematics.fourier.ToolsFFT;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.DoubleFFT_3D;

public class JTransformsComplex
implements FastFourierTransform {
    private DoubleFFT_2D fft2 = null;
    private DoubleFFT_3D fft3 = null;
    private int Width = 0;
    private int Height = 0;
    private int Depth = 0;
    private int lastWidth;
    private int lastHeight;
    private int lastDepth;

    @Override
    public Object CreateObject(int width, int height) {
        if (!Maths.isPowerOf2((int)width) || !Maths.isPowerOf2((int)height)) {
            throw new IllegalArgumentException("Dimensions are not dyadic.");
        }
        this.Width = width;
        this.Height = height;
        this.Depth = 0;
        return new double[height][width << 1];
    }

    @Override
    public Object CreateObject(int width, int height, int depth) {
        if (!(Maths.isPowerOf2((int)width) && Maths.isPowerOf2((int)height) && Maths.isPowerOf2((int)depth))) {
            throw new IllegalArgumentException("Dimensions are not dyadic.");
        }
        this.Width = width;
        this.Height = height;
        this.Depth = depth;
        return new double[depth][height][width << 1];
    }

    @Override
    public Object CreateObject(BufferedImage image) {
        return this.CreateObject(Maths.NextPower2((int)image.getWidth()), Maths.NextPower2((int)image.getHeight()));
    }

    @Override
    public Object CreateObject(DV dv) {
        return this.CreateObject(Maths.NextPower2((int)dv.SizeX), Maths.NextPower2((int)dv.SizeY), Maths.NextPower2((int)dv.SizeZ));
    }

    @Override
    public Object CreateObject(double[][] image) {
        return this.CreateObject(Maths.NextPower2((int)image[0].length), Maths.NextPower2((int)image.length));
    }

    @Override
    public Object Transform(BufferedImage image) {
        double[][] object = new double[Maths.NextPower2((int)image.getHeight())][Maths.NextPower2((int)image.getWidth()) << 1];
        this.Transform(image, (Object)object);
        return object;
    }

    @Override
    public void Transform(BufferedImage image, Object object) {
        double[][] obj = (double[][])object;
        int width = image.getWidth();
        int height = image.getHeight();
        if (!this.areDimensionsCorrect(image, object)) {
            throw new IllegalArgumentException("The last created Object had different dimensions.");
        }
        int dx = (obj[0].length >> 1) - width >> 1;
        int dy = obj.length - height >> 1;
        ArrayOperations.Fill((double[][])obj, (double)0.0);
        switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        obj[y + dy][x + dx << 1] = bb[pos] & 0xFF;
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        obj[y + dy][x + dx << 1] = sb[pos] & 0xFFFF;
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        obj = null;
    }

    @Override
    public Object Transform(double[][] image) {
        Object result = this.CreateObject(image);
        this.Transform(image, result);
        return result;
    }

    @Override
    public void Transform(double[][] image, Object object) {
        double[][] obj = (double[][])object;
        int width = image[0].length;
        int height = image.length;
        int dx = (obj[0].length >> 1) - width + 1 >> 1;
        int dy = obj.length - height + 1 >> 1;
        ArrayOperations.Fill((double[][])obj, (double)0.0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                obj[y + dy][x + dx << 1] = image[y][x];
            }
        }
        obj = null;
    }

    @Override
    public Object Transform(DV dv) {
        Object result = this.CreateObject(dv);
        this.Transform(dv, result);
        return result;
    }

    @Override
    public void Transform(DV dv, Object object) {
        double[][][] obj = (double[][][])object;
        int width = dv.SizeX;
        int height = dv.SizeY;
        int depth = dv.SizeZ;
        if (!this.areDimensionsCorrect(dv, object)) {
            throw new IllegalArgumentException("The last created Object had different dimensions.");
        }
        int dx = (obj[0][0].length >> 1) - width >> 1;
        int dy = obj[0].length - height >> 1;
        int dz = obj.length - depth >> 1;
        ArrayOperations.Fill((double[][][])obj, (double)0.0);
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            obj[z + dz][y + dy][x + dx << 1] = bb[pos] & 0xFF;
                            ++x;
                            ++pos;
                        }
                    }
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            obj[z + dz][y + dy][x + dx << 1] = sb[pos] & 0xFFFF;
                            ++x;
                            ++pos;
                        }
                    }
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            obj[z + dz][y + dy][x + dx << 1] = ib[pos];
                            ++x;
                            ++pos;
                        }
                    }
                }
                ib = null;
                break;
            }
            case -32: {
                float[] fb = dv.getDataBufferFloat(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            obj[z + dz][y + dy][x + dx << 1] = fb[pos];
                            ++x;
                            ++pos;
                        }
                    }
                }
                fb = null;
                break;
            }
            case 64: {
                double[] db = dv.getDataBufferDouble(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            obj[z + dz][y + dy][x + dx << 1] = db[pos];
                            ++x;
                            ++pos;
                        }
                    }
                }
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        obj = null;
    }

    @Override
    public Object Transform(StructuringElement se) {
        Object object = this.CreateObject(this.Width, this.Height);
        this.Transform(se, object);
        return object;
    }

    @Override
    public void Transform(StructuringElement se, Object object) {
        double[][] obj = (double[][])object;
        int width = obj[0].length;
        int height = obj.length;
        if (width >> 1 != this.Width || height != this.Height) {
            throw new IllegalArgumentException("The last created Object had different dimensions.");
        }
        int dx = ((obj[0].length >> 1) - se.getSizeX() + 1 >> 1) + (se.getSizeX() >> 1);
        int dy = (obj.length - se.getSizeY() + 1 >> 1) + (se.getSizeY() >> 1);
        CoordinatesWeighted[] coords = se.getSE();
        ArrayOperations.Fill((double[][])obj, (double)0.0);
        for (int x = 0; x < coords.length; ++x) {
            CoordinatesWeighted c = coords[x];
            obj[dy + c.Y][dx + c.X << 1] = c.Wd;
            c = null;
        }
        obj = null;
    }

    @Override
    public Object Transform(StructuringElement3D se) {
        Object object = this.CreateObject(this.Width, this.Height, this.Depth);
        this.Transform(se, object);
        return object;
    }

    @Override
    public void Transform(StructuringElement3D se, Object object) {
        double[][][] obj = (double[][][])object;
        if (obj[0][0].length >> 1 != this.Width || obj[0].length != this.Height || obj.length != this.Depth) {
            throw new IllegalArgumentException("The last created Object had different dimensions.");
        }
        int dx = ((obj[0][0].length >> 1) - se.getSizeX() + 1 >> 1) + (se.getSizeX() >> 1);
        int dy = (obj[0].length - se.getSizeY() + 1 >> 1) + (se.getSizeY() >> 1);
        int dz = (obj.length - se.getSizeZ() + 1 >> 1) + (se.getSizeZ() >> 1);
        CoordinatesWeighted[] coords = se.getSE();
        ArrayOperations.Fill((double[][][])obj, (double)0.0);
        se.PreComputePositions(this.Width, this.Height);
        for (int x = 0; x < coords.length; ++x) {
            CoordinatesWeighted c = coords[x];
            obj[dz + c.Z][dy + c.Y][dx + c.X << 1] = c.Wd;
            c = null;
        }
        obj = null;
    }

    @Override
    public void Transform(Object object, BufferedImage image) {
        double[][] obj = (double[][])object;
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster wr = image.getRaster();
        int dx = (obj[0].length >> 1) - width >> 1;
        int dy = obj.length - height >> 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.setSample(x, y, 0, (int)(obj[y + dy][x + dx << 1] + 0.5));
            }
        }
        wr = null;
        obj = null;
    }

    @Override
    public void Transform(Object object, DV dv) {
        double[][][] obj = (double[][][])object;
        int width = dv.SizeX;
        int height = dv.SizeY;
        int depth = dv.SizeZ;
        int dx = (obj[0][0].length >> 1) - width >> 1;
        int dy = obj[0].length - height >> 1;
        int dz = obj.length - depth >> 1;
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            bb[pos] = (byte)(obj[z + dz][y + dy][x + dx << 1] + 0.5);
                            ++x;
                            ++pos;
                        }
                    }
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            sb[pos] = (short)(obj[z + dz][y + dy][x + dx << 1] + 0.5);
                            ++x;
                            ++pos;
                        }
                    }
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            ib[pos] = (int)(obj[z + dz][y + dy][x + dx << 1] + 0.5);
                            ++x;
                            ++pos;
                        }
                    }
                }
                ib = null;
                break;
            }
            case -32: {
                float[] fb = dv.getDataBufferFloat(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            fb[pos] = (float)obj[z + dz][y + dy][x + dx << 1];
                            ++x;
                            ++pos;
                        }
                    }
                }
                fb = null;
                break;
            }
            case 64: {
                double[] db = dv.getDataBufferDouble(0);
                int pos = 0;
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            db[pos] = obj[z + dz][y + dy][x + dx << 1];
                            ++x;
                            ++pos;
                        }
                    }
                }
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        obj = null;
    }

    @Override
    public void Transform(Object object, double[][] image) {
        double[][] obj = (double[][])object;
        int width = image[0].length;
        int height = image.length;
        int dx = (obj[0].length >> 1) - width >> 1;
        int dy = obj.length - height >> 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image[y][x] = obj[y + dy][x + dx << 1];
            }
        }
        obj = null;
    }

    @Override
    public void Compute2D(Object object, int direction, int nbCPU) {
        double[][] obj = (double[][])object;
        if (this.fft2 == null || this.Width != this.lastWidth || this.Height != this.lastHeight) {
            this.fft2 = null;
            this.Width = obj[0].length >> 1;
            this.Height = obj.length;
            this.fft2 = new DoubleFFT_2D((long)this.Height, (long)this.Width);
        }
        switch (direction) {
            case -1: {
                this.fft2.complexForward(obj);
                break;
            }
            case 1: {
                this.fft2.complexInverse(obj, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction.");
            }
        }
        this.lastWidth = this.Width;
        this.lastHeight = this.Height;
        this.Depth = -1;
        this.lastDepth = -1;
        obj = null;
    }

    @Override
    public void Compute3D(Object object, int direction, int nbCPU) {
        double[][][] obj = (double[][][])object;
        if (this.fft3 == null || this.Width != this.lastWidth || this.Height != this.lastHeight || this.Depth != this.lastDepth) {
            this.fft3 = null;
            this.Width = obj[0][0].length >> 1;
            this.Height = obj[0].length;
            this.Depth = obj.length;
            this.fft3 = new DoubleFFT_3D((long)this.Depth, (long)this.Height, (long)this.Width);
        }
        switch (direction) {
            case -1: {
                this.fft3.complexForward(obj);
                break;
            }
            case 1: {
                this.fft3.complexInverse(obj, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction.");
            }
        }
        this.lastWidth = this.Width;
        this.lastHeight = this.Height;
        this.lastDepth = this.Depth;
        obj = null;
    }

    @Override
    public void Multiply2D(Object object1, Object object2, Object result) {
        double[][] obj1 = (double[][])object1;
        double[][] obj2 = (double[][])object2;
        double[][] res = (double[][])result;
        int width = res[0].length;
        int height = res.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; x += 2) {
                double img_r = obj1[y][x];
                double img_i = obj1[y][x + 1];
                double mask_r = obj2[y][x];
                double mask_i = obj2[y][x + 1];
                res[y][x] = img_r * mask_r - img_i * mask_i;
                res[y][x + 1] = img_r * mask_i + img_i * mask_r;
            }
        }
        res = null;
        obj2 = null;
        obj1 = null;
    }

    @Override
    public void Multiply3D(Object object1, Object object2, Object result) {
        double[][][] obj1 = (double[][][])object1;
        double[][][] obj2 = (double[][][])object2;
        double[][][] res = (double[][][])result;
        int width = res[0][0].length;
        int height = res[0].length;
        int depth = res.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; x += 2) {
                    double img_r = obj1[z][y][x];
                    double img_i = obj1[z][y][x + 1];
                    double mask_r = obj2[z][y][x];
                    double mask_i = obj2[z][y][x + 1];
                    res[z][y][x] = img_r * mask_r - img_i * mask_i;
                    res[z][y][x + 1] = img_r * mask_i + img_i * mask_r;
                }
            }
        }
        res = null;
        obj2 = null;
        obj1 = null;
    }

    @Override
    public void Shift(Object object) {
        if (object instanceof double[][]) {
            ToolsFFT.Shift((double[][])object);
        } else if (object instanceof double[][][]) {
            ToolsFFT.Shift((double[][][])object);
        } else {
            throw new IllegalArgumentException("The array is neither 2D nor 3D array of double.");
        }
    }

    @Override
    public boolean ShiftRequired() {
        return true;
    }

    @Override
    public boolean areDimensionsCorrect(BufferedImage image, Object object) {
        try {
            double[][] obj = (double[][])object;
            return obj.length == Maths.NextPower2((int)image.getHeight()) && obj[0].length == Maths.NextPower2((int)image.getWidth()) << 1;
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public boolean areDimensionsCorrect(DV dv, Object object) {
        try {
            double[][][] obj = (double[][][])object;
            return obj.length == Maths.NextPower2((int)dv.SizeZ) && obj[0].length == Maths.NextPower2((int)dv.SizeY) && obj[0][0].length == Maths.NextPower2((int)dv.SizeX) << 1;
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public boolean areDimensionsCorrect(double[][] image, Object object) {
        try {
            double[][] obj = (double[][])object;
            return obj.length == Maths.NextPower2((int)image.length) && obj[0].length == Maths.NextPower2((int)image[0].length) << 1;
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public FastFourierTransform Clone() {
        return new JTransformsComplex();
    }
}

