/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fourier;

import imageTiTi.ImageConverter;
import java.awt.image.BufferedImage;
import mathematics.complex.Complex;
import mathematics.complex.ComplexConverter;
import mathematics.fourier.ToolsFFT;

public class FHT {
    public static final int DIRECT = -1;
    public static final int INDIRECT = 1;
    public static final int INVERSE = 1;
    private boolean isFrequencyDomain;
    private int maxN;
    private double[] C;
    private double[] S;
    private int[] bitrev;
    private double[] tempArr;
    private double[] fourier;

    public FHT() {
        throw new IllegalArgumentException("Method with BUG.");
    }

    public boolean RequireSquare() {
        return true;
    }

    public void Compute(Complex[][] c, int direction, int nbCPU) {
        if (!this.powerOf2Size(c)) {
            throw new IllegalArgumentException("Array dimensions not power of 2 size or not square.");
        }
        if (this.S == null || this.maxN != c.length) {
            this.maxN = c.length;
            this.makeSinCosTables(this.maxN);
            this.makeBitReverseTable(this.maxN);
            this.tempArr = new double[this.maxN];
        }
        double[] fht = ComplexConverter.ComplexReToDouble1D(c);
        this.fourier = fht;
        this.rc2DFHT(fht, direction, this.maxN);
        ComplexConverter.DoubleToComplex2D(fht, c);
        this.isFrequencyDomain = direction != 1;
    }

    private boolean powerOf2Size(Complex[][] c) {
        int i2;
        int width = c[0].length;
        int height = c.length;
        for (i2 = 2; i2 < width; i2 *= 2) {
        }
        return i2 == width && width == height;
    }

    private void makeSinCosTables(int maxN) {
        int n = maxN >> 2;
        if (this.C != null && n == this.C.length) {
            return;
        }
        this.C = new double[n];
        this.S = new double[n];
        double theta = 0.0;
        double dTheta = Math.PI * 2 / (double)maxN;
        for (int i2 = 0; i2 < n; ++i2) {
            this.C[i2] = Math.cos(theta);
            this.S[i2] = Math.sin(theta);
            theta += dTheta;
        }
    }

    private void makeBitReverseTable(int maxN) {
        this.bitrev = new int[maxN];
        int nLog2 = this.log2(maxN);
        for (int i2 = 0; i2 < maxN; ++i2) {
            this.bitrev[i2] = this.bitRevX(i2, nLog2);
        }
    }

    private void rc2DFHT(double[] x, int direction, int maxN) {
        int row;
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, direction, maxN);
        }
        this.transposeR(x, maxN);
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, direction, maxN);
        }
        this.transposeR(x, maxN);
        int maxn2 = maxN >> 1;
        for (int row2 = 0; row2 <= maxn2; ++row2) {
            for (int col = 0; col <= maxn2; ++col) {
                int mRow = (maxN - row2) % maxN;
                int mCol = (maxN - col) % maxN;
                double A = x[row2 * maxN + col];
                double B = x[mRow * maxN + col];
                double CC = x[row2 * maxN + mCol];
                double D = x[mRow * maxN + mCol];
                double E = (A + D - (B + CC)) / 2.0;
                x[row2 * maxN + col] = A - E;
                x[mRow * maxN + col] = B + E;
                x[row2 * maxN + mCol] = CC + E;
                x[mRow * maxN + mCol] = D - E;
            }
        }
    }

    private void dfht3(double[] x, int base, int direction, int maxN) {
        double rt2;
        double rt1;
        int Ad4;
        int Ad3;
        int Ad2;
        int Ad1;
        int gpNum;
        int Nlog2 = this.log2(maxN);
        this.BitRevRArr(x, base, Nlog2, maxN);
        int gpSize = 2;
        int numGps = maxN >> 2;
        for (gpNum = 0; gpNum < numGps; ++gpNum) {
            Ad1 = gpNum << 2;
            Ad2 = Ad1 + 1;
            Ad3 = Ad1 + gpSize;
            Ad4 = Ad2 + gpSize;
            rt1 = x[base + Ad1] + x[base + Ad2];
            rt2 = x[base + Ad1] - x[base + Ad2];
            double rt3 = x[base + Ad3] + x[base + Ad4];
            double rt4 = x[base + Ad3] - x[base + Ad4];
            x[base + Ad1] = rt1 + rt3;
            x[base + Ad2] = rt2 + rt4;
            x[base + Ad3] = rt1 - rt3;
            x[base + Ad4] = rt2 - rt4;
        }
        if (Nlog2 > 2) {
            gpSize = 4;
            int numBfs = 2;
            numGps >>= 1;
            for (int stage = 2; stage < Nlog2; ++stage) {
                for (gpNum = 0; gpNum < numGps; ++gpNum) {
                    int Ad0;
                    Ad1 = Ad0 = gpNum * gpSize * 2;
                    Ad2 = Ad1 + gpSize;
                    Ad3 = Ad1 + gpSize / 2;
                    Ad4 = Ad3 + gpSize;
                    rt1 = x[base + Ad1];
                    int n = base + Ad1;
                    x[n] = x[n] + x[base + Ad2];
                    x[base + Ad2] = rt1 - x[base + Ad2];
                    rt1 = x[base + Ad3];
                    int n2 = base + Ad3;
                    x[n2] = x[n2] + x[base + Ad4];
                    x[base + Ad4] = rt1 - x[base + Ad4];
                    for (int bfNum = 1; bfNum < numBfs; ++bfNum) {
                        Ad1 = bfNum + Ad0;
                        Ad2 = Ad1 + gpSize;
                        Ad3 = gpSize - bfNum + Ad0;
                        Ad4 = Ad3 + gpSize;
                        int CSAd = bfNum * numGps;
                        rt1 = x[base + Ad2] * this.C[CSAd] + x[base + Ad4] * this.S[CSAd];
                        rt2 = x[base + Ad4] * this.C[CSAd] - x[base + Ad2] * this.S[CSAd];
                        x[base + Ad2] = x[base + Ad1] - rt1;
                        int n3 = base + Ad1;
                        x[n3] = x[n3] + rt1;
                        x[base + Ad4] = x[base + Ad3] + rt2;
                        int n4 = base + Ad3;
                        x[n4] = x[n4] - rt2;
                    }
                }
                gpSize <<= 1;
                numBfs <<= 1;
                numGps >>= 1;
            }
        }
        if (direction == 1) {
            for (int i2 = 0; i2 < maxN; ++i2) {
                int n = base + i2;
                x[n] = x[n] / (double)maxN;
            }
        }
    }

    private void transposeR(double[] x, int maxN) {
        for (int r = 0; r < maxN; ++r) {
            for (int c = r; c < maxN; ++c) {
                if (r == c) continue;
                double rTemp = x[r * maxN + c];
                x[r * maxN + c] = x[c * maxN + r];
                x[c * maxN + r] = rTemp;
            }
        }
    }

    private int log2(int x) {
        int count = 15;
        while (!this.btst(x, count)) {
            --count;
        }
        return count;
    }

    private boolean btst(int x, int bit) {
        return (x & 1 << bit) != 0;
    }

    private void BitRevRArr(double[] x, int base, int bitlen, int maxN) {
        for (int i2 = 0; i2 < maxN; ++i2) {
            this.tempArr[i2] = x[base + this.bitrev[i2]];
        }
        System.arraycopy(this.tempArr, 0, x, base, maxN);
    }

    private int bitRevX(int x, int bitlen) {
        int temp = 0;
        for (int i2 = 0; i2 <= bitlen; ++i2) {
            if ((x & 1 << i2) == 0) continue;
            temp |= 1 << bitlen - i2 - 1;
        }
        return temp & 0xFFFF;
    }

    public BufferedImage PowerSpectrum() {
        double r;
        int col;
        int base;
        int row;
        if (!this.isFrequencyDomain) {
            throw new IllegalArgumentException("Frequency domain image required");
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double[] fps = new double[this.maxN * this.maxN];
        byte[] ps = new byte[fps.length];
        double[] fht = this.fourier;
        for (row = 0; row < this.maxN; ++row) {
            this.FHTps(row, this.maxN, fht, fps);
            base = row * this.maxN;
            for (col = 0; col < this.maxN; ++col) {
                r = fps[base + col];
                if (r < min) {
                    min = r;
                }
                if (!(r > max)) continue;
                max = r;
            }
        }
        min = min < 1.0 ? 0.0 : Math.log(min);
        max = Math.log(max);
        double scale = 253.0 / (max - min);
        for (row = 0; row < this.maxN; ++row) {
            base = row * this.maxN;
            for (col = 0; col < this.maxN; ++col) {
                r = fps[base + col];
                r = r < 1.0 ? 0.0 : Math.log(r);
                ps[base + col] = (byte)((r - min) * scale + 0.5 + 1.0);
            }
        }
        BufferedImage ip = ImageConverter.ByteToImage((byte[])ps, (int)this.maxN, (int)this.maxN);
        ToolsFFT.Shift(ip);
        return ip;
    }

    private void FHTps(int row, int maxN, double[] fht, double[] ps) {
        int base = row * maxN;
        for (int c = 0; c < maxN; ++c) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            ps[base + c] = (this.sqr(fht[base + c]) + this.sqr(fht[l])) / 2.0;
        }
    }

    private double sqr(double x) {
        return x * x;
    }
}

