/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fourier;

import dv.DV;
import java.awt.image.BufferedImage;
import mathematics.fourier.FastFourierTransform;

public class FFT {
    public static final int DIRECT = -1;
    public static final int INDIRECT = 1;
    public static final int INVERSE = 1;
    public FastFourierTransform fft = null;

    public FFT(FastFourierTransform fft) {
        this.fft = fft;
    }

    public Object Compute(BufferedImage source, int nbCPU) {
        Object data = this.fft.Transform(source);
        this.Compute2D(data, -1, nbCPU);
        return data;
    }

    public void Compute(BufferedImage source, Object object, int nbCPU) {
        this.fft.Transform(source, object);
        this.Compute2D(object, -1, nbCPU);
    }

    public void Compute2D(Object data, int direction, int nbCPU) {
        switch (direction) {
            case -1: 
            case 1: {
                this.fft.Compute2D(data, direction, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction (see constants).");
            }
        }
    }

    public void Compute(Object data, BufferedImage result, int nbCPU) {
        this.Compute2D(data, 1, nbCPU);
        if (this.fft.ShiftRequired()) {
            this.fft.Shift(data);
        }
        this.fft.Transform(data, result);
    }

    public Object Compute(DV dv, int nbCPU) {
        Object data = this.fft.Transform(dv);
        this.Compute3D(data, -1, nbCPU);
        return data;
    }

    public void Compute(DV dv, Object object, int nbCPU) {
        this.fft.Transform(dv, object);
        this.Compute3D(object, -1, nbCPU);
    }

    public void Compute3D(Object data, int direction, int nbCPU) {
        switch (direction) {
            case -1: 
            case 1: {
                this.fft.Compute3D(data, direction, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction (see constants).");
            }
        }
    }

    public void Compute(Object data, DV dv, int nbCPU) {
        this.Compute3D(data, 1, nbCPU);
        if (this.fft.ShiftRequired()) {
            this.fft.Shift(data);
        }
        this.fft.Transform(data, dv);
    }
}

