/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fourier;

import dv.DV;
import java.awt.image.BufferedImage;
import mathematics.Maths;
import mathematics.complex.Complex;
import mathematics.complex.ComplexArithmetic;
import mathematics.fourier.FastFourierTransform;
import mathematics.fourier.ToolsFFT;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.StructuringElement;
import morphee.StructuringElement3D;

public class Butterfly
implements FastFourierTransform {
    public static final int DIRECT = -1;
    public static final int INDIRECT = 1;
    public static final int INVERSE = 1;
    private ButterflyThread[] threads = null;
    private int nbFreeThreads = 0;
    private int Width;
    private int Height;
    private int Depth;

    @Override
    public Object CreateObject(int width, int height) {
        Complex[][] obj = ToolsFFT.CreateFreeFFTBuffer(width, height);
        this.Width = width;
        this.Height = height;
        this.Depth = 0;
        return obj;
    }

    @Override
    public Object CreateObject(int width, int height, int depth) {
        Complex[][][] obj = ToolsFFT.CreateFreeFFTBuffer(width, height, depth);
        this.Width = width;
        this.Height = height;
        this.Depth = depth;
        return obj;
    }

    @Override
    public Object CreateObject(BufferedImage image) {
        return this.CreateObject(Maths.NextPower2((int)image.getWidth()), Maths.NextPower2((int)image.getHeight()));
    }

    @Override
    public Object CreateObject(DV dv) {
        return this.CreateObject(Maths.NextPower2((int)dv.SizeX), Maths.NextPower2((int)dv.SizeY), Maths.NextPower2((int)dv.SizeZ));
    }

    @Override
    public Object CreateObject(double[][] image) {
        return this.CreateObject(Maths.NextPower2((int)image[0].length), Maths.NextPower2((int)image.length));
    }

    @Override
    public Object Transform(BufferedImage image) {
        Object result = this.CreateObject(image);
        this.Transform(image, result);
        return result;
    }

    @Override
    public void Transform(BufferedImage image, Object object) {
        Complex[][] obj = (Complex[][])object;
        ToolsFFT.BufferedImageToFreeFFTBuffer_And_Padding(image, obj, 0.0);
        obj = null;
    }

    @Override
    public Object Transform(double[][] image) {
        Object result = this.CreateObject(image);
        this.Transform(image, result);
        return result;
    }

    @Override
    public void Transform(double[][] image, Object object) {
        Complex[][] obj = (Complex[][])object;
        ToolsFFT.DoubleToFreeFFTBuffer_And_Padding(image, obj, 0.0);
        obj = null;
    }

    @Override
    public Object Transform(DV dv) {
        Object result = this.CreateObject(dv);
        this.Transform(dv, result);
        return result;
    }

    @Override
    public void Transform(DV dv, Object object) {
        Complex[][][] obj = (Complex[][][])object;
        ToolsFFT.DvToFreeFFTBuffer_And_Padding(dv, obj, 0.0);
        obj = null;
    }

    @Override
    public Object Transform(StructuringElement se) {
        Object object = this.CreateObject(this.Width, this.Height);
        this.Transform(se, object);
        return object;
    }

    @Override
    public void Transform(StructuringElement se, Object object) {
        Complex[][] obj = (Complex[][])object;
        int width = obj[0].length;
        int height = obj.length;
        if (width != this.Width || height != this.Height) {
            throw new IllegalArgumentException("The last created Object had different dimensions.");
        }
        int dx = (obj[0].length - se.getSizeX() + 1 >> 1) + (se.getSizeX() >> 1);
        int dy = (obj.length - se.getSizeY() + 1 >> 1) + (se.getSizeY() >> 1);
        CoordinatesWeighted[] coords = se.getSE();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                obj[y][x].Init(0.0, 0.0);
            }
        }
        for (int x = 0; x < coords.length; ++x) {
            CoordinatesWeighted c = coords[x];
            obj[dy + c.Y][dx + c.X].Init(c.Wd, 0.0);
            c = null;
        }
        obj = null;
    }

    @Override
    public Object Transform(StructuringElement3D se) {
        throw new Error("Method not implemented (yet).");
    }

    @Override
    public void Transform(StructuringElement3D se, Object object) {
        throw new Error("Method not implemented (yet).");
    }

    @Override
    public void Transform(Object object, BufferedImage image) {
        ToolsFFT.FreeFFTBufferToImage_And_UnPadding((Complex[][])object, image);
    }

    @Override
    public void Transform(Object object, DV dv) {
        ToolsFFT.FreeFFTBufferToDv_And_UnPadding((Complex[][][])object, dv);
    }

    @Override
    public void Transform(Object object, double[][] image) {
        ToolsFFT.FreeFFTBufferToDouble_And_UnPadding((Complex[][])object, image);
    }

    @Override
    public void Multiply2D(Object object1, Object object2, Object result) {
        Complex[][] obj1 = (Complex[][])object1;
        Complex[][] obj2 = (Complex[][])object2;
        Complex[][] res = (Complex[][])result;
        int width = obj1[0].length;
        int height = obj1.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ComplexArithmetic.Mult(obj1[y][x], obj2[y][x], res[y][x]);
            }
        }
        res = null;
        obj2 = null;
        obj1 = null;
    }

    @Override
    public void Multiply3D(Object object1, Object object2, Object result) {
        Complex[][][] obj1 = (Complex[][][])object1;
        Complex[][][] obj2 = (Complex[][][])object2;
        Complex[][][] res = (Complex[][][])result;
        int width = res[0][0].length >> 1;
        int height = res[0].length;
        int depth = res.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    ComplexArithmetic.Mult(obj1[z][y][x], obj2[z][y][x], res[z][y][x]);
                }
            }
        }
        res = null;
        obj2 = null;
        obj1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Compute2D(Object object, int direction, int nbCPU) {
        int x;
        Object object2;
        int y;
        Complex[][] obj = (Complex[][])object;
        if (!Maths.isPowerOf((int)obj.length, (int)2)) {
            throw new IllegalArgumentException("The array has not a dyadic height.");
        }
        if (!Maths.isPowerOf((int)obj[0].length, (int)2)) {
            throw new IllegalArgumentException("The array has not a dyadic width.");
        }
        int nx = obj[0].length;
        int ny = obj.length;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new ButterflyThread[nbCPU];
            for (int i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new ButterflyThread(this);
                this.threads[i2].start();
            }
            Butterfly butterfly = this;
            synchronized (butterfly) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int m = Maths.isDyadic((int)nx);
        int step = ny / nbCPU;
        for (y = 0; y < nbCPU - 1; ++y) {
            this.threads[y].Parameters(obj, true, y * step, (y + 1) * step, m, direction);
            object2 = this.threads[y].lock;
            synchronized (object2) {
                this.threads[y].lock.notify();
                continue;
            }
        }
        this.threads[y].Parameters(obj, true, y * step, ny, m, direction);
        object2 = this.threads[y].lock;
        synchronized (object2) {
            this.threads[y].lock.notify();
        }
        object2 = this;
        synchronized (object2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.nbFreeThreads = 0;
        m = Maths.isDyadic((int)ny);
        step = nx / nbCPU;
        for (x = 0; x < nbCPU - 1; ++x) {
            this.threads[x].Parameters(obj, false, x * step, (x + 1) * step, m, direction);
            object2 = this.threads[x].lock;
            synchronized (object2) {
                this.threads[x].lock.notify();
                continue;
            }
        }
        this.threads[x].Parameters(obj, false, x * step, nx, m, direction);
        object2 = this.threads[x].lock;
        synchronized (object2) {
            this.threads[x].lock.notify();
        }
        object2 = this;
        synchronized (object2) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void Compute3D(Object object, int direction, int nbCPU) {
        throw new Error("Method not implemented (yet).");
    }

    @Override
    public boolean ShiftRequired() {
        return true;
    }

    @Override
    public void Shift(Object object) {
        if (object instanceof Complex[][]) {
            ToolsFFT.Shift((Complex[][])object);
        } else if (object instanceof Complex[][][]) {
            ToolsFFT.Shift((Complex[][][])object);
        } else {
            throw new IllegalArgumentException("The array is neither 2D nor 3D array of Complex.");
        }
    }

    @Override
    public boolean areDimensionsCorrect(BufferedImage image, Object object) {
        try {
            Complex[][] obj = (Complex[][])object;
            return obj.length == Maths.NextPower2((int)image.getHeight()) && obj[0].length == Maths.NextPower2((int)image.getWidth());
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public boolean areDimensionsCorrect(DV dv, Object object) {
        try {
            Complex[][][] obj = (Complex[][][])object;
            return obj.length == Maths.NextPower2((int)dv.SizeZ) && obj[0].length == Maths.NextPower2((int)dv.SizeY) && obj[0][0].length == Maths.NextPower2((int)dv.SizeX);
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public boolean areDimensionsCorrect(double[][] image, Object object) {
        try {
            Complex[][] obj = (Complex[][])object;
            return obj.length == Maths.NextPower2((int)image.length) && obj[0].length == Maths.NextPower2((int)image[0].length);
        }
        catch (ClassCastException E) {
            return false;
        }
    }

    @Override
    public FastFourierTransform Clone() {
        return new Butterfly();
    }

    private synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class ButterflyThread
    extends Thread {
        private Butterfly parent = null;
        public Object lock = new Object();
        private Complex[][] Tab = null;
        private Complex[] buffer = null;
        private int m;
        private int direction;
        private int start;
        private int end;
        private int size;
        private boolean horizontal;

        public ButterflyThread(Butterfly parent) {
            this.parent = parent;
        }

        public void Parameters(Complex[][] Tab, boolean horizontal, int start, int end, int m, int direction) {
            this.Tab = Tab;
            this.horizontal = horizontal;
            this.size = horizontal ? Tab[0].length : Tab.length;
            this.start = start;
            this.end = end;
            this.m = m;
            this.direction = direction;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 7[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

