/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fitting;

import arrayTiTi.ArrayConverter;
import java.util.Arrays;
import mathematics.functions.GaussianGenerator;

public class Gaussian2DFitter {
    protected final double DELTAP = 1.0E-6;
    protected final double BIGVAL = 9.0E99;
    protected int width;
    protected int height;
    protected int NPTS;
    protected int NPARMS = 5;
    private double[] parms = new double[this.NPARMS];
    private double[] data = null;
    private double[] model = null;
    private double[] rtwt = null;
    private double[] resid = null;
    private double[][] jac = null;
    private double error = -1.0;
    private LM myLM = new LM();

    public void Compute(int[] Data, int width, int height) throws Exception {
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height ");
        }
        if (this.data == null || Data.length != this.data.length) {
            this.data = new double[Data.length];
        }
        ArrayConverter.IntToDouble((int[])Data, (double[])this.data);
        this.Compute(width, height);
    }

    public void Compute(short[] Data, int width, int height) throws Exception {
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height ");
        }
        if (this.data == null || Data.length != this.data.length) {
            this.data = new double[Data.length];
        }
        ArrayConverter.UnsignedShortToDouble((short[])Data, (double[])this.data);
        this.Compute(width, height);
    }

    public void Compute(byte[] Data, int width, int height) throws Exception {
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height ");
        }
        if (this.data == null || Data.length != this.data.length) {
            this.data = new double[Data.length];
        }
        ArrayConverter.UnsignedByteToDouble((byte[])Data, (double[])this.data);
        this.Compute(width, height);
    }

    public void Compute(float[] Data, int width, int height) throws Exception {
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height ");
        }
        if (this.data == null || Data.length != this.data.length) {
            this.data = new double[Data.length];
        }
        ArrayConverter.FloatToDouble((float[])Data, (double[])this.data);
        this.Compute(width, height);
    }

    public void Compute(double[] Data, int width, int height) throws Exception {
        if (Data.length != width * height) {
            throw new IllegalArgumentException("Data.length != width*height ");
        }
        if (this.data == null || Data.length != this.data.length) {
            this.data = new double[Data.length];
        }
        System.arraycopy(Data, 0, this.data, 0, Data.length);
        this.Compute(width, height);
    }

    private void Compute(int width, int height) throws Exception {
        this.Allocations(width, height);
        this.putRootWeights();
        this.putStartParms();
        this.myLM.Compute(this, this.NPARMS, this.NPTS);
        this.error = this.dComputeResiduals();
    }

    private void Allocations(int width, int height) {
        this.width = width;
        this.height = height;
        this.NPTS = this.data.length;
        if (this.model == null || this.model.length != this.NPTS) {
            this.model = new double[this.NPTS];
            this.rtwt = new double[this.NPTS];
            this.resid = new double[this.NPTS];
            this.jac = new double[this.NPTS][this.NPARMS];
            return;
        }
        Arrays.fill(this.model, 0.0);
        Arrays.fill(this.rtwt, 0.0);
        Arrays.fill(this.resid, 0.0);
        for (int i2 = 0; i2 < this.jac.length; ++i2) {
            Arrays.fill(this.jac[i2], 0.0);
        }
    }

    private void putStartParms() {
        double biggest = 0.0;
        int ibiggest = 0;
        for (int i2 = 0; i2 < this.NPTS; ++i2) {
            if (!(biggest < this.data[i2])) continue;
            ibiggest = i2;
            biggest = this.data[i2];
        }
        this.parms[0] = ibiggest % this.width;
        this.parms[1] = ibiggest / this.width;
        this.parms[2] = 100000.0;
        this.parms[3] = 1.0;
        this.parms[4] = 100.0;
    }

    private void putRootWeights() {
        for (int i2 = 0; i2 < this.NPTS; ++i2) {
            this.rtwt[i2] = this.data[i2] <= 0.0 ? 0.0 : 1.0 / Math.sqrt(this.data[i2]);
        }
    }

    private double dComputeResiduals() {
        GaussianGenerator.Generate2D(this.parms[0], this.parms[1], this.parms[2], this.parms[3], this.parms[4], this.model, this.width, this.height);
        double sumsq = 0.0;
        for (int i2 = 0; i2 < this.NPTS; ++i2) {
            this.resid[i2] = (this.model[i2] - this.data[i2]) * this.rtwt[i2];
            sumsq += this.resid[i2] * this.resid[i2];
        }
        return sumsq;
    }

    public double dNudge(double[] dp) {
        for (int j = 0; j < this.NPARMS; ++j) {
            int n = j;
            this.parms[n] = this.parms[n] + dp[j];
        }
        return this.dComputeResiduals();
    }

    public void bBuildJacobian() throws Exception {
        double[] delta = new double[this.NPARMS];
        double FACTOR = 500000.0;
        double d = 0.0;
        for (int j = 0; j < this.NPARMS; ++j) {
            int i2;
            int k;
            for (k = 0; k < this.NPARMS; ++k) {
                delta[k] = k == j ? 1.0E-6 : 0.0;
            }
            d = this.dNudge(delta);
            if (d == 9.0E99) {
                throw new Exception("Bad dBuildJacobian() exit 2");
            }
            for (i2 = 0; i2 < this.NPTS; ++i2) {
                this.jac[i2][j] = this.dGetResid(i2);
            }
            for (k = 0; k < this.NPARMS; ++k) {
                delta[k] = k == j ? -2.0E-6 : 0.0;
            }
            d = this.dNudge(delta);
            if (d == 9.0E99) {
                throw new Exception("Bad dBuildJacobian() exit 3");
            }
            for (i2 = 0; i2 < this.NPTS; ++i2) {
                double[] dArray = this.jac[i2];
                int n = j;
                dArray[n] = dArray[n] - this.dGetResid(i2);
            }
            for (i2 = 0; i2 < this.NPTS; ++i2) {
                double[] dArray = this.jac[i2];
                int n = j;
                dArray[n] = dArray[n] * 500000.0;
            }
            for (k = 0; k < this.NPARMS; ++k) {
                delta[k] = k == j ? 1.0E-6 : 0.0;
            }
            d = this.dNudge(delta);
            if (d != 9.0E99) continue;
            throw new Exception("Bad dBuildJacobian() exit 4");
        }
    }

    public double dGetResid(int i2) {
        return this.resid[i2];
    }

    public double dGetJac(int i2, int j) {
        return this.jac[i2][j];
    }

    public double[] Parameters() {
        return this.parms;
    }

    public double CenterX() {
        return this.parms[0];
    }

    public double CenterY() {
        return this.parms[1];
    }

    public double Signal() {
        return this.parms[2];
    }

    public double Sigma() {
        return this.parms[3];
    }

    public double Background() {
        return this.parms[4];
    }

    public double Error() {
        return this.error;
    }

    public void Display(String title) {
        System.out.println(title + ":");
        System.out.println("Center X = " + this.parms[0]);
        System.out.println("Center Y = " + this.parms[1]);
        System.out.println("Magnification = " + this.parms[2]);
        System.out.println("Sigma = " + this.parms[3]);
        System.out.println("Background = " + this.parms[4]);
        System.out.println("Error = " + this.error);
    }

    private class LM {
        private final int LMITER = 100;
        private final double LMBOOST = 2.0;
        private final double LMSHRINK = 0.1;
        private final double LAMBDAZERO = 0.001;
        private final double LAMBDAMAX = 1.0E9;
        private final double LMTOL = 1.0E-12;
        private final double BIGVAL = 9.0E99;
        private double sos;
        private double sosprev;
        private double lambda;
        private Gaussian2DFitter myH = null;
        private int nadj = 0;
        private int npts = 0;
        private double[] delta;
        private double[] beta;
        private double[][] alpha;
        private double[][] amatrix;

        public void Compute(Gaussian2DFitter gH, int gnadj, int gnpts) throws Exception {
            this.myH = gH;
            this.nadj = gnadj;
            this.npts = gnpts;
            if (this.delta == null || this.delta.length != this.nadj) {
                this.delta = new double[this.nadj];
                this.beta = new double[this.nadj];
                this.alpha = new double[this.nadj][this.nadj];
                this.amatrix = new double[this.nadj][this.nadj];
            } else {
                Arrays.fill(this.delta, 0.0);
                Arrays.fill(this.beta, 0.0);
                for (int i2 = 0; i2 < this.alpha.length; ++i2) {
                    Arrays.fill(this.alpha[i2], 0.0);
                    Arrays.fill(this.amatrix[i2], 0.0);
                }
            }
            this.lambda = 0.001;
            int niter = 0;
            boolean done = false;
            while (!(done = this.bLMiter()) && ++niter < 100) {
            }
        }

        private boolean bLMiter() throws Exception {
            int k;
            for (k = 0; k < this.nadj; ++k) {
                this.delta[k] = 0.0;
            }
            this.sos = this.myH.dNudge(this.delta);
            if (this.sos == 9.0E99) {
                throw new Exception("bLMiter finds faulty initial dNudge()");
            }
            this.sosprev = this.sos;
            this.myH.bBuildJacobian();
            for (k = 0; k < this.nadj; ++k) {
                this.beta[k] = 0.0;
                for (int i2 = 0; i2 < this.npts; ++i2) {
                    int n = k;
                    this.beta[n] = this.beta[n] - this.myH.dGetResid(i2) * this.myH.dGetJac(i2, k);
                }
            }
            for (k = 0; k < this.nadj; ++k) {
                for (int j = 0; j < this.nadj; ++j) {
                    this.alpha[j][k] = 0.0;
                    for (int i3 = 0; i3 < this.npts; ++i3) {
                        double[] dArray = this.alpha[j];
                        int n = k;
                        dArray[n] = dArray[n] + this.myH.dGetJac(i3, j) * this.myH.dGetJac(i3, k);
                    }
                }
            }
            double rrise = 0.0;
            do {
                int j;
                int k2;
                for (k2 = 0; k2 < this.nadj; ++k2) {
                    for (j = 0; j < this.nadj; ++j) {
                        this.amatrix[j][k2] = this.alpha[j][k2] + (j == k2 ? this.lambda : 0.0);
                    }
                }
                this.gaussj(this.amatrix, this.nadj);
                for (k2 = 0; k2 < this.nadj; ++k2) {
                    this.delta[k2] = 0.0;
                    for (j = 0; j < this.nadj; ++j) {
                        int n = k2;
                        this.delta[n] = this.delta[n] + this.amatrix[j][k2] * this.beta[j];
                    }
                }
                this.sos = this.myH.dNudge(this.delta);
                if (this.sos == 9.0E99) {
                    throw new Exception("LMinner failed SOS step");
                }
                rrise = (this.sos - this.sosprev) / (1.0 + this.sos);
                if (rrise <= 0.0) {
                    this.lambda *= 0.1;
                    break;
                }
                int q = 0;
                while (q < this.nadj) {
                    int n = q++;
                    this.delta[n] = this.delta[n] * -1.0;
                }
                this.myH.dNudge(this.delta);
                if (rrise < 1.0E-12) break;
                this.lambda *= 2.0;
            } while (this.lambda < 1.0E9);
            return rrise > -1.0E-12 || this.lambda > 1.0E9;
        }

        private double gaussj(double[][] a, int N) {
            double save;
            int j;
            int i2;
            int k;
            double det = 1.0;
            int[] ik = new int[100];
            int[] jk = new int[100];
            for (k = 0; k < N; ++k) {
                double big = 0.0;
                for (i2 = k; i2 < N; ++i2) {
                    for (j = k; j < N; ++j) {
                        if (!(Math.abs(big) <= Math.abs(a[i2][j]))) continue;
                        big = a[i2][j];
                        ik[k] = i2;
                        jk[k] = j;
                    }
                }
                if (big == 0.0) {
                    return 0.0;
                }
                i2 = ik[k];
                if (i2 > k) {
                    for (j = 0; j < N; ++j) {
                        save = a[k][j];
                        a[k][j] = a[i2][j];
                        a[i2][j] = -save;
                    }
                }
                if ((j = jk[k]) > k) {
                    for (i2 = 0; i2 < N; ++i2) {
                        save = a[i2][k];
                        a[i2][k] = a[i2][j];
                        a[i2][j] = -save;
                    }
                }
                for (i2 = 0; i2 < N; ++i2) {
                    if (i2 == k) continue;
                    a[i2][k] = -a[i2][k] / big;
                }
                for (i2 = 0; i2 < N; ++i2) {
                    for (j = 0; j < N; ++j) {
                        if (i2 == k || j == k) continue;
                        double[] dArray = a[i2];
                        int n = j;
                        dArray[n] = dArray[n] + a[i2][k] * a[k][j];
                    }
                }
                for (j = 0; j < N; ++j) {
                    if (j == k) continue;
                    double[] dArray = a[k];
                    int n = j;
                    dArray[n] = dArray[n] / big;
                }
                a[k][k] = 1.0 / big;
                det *= big;
            }
            for (int L = 0; L < N; ++L) {
                k = N - L - 1;
                j = ik[k];
                if (j > k) {
                    for (i2 = 0; i2 < N; ++i2) {
                        save = a[i2][k];
                        a[i2][k] = -a[i2][j];
                        a[i2][j] = save;
                    }
                }
                if ((i2 = jk[k]) <= k) continue;
                for (j = 0; j < N; ++j) {
                    save = a[k][j];
                    a[k][j] = -a[i2][j];
                    a[i2][j] = save;
                }
            }
            return det;
        }
    }
}

